/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf;

import javax.net.ssl.SSLContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.tcf.EventQueue;
import org.eclipse.tcf.core.ChannelTCP;
import org.eclipse.tcf.internal.nls.TcfPluginMessages;
import org.eclipse.tcf.protocol.IEventQueue;
import org.eclipse.tcf.protocol.ILogger;
import org.eclipse.tcf.protocol.IServiceProvider;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.ssl.TCFSecurityManager;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;

public class Activator
extends Plugin {
    public static final String PLUGIN_ID = "org.eclipse.tcf";
    private static Activator plugin;
    private static boolean debug;
    private static final EventQueue queue;
    private static final BundleListener bundle_listener;
    private static boolean TRACE;

    static {
        queue = new EventQueue();
        bundle_listener = new BundleListener(){
            private boolean started = false;

            public void bundleChanged(BundleEvent event) {
                if (plugin != null && !this.started && event.getBundle() == plugin.getBundle() && plugin.getBundle().getState() == 32) {
                    queue.start();
                    this.started = true;
                }
            }
        };
    }

    public Activator() {
        plugin = this;
    }

    public static Activator getDefault() {
        return plugin;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        debug = Platform.inDebugMode();
        TRACE = "true".equals(Platform.getDebugOption((String)"org.eclipse.tcf/debug"));
        if (TRACE && "true".equals(Platform.getDebugOption((String)"org.eclipse.tcf/debug/discovery"))) {
            System.setProperty("org.eclipse.tcf.core.tracing.discovery", "true");
        }
        ChannelTCP.setSSLContext((SSLContext)TCFSecurityManager.createSSLContext());
        Protocol.setLogger((ILogger)new ILogger(){

            public void log(String msg, Throwable x) {
                if (TRACE) {
                    System.out.println(msg);
                    if (x != null) {
                        x.printStackTrace();
                    }
                } else {
                    if (debug) {
                        System.err.println(msg);
                        if (x != null) {
                            x.printStackTrace();
                        }
                    }
                    if (plugin != null && Activator.this.getLog() != null) {
                        Activator.this.getLog().log((IStatus)new Status(4, Activator.this.getBundle().getSymbolicName(), 0, msg, x));
                    }
                }
            }
        });
        Protocol.setEventQueue((IEventQueue)queue);
        Protocol.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                Activator.this.runTCFStartup();
            }
        });
        context.addBundleListener(bundle_listener);
    }

    public void stop(BundleContext context) throws Exception {
        context.removeBundleListener(bundle_listener);
        queue.shutdown();
        plugin = null;
        super.stop(context);
    }

    private void runTCFStartup() {
        try {
            IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint(PLUGIN_ID, "startup");
            IExtension[] extensions = point.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                try {
                    Bundle bundle = Platform.getBundle((String)extensions[i].getNamespaceIdentifier());
                    bundle.start(1);
                    IConfigurationElement[] e = extensions[i].getConfigurationElements();
                    int j = 0;
                    while (j < e.length) {
                        String nm = e[j].getName();
                        if (nm.equals("class")) {
                            Class c = bundle.loadClass(e[j].getAttribute("name"));
                            Class.forName(c.getName(), true, c.getClassLoader());
                        }
                        ++j;
                    }
                }
                catch (Throwable x) {
                    Protocol.log((String)"TCF startup error", (Throwable)x);
                }
                ++i;
            }
        }
        catch (Exception x) {
            Protocol.log((String)"TCF startup error", (Throwable)x);
        }
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint("org.eclipse.tcf.serviceProviders");
        if (point != null) {
            IExtension[] extensions;
            IExtension[] iExtensionArray = extensions = point.getExtensions();
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement[] elements;
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
                int n3 = elements.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement element = iConfigurationElementArray[n4];
                    if ("serviceProvider".equals(element.getName())) {
                        try {
                            IServiceProvider provider = (IServiceProvider)element.createExecutableExtension("class");
                            if (provider != null) {
                                Protocol.addServiceProvider((IServiceProvider)provider);
                            }
                        }
                        catch (CoreException e) {
                            Status status = new Status(4, PLUGIN_ID, NLS.bind((String)TcfPluginMessages.Extension_error_invalidExtensionPoint, (Object)element.getDeclaringExtension().getUniqueIdentifier()), (Throwable)e);
                            Activator.getDefault().getLog().log((IStatus)status);
                        }
                    }
                    ++n4;
                }
                ++n2;
            }
        }
    }
}

