/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.ui.trees;

import java.util.Comparator;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.tcf.te.ui.trees.ColumnDescriptor;
import org.eclipse.tcf.te.ui.trees.Pending;

public class TreeViewerComparator
extends ViewerComparator {
    public int compare(Viewer viewer, Object e1, Object e2) {
        Comparator comparator;
        ColumnDescriptor column;
        if (e1 instanceof Pending || e2 instanceof Pending) {
            return e1 instanceof Pending ? (e2 instanceof Pending ? 0 : 1) : -1;
        }
        Assert.isTrue((boolean)(viewer instanceof TreeViewer));
        Tree tree = ((TreeViewer)viewer).getTree();
        int inverter = this.getSortDirection(tree) == 1024 ? -1 : 1;
        TreeColumn treeColumn = tree.getSortColumn();
        if (treeColumn == null) {
            treeColumn = tree.getColumn(0);
        }
        if (treeColumn != null && !treeColumn.isDisposed() && (column = (ColumnDescriptor)treeColumn.getData()) != null && (comparator = column.getComparator()) != null) {
            return inverter * comparator.compare(e1, e2);
        }
        return inverter * super.compare(viewer, e1, e2);
    }

    int getSortDirection(final Tree tree) {
        if (Display.getCurrent() != null) {
            return tree.getSortDirection();
        }
        final int[] result = new int[1];
        tree.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                result[0] = TreeViewerComparator.this.getSortDirection(tree);
            }
        });
        return result[0];
    }
}

