/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.filesystem.ui.internal.operations;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tcf.te.runtime.interfaces.callback.ICallback;
import org.eclipse.tcf.te.tcf.filesystem.core.interfaces.IOperation;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.exceptions.TCFException;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.operations.IOpExecutor;
import org.eclipse.tcf.te.tcf.filesystem.ui.activator.UIPlugin;
import org.eclipse.tcf.te.tcf.filesystem.ui.dialogs.TimeTriggeredProgressMonitorDialog;
import org.eclipse.ui.PlatformUI;

public class UiExecutor
implements IOpExecutor {
    protected ICallback callback;

    public UiExecutor() {
        this(null);
    }

    public UiExecutor(ICallback callback) {
        this.callback = callback;
    }

    public IStatus execute(final IOperation operation) {
        Assert.isNotNull((Object)Display.getCurrent());
        Shell parent = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        TimeTriggeredProgressMonitorDialog dialog = new TimeTriggeredProgressMonitorDialog(parent, 250);
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    monitor.setTaskName(operation.getName());
                    monitor.beginTask(operation.getName(), operation.getTotalWork());
                    operation.run(monitor);
                }
                finally {
                    monitor.done();
                }
            }
        };
        dialog.setCancelable(true);
        IStatus status = null;
        try {
            dialog.run(true, true, runnable);
            status = Status.OK_STATUS;
        }
        catch (InvocationTargetException e) {
            Throwable throwable = e.getTargetException();
            if (throwable instanceof TCFException) {
                int severity = ((TCFException)throwable).getSeverity();
                status = new Status(severity, UIPlugin.getUniqueIdentifier(), throwable.getMessage(), throwable);
            } else {
                status = new Status(4, UIPlugin.getUniqueIdentifier(), throwable.getMessage(), throwable);
            }
            MessageDialog.openError((Shell)parent, (String)operation.getName(), (String)throwable.getMessage());
        }
        catch (InterruptedException interruptedException) {
            status = Status.OK_STATUS;
        }
        if (this.callback != null) {
            this.callback.done((Object)operation, status);
        }
        return status;
    }
}

