/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.ui.terminals.services;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.tcf.te.runtime.interfaces.callback.ICallback;
import org.eclipse.tcf.te.runtime.interfaces.properties.IPropertiesContainer;
import org.eclipse.tcf.te.runtime.services.AbstractService;
import org.eclipse.tcf.te.runtime.services.interfaces.ITerminalService;
import org.eclipse.tcf.te.runtime.utils.StatusHelper;
import org.eclipse.tcf.te.ui.swt.DisplayUtil;
import org.eclipse.tcf.te.ui.terminals.interfaces.IConnectorType;
import org.eclipse.tcf.te.ui.terminals.manager.ConsoleManager;
import org.eclipse.tcf.te.ui.terminals.nls.Messages;
import org.eclipse.tcf.te.ui.terminals.types.ConnectorManager;
import org.eclipse.tm.internal.terminal.provisional.api.ITerminalConnector;

public class TerminalService
extends AbstractService
implements ITerminalService {
    protected final void executeServiceOperation(IPropertiesContainer properties, final TerminalServiceRunnable runnable, final ICallback callback) {
        Assert.isNotNull((Object)properties);
        Assert.isNotNull((Object)runnable);
        String id = properties.getStringProperty("id");
        String secondaryId = properties.getStringProperty("secondaryId");
        String title = properties.getStringProperty("title");
        Object data = properties.getProperty("data");
        id = this.normalizeId(id, data);
        title = this.normalizeTitle(title, data);
        final ITerminalConnector connector = this.createTerminalConnector(properties);
        if (connector == null) {
            if (callback != null) {
                callback.done((Object)this, StatusHelper.getStatus((Throwable)new IllegalArgumentException(Messages.TerminalService_error_cannotCreateConnector)));
            }
            return;
        }
        final String finId = id;
        final String finSecondaryId = secondaryId;
        final String finTitle = title;
        final Object finData = data;
        if (!runnable.isExecuteAsync()) {
            runnable.run(finId, finSecondaryId, finTitle, connector, finData, callback);
        } else {
            DisplayUtil.safeAsyncExec((Runnable)new Runnable(){

                @Override
                public void run() {
                    runnable.run(finId, finSecondaryId, finTitle, connector, finData, callback);
                }
            });
        }
    }

    protected String normalizeId(String id, Object data) {
        return id != null ? id : "org.eclipse.tcf.te.ui.terminals.TerminalsView";
    }

    protected String normalizeTitle(String title, Object data) {
        if (title != null) {
            return title;
        }
        return Messages.TerminalService_defaultTitle;
    }

    protected ITerminalConnector createTerminalConnector(IPropertiesContainer properties) {
        IConnectorType connectorType;
        Assert.isNotNull((Object)properties);
        ITerminalConnector connector = null;
        String connectorTypeId = properties.getStringProperty("connector.type.id");
        if (connectorTypeId != null && (connectorType = ConnectorManager.getInstance().getConnectorType(connectorTypeId, false)) != null) {
            connector = connectorType.createTerminalConnector(properties);
        }
        return connector;
    }

    public void openConsole(final IPropertiesContainer properties, ICallback callback) {
        Assert.isNotNull((Object)properties);
        this.executeServiceOperation(properties, new TerminalServiceRunnable(){

            @Override
            public void run(String id, String secondaryId, String title, ITerminalConnector connector, Object data, ICallback callback) {
                boolean forceNew = properties.getBooleanProperty("forceNew");
                String encoding = properties.getStringProperty("encoding");
                CTabItem item = ConsoleManager.getInstance().openConsole(id, secondaryId, title, encoding, connector, data, true, forceNew);
                if (item != null) {
                    item.setData("properties", (Object)properties);
                }
                if (callback != null) {
                    callback.done((Object)this, Status.OK_STATUS);
                }
            }
        }, callback);
    }

    public void closeConsole(IPropertiesContainer properties, ICallback callback) {
        Assert.isNotNull((Object)properties);
        this.executeServiceOperation(properties, new TerminalServiceRunnable(){

            @Override
            public void run(String id, String secondaryId, String title, ITerminalConnector connector, Object data, ICallback callback) {
                ConsoleManager.getInstance().closeConsole(id, title, connector, data);
                if (callback != null) {
                    callback.done((Object)this, Status.OK_STATUS);
                }
            }
        }, callback);
    }

    public void terminateConsole(IPropertiesContainer properties, ICallback callback) {
        Assert.isNotNull((Object)properties);
        this.executeServiceOperation(properties, new TerminalServiceRunnable(){

            @Override
            public void run(String id, String secondaryId, String title, ITerminalConnector connector, Object data, ICallback callback) {
                ConsoleManager.getInstance().terminateConsole(id, title, connector, data);
                if (callback != null) {
                    callback.done((Object)this, Status.OK_STATUS);
                }
            }
        }, callback);
    }

    protected static abstract class TerminalServiceRunnable {
        protected TerminalServiceRunnable() {
        }

        public abstract void run(String var1, String var2, String var3, ITerminalConnector var4, Object var5, ICallback var6);

        public boolean isExecuteAsync() {
            return true;
        }
    }
}

