/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.terminals.core.launcher;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.Reader;
import java.io.Writer;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.tcf.protocol.IChannel;
import org.eclipse.tcf.protocol.IPeer;
import org.eclipse.tcf.protocol.IToken;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.services.IStreams;
import org.eclipse.tcf.services.ITerminals;
import org.eclipse.tcf.te.core.async.AsyncCallbackCollector;
import org.eclipse.tcf.te.runtime.callback.Callback;
import org.eclipse.tcf.te.runtime.events.DisposedEvent;
import org.eclipse.tcf.te.runtime.events.EventManager;
import org.eclipse.tcf.te.runtime.interfaces.callback.ICallback;
import org.eclipse.tcf.te.runtime.interfaces.events.IEventListener;
import org.eclipse.tcf.te.runtime.interfaces.properties.IPropertiesContainer;
import org.eclipse.tcf.te.runtime.properties.PropertiesContainer;
import org.eclipse.tcf.te.runtime.services.ServiceManager;
import org.eclipse.tcf.te.runtime.services.interfaces.ITerminalService;
import org.eclipse.tcf.te.tcf.core.Tcf;
import org.eclipse.tcf.te.tcf.core.async.CallbackInvocationDelegate;
import org.eclipse.tcf.te.tcf.core.interfaces.IChannelManager;
import org.eclipse.tcf.te.tcf.core.streams.StreamsDataProvider;
import org.eclipse.tcf.te.tcf.core.streams.StreamsDataReceiver;
import org.eclipse.tcf.te.tcf.terminals.core.activator.CoreBundleActivator;
import org.eclipse.tcf.te.tcf.terminals.core.interfaces.launcher.ITerminalsContextAwareListener;
import org.eclipse.tcf.te.tcf.terminals.core.interfaces.launcher.ITerminalsLauncher;
import org.eclipse.tcf.te.tcf.terminals.core.launcher.TerminalsLauncherEventListener;
import org.eclipse.tcf.te.tcf.terminals.core.launcher.TerminalsListener;
import org.eclipse.tcf.te.tcf.terminals.core.launcher.TerminalsStateChangeEvent;
import org.eclipse.tcf.te.tcf.terminals.core.launcher.TerminalsStreamsListener;
import org.eclipse.tcf.te.tcf.terminals.core.nls.Messages;
import org.osgi.framework.Bundle;

public class TerminalsLauncher
extends PlatformObject
implements ITerminalsLauncher {
    IChannel channel;
    private IPropertiesContainer properties;
    ITerminals svcTerminals;
    IStreams svcStreams;
    ITerminals.TerminalContext terminalContext;
    private ICallback callback;
    private IStreams.StreamsListener streamsListener = null;
    private ITerminals.TerminalsListener terminalsListener = null;
    private IEventListener eventListener = null;

    @Override
    public void dispose() {
        this.terminalContext = null;
        final IChannel finChannel = this.channel;
        if (this.eventListener != null) {
            EventManager.getInstance().removeEventListener(this.eventListener);
            this.eventListener = null;
        }
        AsyncCallbackCollector collector = new AsyncCallbackCollector((ICallback)new Callback(){

            protected void internalDone(Object caller, IStatus status) {
                Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
                if (finChannel != null) {
                    Tcf.getChannelManager().closeChannel(finChannel);
                }
            }
        }, (AsyncCallbackCollector.ICallbackInvocationDelegate)new CallbackInvocationDelegate());
        if (this.streamsListener != null) {
            if (this.streamsListener instanceof TerminalsStreamsListener) {
                ((TerminalsStreamsListener)this.streamsListener).dispose((ICallback)new AsyncCallbackCollector.SimpleCollectorCallback(collector));
            }
            this.streamsListener = null;
        }
        if (this.terminalsListener != null) {
            if (this.terminalsListener instanceof TerminalsListener) {
                ((TerminalsListener)this.terminalsListener).dispose((ICallback)new AsyncCallbackCollector.SimpleCollectorCallback(collector));
            }
            this.terminalsListener = null;
            this.getSvcTerminals().removeListener(this.terminalsListener);
        }
        collector.initDone();
        this.channel = null;
    }

    @Override
    public void exit() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (TerminalsLauncher.this.terminalContext != null) {
                    TerminalsLauncher.this.terminalContext.exit(new ITerminals.DoneCommand(){

                        public void doneCommand(IToken token, Exception error) {
                            TerminalsLauncher.this.onExitDone((this).TerminalsLauncher.this.terminalContext, error);
                        }
                    });
                }
            }
        };
        if (Protocol.isDispatchThread()) {
            runnable.run();
        } else {
            Protocol.invokeAndWait((Runnable)runnable);
        }
    }

    protected void onExitDone(ITerminals.TerminalContext context, Exception error) {
        Assert.isNotNull((Object)context);
        if (error != null) {
            String message = NLS.bind((String)Messages.TerminalsLauncher_error_terminalExitFailed, (Object)context.getProcessID());
            message = String.valueOf(message) + NLS.bind((String)Messages.TerminalsLauncher_error_possibleCause, (Object)error.getLocalizedMessage());
            Status status = new Status(2, CoreBundleActivator.getUniqueIdentifier(), message, (Throwable)error);
            Platform.getLog((Bundle)CoreBundleActivator.getContext().getBundle()).log((IStatus)status);
            this.dispose();
        } else {
            final ITerminals.TerminalContext finContext = context;
            this.getSvcTerminals().getContext(context.getID(), new ITerminals.DoneGetContext(){

                public void doneGetContext(IToken token, Exception error, ITerminals.TerminalContext context) {
                    if (error == null && context != null && context.getID().equals(finContext.getID())) {
                        String message = NLS.bind((String)Messages.TerminalsLauncher_error_terminalExitFailed, (Object)context.getProcessID());
                        message = String.valueOf(message) + Messages.TerminalsLauncher_error_possibleCauseUnknown;
                        Status status = new Status(2, CoreBundleActivator.getUniqueIdentifier(), message);
                        Platform.getLog((Bundle)CoreBundleActivator.getContext().getBundle()).log((IStatus)status);
                        TerminalsLauncher.this.dispose();
                    }
                }
            });
        }
    }

    @Override
    public void launch(final IPeer peer, IPropertiesContainer properties, ICallback callback) {
        Assert.isNotNull((Object)peer);
        Assert.isNotNull((Object)properties);
        this.callback = callback == null ? new Callback(){

            public void internalDone(Object caller, IStatus status) {
            }
        } : callback;
        this.properties = properties;
        HashMap<String, Boolean> flags = new HashMap<String, Boolean>();
        flags.put("forceNew", Boolean.TRUE);
        Tcf.getChannelManager().openChannel(peer, flags, new IChannelManager.DoneOpenChannel(){

            public void doneOpenChannel(Throwable error, IChannel channel) {
                if (error == null) {
                    TerminalsLauncher.this.channel = channel;
                    channel.addChannelListener(new IChannel.IChannelListener(){

                        public void onChannelOpened() {
                        }

                        public void onChannelClosed(Throwable error) {
                            if (error != null) {
                                Status status = new Status(4, CoreBundleActivator.getUniqueIdentifier(), NLS.bind((String)Messages.TerminalsLauncher_error_channelConnectFailed, (Object)peer.getID(), (Object)error.getLocalizedMessage()), error);
                                TerminalsLauncher.this.invokeCallback((IStatus)status, null);
                            }
                        }

                        public void congestionLevel(int level) {
                        }
                    });
                    if (channel.getState() != 1) {
                        Status status = new Status(4, CoreBundleActivator.getUniqueIdentifier(), Messages.TerminalsLauncher_error_channelNotConnected, (Throwable)new IllegalStateException());
                        TerminalsLauncher.this.invokeCallback((IStatus)status, null);
                        return;
                    }
                    TerminalsLauncher.this.svcTerminals = (ITerminals)channel.getRemoteService(ITerminals.class);
                    if (TerminalsLauncher.this.svcTerminals == null) {
                        Status status = new Status(4, CoreBundleActivator.getUniqueIdentifier(), NLS.bind((String)Messages.TerminalsLauncher_error_missingRequiredService, (Object)ITerminals.class.getName()), null);
                        TerminalsLauncher.this.invokeCallback((IStatus)status, null);
                        return;
                    }
                    TerminalsLauncher.this.svcStreams = (IStreams)channel.getRemoteService(IStreams.class);
                    if (TerminalsLauncher.this.svcStreams == null) {
                        Status status = new Status(4, CoreBundleActivator.getUniqueIdentifier(), NLS.bind((String)Messages.TerminalsLauncher_error_missingRequiredService, (Object)IStreams.class.getName()), null);
                        TerminalsLauncher.this.invokeCallback((IStatus)status, null);
                        return;
                    }
                    TerminalsLauncher.this.executeLaunch();
                } else {
                    Status status = new Status(4, CoreBundleActivator.getUniqueIdentifier(), NLS.bind((String)Messages.TerminalsLauncher_error_channelConnectFailed, (Object)peer.getID(), (Object)error.getLocalizedMessage()), error);
                    TerminalsLauncher.this.invokeCallback((IStatus)status, null);
                }
            }
        });
    }

    protected void executeLaunch() {
        final IPropertiesContainer properties = this.getProperties();
        if (properties == null) {
            Status status = new Status(4, CoreBundleActivator.getUniqueIdentifier(), NLS.bind((String)Messages.TerminalsLauncher_error_illegalNullArgument, (Object)"properties"), (Throwable)new IllegalArgumentException());
            this.invokeCallback((IStatus)status, null);
            return;
        }
        this.streamsListener = this.createStreamsListener();
        if (this.streamsListener != null) {
            this.getSvcStreams().subscribe("Terminals", this.streamsListener, new IStreams.DoneSubscribe(){

                public void doneSubscribe(IToken token, Exception error) {
                    if (error != null) {
                        String message = NLS.bind((String)Messages.TerminalsLauncher_error_terminalLaunchFailed, (Object)properties.getStringProperty("connection.name"));
                        message = String.valueOf(message) + NLS.bind((String)Messages.TerminalsLauncher_error_possibleCause, (Object)Messages.TerminalsLauncher_cause_subscribeFailed);
                        Status status = new Status(4, CoreBundleActivator.getUniqueIdentifier(), message, (Throwable)error);
                        TerminalsLauncher.this.invokeCallback((IStatus)status, null);
                    } else {
                        TerminalsLauncher.this.onSubscribeStreamsDone();
                    }
                }
            });
        } else {
            this.onAttachStreamsDone();
        }
    }

    protected void onSubscribeStreamsDone() {
        IPropertiesContainer properties = this.getProperties();
        if (properties == null) {
            Status status = new Status(4, CoreBundleActivator.getUniqueIdentifier(), NLS.bind((String)Messages.TerminalsLauncher_error_illegalNullArgument, (Object)"properties"), (Throwable)new IllegalArgumentException());
            this.invokeCallback((IStatus)status, null);
            return;
        }
        this.eventListener = new TerminalsLauncherEventListener(this);
        EventManager.getInstance().addEventListener(this.eventListener, DisposedEvent.class);
        ITerminalService terminal = (ITerminalService)ServiceManager.getInstance().getService(ITerminalService.class);
        if (terminal != null) {
            PropertiesContainer props = new PropertiesContainer();
            props.setProperty("delegateId", properties.getProperty("delegateId"));
            props.setProperty("tm.terminal.connector.id", properties.getProperty("tm.terminal.connector.id"));
            props.setProperty("connector.type.id", properties.getProperty("connector.type.id"));
            props.setProperty("encoding", properties.getProperty("encoding"));
            props.setProperty("selection", properties.getProperty("selection"));
            props.setProperty("forceNew", true);
            String terminalTitle = this.getTerminalTitle();
            if (terminalTitle != null) {
                props.setProperty("title", (Object)terminalTitle);
            }
            props.setProperty("streams.stdin", (Object)this.connectRemoteOutputStream(this.getStreamsListener(), new String[]{"StdInID"}));
            props.setProperty("streams.stdout", (Object)this.connectRemoteInputStream(this.getStreamsListener(), new String[]{"StdOutID"}));
            props.setProperty("streams.stderr", (Object)this.connectRemoteInputStream(this.getStreamsListener(), new String[]{"StdErrID"}));
            props.setProperty("localEcho", properties.getBooleanProperty("localEcho"));
            props.setProperty("lineSeparator", (Object)properties.getStringProperty("lineSeparator"));
            props.setProperty("data", (Object)this);
            terminal.openConsole((IPropertiesContainer)props, null);
        }
        if (properties.getStringProperty("terminal.redirectToFile") != null) {
            String filename = properties.getStringProperty("terminal.redirectToFile");
            try {
                StreamsDataReceiver receiver = new StreamsDataReceiver((Writer)new BufferedWriter(new FileWriter(filename)), new String[]{"StdOutID", "StdErrID"});
                if (this.getStreamsListener() instanceof TerminalsStreamsListener) {
                    ((TerminalsStreamsListener)this.getStreamsListener()).registerDataReceiver(receiver);
                }
            }
            catch (IOException e) {
                String message = NLS.bind((String)Messages.TerminalsLauncher_error_terminalLaunchFailed, (Object)properties.getStringProperty("connection.name"));
                message = String.valueOf(message) + NLS.bind((String)Messages.TerminalsLauncher_error_possibleCause, (Object)(e.getLocalizedMessage() != null ? e.getLocalizedMessage() : Messages.TerminalsLauncher_cause_ioexception));
                Status status = new Status(4, CoreBundleActivator.getUniqueIdentifier(), message, (Throwable)e);
                this.invokeCallback((IStatus)status, null);
            }
        }
        this.onAttachStreamsDone();
    }

    protected String getTerminalTitle() {
        if (this.properties == null) {
            return null;
        }
        StringBuilder title = new StringBuilder();
        final AtomicReference<String> peerName = new AtomicReference<String>(this.getProperties().getStringProperty("connection.name"));
        if (peerName.get() == null) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    if (TerminalsLauncher.this.channel != null) {
                        peerName.set(TerminalsLauncher.this.channel.getRemotePeer().getName());
                    }
                }
            };
            if (Protocol.isDispatchThread()) {
                runnable.run();
            } else {
                Protocol.invokeAndWait((Runnable)runnable);
            }
        }
        if (peerName.get() != null) {
            title.append("[").append(peerName.get()).append("]");
        }
        DateFormat format = DateFormat.getDateTimeInstance(3, 3);
        String date = format.format(new Date(System.currentTimeMillis()));
        title.append(" (").append(date).append(")");
        return title.toString();
    }

    protected InputStream connectRemoteInputStream(IStreams.StreamsListener streamsListener, String[] streamIds) {
        Assert.isNotNull((Object)streamsListener);
        Assert.isNotNull((Object)streamIds);
        PipedInputStream stream = null;
        PipedOutputStream remoteStreamDataReceiverStream = new PipedOutputStream();
        try {
            stream = new PipedInputStream(remoteStreamDataReceiverStream);
        }
        catch (IOException iOException) {}
        if (stream != null) {
            StreamsDataReceiver receiver = new StreamsDataReceiver((Writer)new OutputStreamWriter(remoteStreamDataReceiverStream), streamIds);
            if (this.getStreamsListener() instanceof TerminalsStreamsListener) {
                ((TerminalsStreamsListener)this.getStreamsListener()).registerDataReceiver(receiver);
            }
        }
        return stream;
    }

    protected OutputStream connectRemoteOutputStream(IStreams.StreamsListener streamsListener, String[] streamIds) {
        Assert.isNotNull((Object)streamsListener);
        Assert.isNotNull((Object)streamIds);
        PipedInputStream inStream = null;
        PipedOutputStream stream = new PipedOutputStream();
        try {
            inStream = new PipedInputStream(stream);
        }
        catch (IOException iOException) {
            stream = null;
        }
        if (stream != null && inStream != null) {
            StreamsDataProvider provider = new StreamsDataProvider((Reader)new InputStreamReader(inStream), streamIds);
            if (this.getStreamsListener() instanceof TerminalsStreamsListener) {
                ((TerminalsStreamsListener)this.getStreamsListener()).setDataProvider(provider);
            }
        }
        return stream;
    }

    protected void onAttachStreamsDone() {
        String type;
        final IPropertiesContainer properties = this.getProperties();
        if (properties == null) {
            Status status = new Status(4, CoreBundleActivator.getUniqueIdentifier(), NLS.bind((String)Messages.TerminalsLauncher_error_illegalNullArgument, (Object)"properties"), (Throwable)new IllegalArgumentException());
            this.invokeCallback((IStatus)status, null);
            return;
        }
        this.terminalsListener = this.createTerminalsListener();
        if (this.terminalsListener != null) {
            this.getSvcTerminals().addListener(this.terminalsListener);
        }
        if ((type = properties.getStringProperty("terminals.type")) == null || "".equals(type.trim())) {
            type = "ansi";
        }
        String encoding = properties.getStringProperty("terminals.cwd");
        Map env = (Map)properties.getProperty("terminals.env");
        this.getSvcTerminals().launch(type, encoding, env != null ? this.makeEnvironmentArray(env) : null, new ITerminals.DoneLaunch(){

            public void doneLaunch(IToken token, Exception error, ITerminals.TerminalContext terminal) {
                if (error != null) {
                    String message = NLS.bind((String)Messages.TerminalsLauncher_error_terminalLaunchFailed, (Object)properties.getStringProperty("connection.name"));
                    message = String.valueOf(message) + NLS.bind((String)Messages.TerminalsLauncher_error_possibleCause, (Object)(error.getLocalizedMessage() != null ? error.getLocalizedMessage() : Messages.TerminalsLauncher_cause_startFailed));
                    Status status = new Status(4, CoreBundleActivator.getUniqueIdentifier(), message, (Throwable)error);
                    TerminalsLauncher.this.invokeCallback((IStatus)status, null);
                } else {
                    TerminalsLauncher.this.onTerminalLaunchDone(terminal);
                }
            }
        });
    }

    protected void onTerminalLaunchDone(ITerminals.TerminalContext terminal) {
        if (terminal != null) {
            TerminalsStateChangeEvent event;
            if (CoreBundleActivator.getTraceHandler().isSlotEnabled(0, "trace/terminalsLauncher")) {
                CoreBundleActivator.getTraceHandler().trace("Terminal context created: id='" + terminal.getID() + "', PTY type='" + terminal.getPtyType() + "'", 0, "trace/terminalsLauncher", 1, this.getClass());
            }
            this.terminalContext = terminal;
            if (this.getStreamsListener() instanceof ITerminalsContextAwareListener) {
                ((ITerminalsContextAwareListener)this.getStreamsListener()).setTerminalsContext(terminal);
            }
            if (this.getTerminalsListener() instanceof ITerminalsContextAwareListener) {
                ((ITerminalsContextAwareListener)this.getTerminalsListener()).setTerminalsContext(terminal);
            }
            if ((event = this.createRemoteTerminalsStateChangeEvent(terminal)) != null) {
                EventManager.getInstance().fireEvent((EventObject)((Object)event));
            }
        }
        this.invokeCallback(Status.OK_STATUS, terminal);
    }

    protected TerminalsStateChangeEvent createRemoteTerminalsStateChangeEvent(ITerminals.TerminalContext context) {
        Assert.isNotNull((Object)context);
        return new TerminalsStateChangeEvent(context, "created", Boolean.FALSE, Boolean.TRUE, -1);
    }

    protected void invokeCallback(IStatus status, Object result) {
        ICallback callback;
        if (status.getSeverity() == 4) {
            this.dispose();
        }
        if ((callback = this.getCallback()) != null) {
            callback.setResult(result);
            callback.done((Object)this, status);
        }
    }

    public final IChannel getChannel() {
        return this.channel;
    }

    public final IPropertiesContainer getProperties() {
        return this.properties;
    }

    public final ITerminals getSvcTerminals() {
        return this.svcTerminals;
    }

    public final IStreams getSvcStreams() {
        return this.svcStreams;
    }

    protected final ICallback getCallback() {
        return this.callback;
    }

    protected IStreams.StreamsListener createStreamsListener() {
        return new TerminalsStreamsListener(this);
    }

    protected final IStreams.StreamsListener getStreamsListener() {
        return this.streamsListener;
    }

    protected ITerminals.TerminalsListener createTerminalsListener() {
        return new TerminalsListener(this);
    }

    protected final ITerminals.TerminalsListener getTerminalsListener() {
        return this.terminalsListener;
    }

    public Object getAdapter(Class adapter) {
        if (adapter.isAssignableFrom(ITerminals.TerminalsListener.class)) {
            return this.terminalsListener;
        }
        if (adapter.isAssignableFrom(IStreams.StreamsListener.class)) {
            return this.streamsListener;
        }
        if (adapter.isAssignableFrom(IStreams.class)) {
            return this.svcStreams;
        }
        if (adapter.isAssignableFrom(ITerminals.class)) {
            return this.svcTerminals;
        }
        if (adapter.isAssignableFrom(IChannel.class)) {
            return this.channel;
        }
        if (adapter.isAssignableFrom(IPropertiesContainer.class)) {
            return this.properties;
        }
        if (adapter.isAssignableFrom(ITerminals.TerminalContext.class)) {
            return this.terminalContext;
        }
        if (adapter.isAssignableFrom(this.getClass())) {
            return this;
        }
        return super.getAdapter(adapter);
    }

    private String[] makeEnvironmentArray(Map<String, String> env) {
        Assert.isNotNull(env);
        ArrayList<String> envList = new ArrayList<String>();
        for (Map.Entry<String, String> entry : env.entrySet()) {
            String listEntry = String.valueOf(entry.getKey().trim()) + "=" + entry.getValue().trim();
            envList.add(listEntry);
        }
        return envList.toArray(new String[envList.size()]);
    }
}

