/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.cdt.ui.breakpoints;

import org.eclipse.cdt.debug.core.model.ICBreakpoint;
import org.eclipse.cdt.debug.ui.breakpoints.ICBreakpointContext;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceStore;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.tcf.internal.cdt.ui.breakpoints.BreakpointScopeCategory;
import org.eclipse.tcf.internal.cdt.ui.breakpoints.TCFBreakpointScopeExtension;
import org.eclipse.tcf.internal.cdt.ui.breakpoints.TCFThreadFilterEditor;
import org.eclipse.ui.dialogs.PropertyPage;

public class TCFBreakpointThreadFilterPage
extends PropertyPage {
    private TCFThreadFilterEditor fThreadFilterEditor;
    private TCFBreakpointScopeExtension fFilterExtension;

    protected Control createContents(Composite parent) {
        BreakpointScopeCategory category = this.getScopeCategory();
        if (category != null) {
            TCFBreakpointScopeExtension filterExtension = this.getFilterExtension();
            filterExtension.setPropertiesFilter(category.getFilter());
            filterExtension.setRawContextIds(category.getContextIds());
        }
        this.noDefaultAndApplyButton();
        Composite fieldEditorComposite = new Composite(parent, 0);
        fieldEditorComposite.setLayout((Layout)new GridLayout(1, false));
        this.createThreadFilterEditor(fieldEditorComposite);
        this.setValid(true);
        return fieldEditorComposite;
    }

    protected ICBreakpoint getBreakpoint() {
        if (this.getElement() instanceof ICBreakpointContext) {
            return ((ICBreakpointContext)this.getElement()).getBreakpoint();
        }
        return (ICBreakpoint)this.getElement().getAdapter(ICBreakpoint.class);
    }

    public IPreferenceStore getPreferenceStore() {
        IAdaptable element = this.getElement();
        if (element instanceof ICBreakpointContext) {
            return ((ICBreakpointContext)element).getPreferenceStore();
        }
        return this.getContainer().getPreferenceStore();
    }

    protected BreakpointScopeCategory getScopeCategory() {
        if (this.getElement() instanceof BreakpointScopeCategory) {
            return (BreakpointScopeCategory)this.getElement();
        }
        return null;
    }

    protected TCFBreakpointScopeExtension getFilterExtension() {
        if (this.fFilterExtension != null) {
            return this.fFilterExtension;
        }
        this.fFilterExtension = new TCFBreakpointScopeExtension();
        BreakpointScopeCategory category = this.getScopeCategory();
        if (category != null) {
            this.fFilterExtension.initialize((IPreferenceStore)new PreferenceStore());
            this.fFilterExtension.setPropertiesFilter(category.getFilter());
            this.fFilterExtension.setRawContextIds(category.getContextIds());
        } else {
            this.fFilterExtension.initialize(this.getPreferenceStore());
        }
        return this.fFilterExtension;
    }

    protected void createThreadFilterEditor(Composite parent) {
        this.fThreadFilterEditor = new TCFThreadFilterEditor(parent, this);
    }

    protected TCFThreadFilterEditor getThreadFilterEditor() {
        return this.fThreadFilterEditor;
    }

    public boolean performOk() {
        this.doStore();
        return super.performOk();
    }

    protected void doStore() {
        this.fThreadFilterEditor.doStore();
        BreakpointScopeCategory scopeCategory = this.getScopeCategory();
        if (scopeCategory != null) {
            TCFBreakpointScopeExtension filterExtension = this.getFilterExtension();
            scopeCategory.setFilter(filterExtension.getPropertiesFilter(), filterExtension.getRawContextIds());
        }
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.fThreadFilterEditor.setInitialCheckedState();
            this.fThreadFilterEditor.setupScopeExpressionCombo();
        } else {
            this.doStore();
        }
        super.setVisible(visible);
    }
}

