/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.cdt.ui.breakpoints;

import java.util.Map;
import org.eclipse.cdt.core.IAddress;
import org.eclipse.cdt.debug.core.CDIDebugModel;
import org.eclipse.cdt.debug.core.model.ICAddressBreakpoint;
import org.eclipse.cdt.debug.core.model.ICBreakpoint;
import org.eclipse.cdt.debug.core.model.ICLineBreakpoint;
import org.eclipse.cdt.dsf.debug.ui.actions.AbstractDisassemblyBreakpointsTarget;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.tcf.internal.cdt.ui.breakpoints.TCFToggleBreakpointAdapter;
import org.eclipse.ui.IWorkbenchPart;

public class TCFDisassemblyToggleBreakpointAdapter
extends AbstractDisassemblyBreakpointsTarget {
    private final String TOGGLE_TYPE;
    private IWorkbenchPart fTogglePart;

    TCFDisassemblyToggleBreakpointAdapter(String toggle_type) {
        this.TOGGLE_TYPE = toggle_type;
    }

    public void toggleLineBreakpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
        this.fTogglePart = part;
        super.toggleLineBreakpoints(part, selection);
        this.fTogglePart = null;
    }

    protected void createLineBreakpoint(String sourceHandle, IResource resource, int lineNumber) throws CoreException {
        CDIDebugModel.createLineBreakpoint((String)sourceHandle, (IResource)resource, (int)this.getBreakpointType(), (int)lineNumber, (boolean)true, (int)0, (String)"", (boolean)true);
        Map<String, Object> attributes = TCFToggleBreakpointAdapter.getDefaultAttributes(this.fTogglePart, this.TOGGLE_TYPE);
        ICLineBreakpoint lineBp = CDIDebugModel.createBlankLineBreakpoint();
        CDIDebugModel.setLineBreakpointAttributes(attributes, (String)sourceHandle, (Integer)this.getBreakpointType(), (int)lineNumber, (boolean)true, (int)0, (String)"");
        CDIDebugModel.createBreakpointMarker((ICBreakpoint)lineBp, (IResource)resource, attributes, (boolean)true);
    }

    protected void createLineBreakpointInteractive(IWorkbenchPart part, String sourceHandle, IResource resource, int lineNumber) throws CoreException {
        ICLineBreakpoint lineBp = CDIDebugModel.createBlankLineBreakpoint();
        Map<String, Object> attributes = TCFToggleBreakpointAdapter.getDefaultAttributes(this.fTogglePart, this.TOGGLE_TYPE);
        CDIDebugModel.setLineBreakpointAttributes(attributes, (String)sourceHandle, (Integer)this.getBreakpointType(), (int)lineNumber, (boolean)true, (int)0, (String)"");
        this.openBreakpointPropertiesDialog((ICBreakpoint)lineBp, part, resource, attributes);
    }

    protected void createAddressBreakpoint(IResource resource, IAddress address) throws CoreException {
        CDIDebugModel.createAddressBreakpoint(null, null, (IResource)resource, (int)this.getBreakpointType(), (IAddress)address, (boolean)true, (int)0, (String)"", (boolean)true);
    }

    protected void createAddressBreakpointInteractive(IWorkbenchPart part, IResource resource, IAddress address) throws CoreException {
        ICAddressBreakpoint lineBp = CDIDebugModel.createBlankAddressBreakpoint();
        Map<String, Object> attributes = TCFToggleBreakpointAdapter.getDefaultAttributes(this.fTogglePart, this.TOGGLE_TYPE);
        CDIDebugModel.setAddressBreakpointAttributes(attributes, null, null, (int)this.getBreakpointType(), (int)-1, (IAddress)address, (boolean)true, (int)0, (String)"");
        this.openBreakpointPropertiesDialog((ICBreakpoint)lineBp, part, resource, attributes);
    }

    protected int getBreakpointType() {
        return 0;
    }
}

