/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.cdt.ui.breakpoints;

import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.actions.IToggleBreakpointsTarget;
import org.eclipse.debug.ui.actions.IToggleBreakpointsTargetFactory;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.tcf.internal.cdt.ui.breakpoints.Messages;
import org.eclipse.tcf.internal.cdt.ui.breakpoints.TCFToggleBreakpointAdapter;
import org.eclipse.tcf.internal.debug.ui.model.TCFNode;
import org.eclipse.ui.IWorkbenchPart;

public class TCFToggleBreakpointsTargetFactory
implements IToggleBreakpointsTargetFactory {
    public static final String ID_TCF_BREAKPOINT_TOGGLE_TARGET = "org.eclipse.tcf.debug.toggleTCFBreakpoint";
    private static final Set<String> BP_TOGGLE_TYPE_SET = new HashSet<String>(2);
    private Map<String, TCFToggleBreakpointAdapter> fAdapterMap = new HashMap<String, TCFToggleBreakpointAdapter>();

    static {
        BP_TOGGLE_TYPE_SET.add(ID_TCF_BREAKPOINT_TOGGLE_TARGET);
    }

    public IToggleBreakpointsTarget createToggleTarget(String targetID) {
        TCFToggleBreakpointAdapter adapter = null;
        if (ID_TCF_BREAKPOINT_TOGGLE_TARGET.equals(targetID)) {
            if (this.fAdapterMap != null && !this.fAdapterMap.isEmpty()) {
                adapter = this.fAdapterMap.get(ID_TCF_BREAKPOINT_TOGGLE_TARGET);
            }
            if (adapter == null) {
                adapter = new TCFToggleBreakpointAdapter(ID_TCF_BREAKPOINT_TOGGLE_TARGET);
                this.fAdapterMap.put(ID_TCF_BREAKPOINT_TOGGLE_TARGET, adapter);
            }
        }
        return adapter;
    }

    public String getToggleTargetDescription(String targetID) {
        if (ID_TCF_BREAKPOINT_TOGGLE_TARGET.equals(targetID)) {
            String scope = TCFToggleBreakpointsTargetFactory.getDefaultBPContextQuery();
            if (scope == null) {
                scope = "None";
            }
            return MessageFormat.format(Messages.TCFBreakpointToggle, scope);
        }
        return null;
    }

    public String getToggleTargetName(String targetID) {
        if (ID_TCF_BREAKPOINT_TOGGLE_TARGET.equals(targetID)) {
            String scope = TCFToggleBreakpointsTargetFactory.getDefaultBPContextQuery();
            if (scope == null) {
                scope = "None";
            }
            return MessageFormat.format(Messages.TCFBreakpointToggle, scope);
        }
        return null;
    }

    public String getDefaultToggleTarget(IWorkbenchPart part, ISelection selection) {
        if (TCFToggleBreakpointsTargetFactory.isTCFBreakpointActive(part, selection)) {
            return ID_TCF_BREAKPOINT_TOGGLE_TARGET;
        }
        return null;
    }

    public Set<String> getToggleTargets(IWorkbenchPart part, ISelection selection) {
        if (TCFToggleBreakpointsTargetFactory.isTCFBreakpointActive(part, selection)) {
            return BP_TOGGLE_TYPE_SET;
        }
        return Collections.emptySet();
    }

    private static IStructuredSelection getDebugContext(IWorkbenchPart part) {
        ISelection selection = DebugUITools.getDebugContextManager().getContextService(part.getSite().getWorkbenchWindow()).getActiveContext();
        if (selection instanceof IStructuredSelection) {
            return (IStructuredSelection)selection;
        }
        return StructuredSelection.EMPTY;
    }

    private static boolean isTCFBreakpointActive(IWorkbenchPart part, ISelection selection) {
        Object obj;
        if (selection != null && !selection.isEmpty() && selection instanceof IStructuredSelection && (obj = ((IStructuredSelection)selection).getFirstElement()) instanceof TCFNode) {
            return true;
        }
        return part != null && (obj = TCFToggleBreakpointsTargetFactory.getDebugContext(part).getFirstElement()) instanceof TCFNode;
    }

    private static boolean isDefaultBPContextQueryEnabled() {
        return Platform.getPreferencesService().getBoolean("org.eclipse.tcf.cdt.ui", "org.eclipse.tcf.cdt.ui.preferences.BreakpointPreferencePage.setDefaultTriggerScopeEnabled", false, null);
    }

    private static String getDefaultBPContextQuery() {
        String result = null;
        if (TCFToggleBreakpointsTargetFactory.isDefaultBPContextQueryEnabled()) {
            result = Platform.getPreferencesService().getString("org.eclipse.tcf.cdt.ui", "org.eclipse.tcf.cdt.ui.preferences.BreakpointPreferencePage.defaultTriggerExpression", null, null);
        }
        return result;
    }
}

