/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.processes.core.launcher;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CancellationException;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.tcf.protocol.IChannel;
import org.eclipse.tcf.protocol.IToken;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.services.IProcesses;
import org.eclipse.tcf.services.IProcessesV1;
import org.eclipse.tcf.services.IStreams;
import org.eclipse.tcf.te.core.async.AsyncCallbackCollector;
import org.eclipse.tcf.te.runtime.callback.Callback;
import org.eclipse.tcf.te.runtime.interfaces.callback.ICallback;
import org.eclipse.tcf.te.tcf.core.async.CallbackInvocationDelegate;
import org.eclipse.tcf.te.tcf.core.streams.StreamsDataProvider;
import org.eclipse.tcf.te.tcf.core.streams.StreamsDataReceiver;
import org.eclipse.tcf.te.tcf.core.util.ExceptionUtils;
import org.eclipse.tcf.te.tcf.processes.core.activator.CoreBundleActivator;
import org.eclipse.tcf.te.tcf.processes.core.interfaces.launcher.IProcessContextAwareListener;
import org.eclipse.tcf.te.tcf.processes.core.launcher.ProcessLauncher;
import org.eclipse.tcf.te.tcf.processes.core.nls.Messages;
import org.eclipse.tcf.util.TCFTask;
import org.osgi.framework.Bundle;

public class ProcessStreamsListener
implements IStreams.StreamsListener,
IProcessContextAwareListener {
    IChannel channel;
    IStreams svcStreams;
    String svcProcessesName;
    private IProcesses.ProcessContext context;
    private final List<StreamsDataReceiver> dataReceiver = new ArrayList<StreamsDataReceiver>();
    private StreamsDataProvider dataProvider;
    private final List<StreamCreatedEvent> delayedCreatedEvents = new ArrayList<StreamCreatedEvent>();
    private final List<Runnable> runnables = new ArrayList<Runnable>();

    public ProcessStreamsListener(ProcessLauncher parent) {
        Assert.isNotNull((Object)parent);
        this.channel = parent.getChannel();
        this.svcStreams = parent.getSvcStreams();
        this.svcProcessesName = parent.getSvcProcesses() instanceof IProcessesV1 ? "ProcessesV1" : "Processes";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose(final ICallback callback) {
        ArrayList<StreamsDataReceiver> finDataReceivers;
        final ProcessStreamsListener finStreamsListener = this;
        List<StreamsDataReceiver> list = this.dataReceiver;
        synchronized (list) {
            finDataReceivers = new ArrayList<StreamsDataReceiver>(this.dataReceiver);
            this.dataReceiver.clear();
        }
        AsyncCallbackCollector collector = new AsyncCallbackCollector((ICallback)new Callback(){

            protected void internalDone(final Object caller, final IStatus status) {
                Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
                ProcessStreamsListener.this.svcStreams.unsubscribe(ProcessStreamsListener.this.svcProcessesName, finStreamsListener, new IStreams.DoneUnsubscribe(){

                    public void doneUnsubscribe(IToken token, Exception error) {
                        for (StreamsDataReceiver receiver : finDataReceivers) {
                            receiver.dispose();
                        }
                        if (callback != null) {
                            callback.done(caller, status);
                        }
                    }
                });
            }
        }, (AsyncCallbackCollector.ICallbackInvocationDelegate)new CallbackInvocationDelegate());
        List<Runnable> list2 = this.runnables;
        synchronized (list2) {
            for (Runnable runnable : this.runnables) {
                if (!(runnable instanceof StreamReaderRunnable)) continue;
                ((StreamReaderRunnable)runnable).stop((ICallback)new AsyncCallbackCollector.SimpleCollectorCallback(collector));
            }
            this.runnables.clear();
        }
        collector.initDone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerDataReceiver(StreamsDataReceiver receiver) {
        Assert.isNotNull((Object)receiver);
        List<StreamsDataReceiver> list = this.dataReceiver;
        synchronized (list) {
            if (!this.dataReceiver.contains(receiver)) {
                this.dataReceiver.add(receiver);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterDataReceiver(StreamsDataReceiver receiver) {
        Assert.isNotNull((Object)receiver);
        List<StreamsDataReceiver> list = this.dataReceiver;
        synchronized (list) {
            this.dataReceiver.remove(receiver);
        }
    }

    public void setDataProvider(StreamsDataProvider provider) {
        this.dataProvider = provider;
    }

    public StreamsDataProvider getDataProvider() {
        return this.dataProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setProcessContext(IProcesses.ProcessContext context) {
        Assert.isNotNull((Object)context);
        this.context = context;
        if (CoreBundleActivator.getTraceHandler().isSlotEnabled(0, "trace/launcher/streamsListener")) {
            CoreBundleActivator.getTraceHandler().trace("Process context set to: id='" + context.getID() + "', name='" + context.getName() + "'", 0, "trace/launcher/streamsListener", 1, this.getClass());
        }
        List<StreamCreatedEvent> list = this.delayedCreatedEvents;
        synchronized (list) {
            for (StreamCreatedEvent event : this.delayedCreatedEvents) {
                if (!context.getID().equals(event.contextId) && event.contextId != null) continue;
                this.created(event.streamType, event.streamId, event.contextId);
            }
            this.delayedCreatedEvents.clear();
        }
    }

    @Override
    public IProcesses.ProcessContext getProcessContext() {
        return this.context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void created(String streamType, String streamId, String contextId) {
        IProcesses.ProcessContext context;
        if (!this.svcProcessesName.equals(streamType)) {
            return;
        }
        if (CoreBundleActivator.getTraceHandler().isSlotEnabled(0, "trace/launcher/streamsListener")) {
            CoreBundleActivator.getTraceHandler().trace("New remote process stream created: streamId='" + streamId + "', contextId='" + contextId + "'", 0, "trace/launcher/streamsListener", 1, this.getClass());
        }
        if ((context = this.getProcessContext()) != null && (context.getID().equals(contextId) || contextId == null)) {
            Object thread;
            Runnable runnable;
            StreamsDataReceiver[] receivers;
            List<StreamsDataReceiver> list = this.dataReceiver;
            synchronized (list) {
                receivers = this.dataReceiver.toArray(new StreamsDataReceiver[this.dataReceiver.size()]);
            }
            if (streamId != null && streamId.equals(context.getProperties().get("StdInID")) && this.dataProvider != null) {
                runnable = new ProcessStreamWriterRunnable(streamId, "StdInID", this.dataProvider);
                List<Runnable> list2 = this.runnables;
                synchronized (list2) {
                    this.runnables.add(runnable);
                }
                thread = new Thread(runnable, "Thread-StdInID-" + streamId);
                ((Thread)thread).start();
            }
            if (streamId != null && streamId.equals(context.getProperties().get("StdOutID")) && !((StreamReaderRunnable)(runnable = new StreamReaderRunnable(streamId, "StdOutID", receivers))).isEmpty()) {
                thread = this.runnables;
                synchronized (thread) {
                    this.runnables.add(runnable);
                }
                thread = new Thread(runnable, "Thread-StdOutID-" + streamId);
                ((Thread)thread).start();
            }
            if (streamId != null && streamId.equals(context.getProperties().get("StdErrID")) && !((StreamReaderRunnable)(runnable = new StreamReaderRunnable(streamId, "StdErrID", receivers))).isEmpty()) {
                thread = this.runnables;
                synchronized (thread) {
                    this.runnables.add(runnable);
                }
                thread = new Thread(runnable, "Thread-StdErrID-" + streamId);
                ((Thread)thread).start();
            }
        } else if (context == null) {
            StreamCreatedEvent event = new StreamCreatedEvent(streamType, streamId, contextId);
            List<StreamCreatedEvent> list = this.delayedCreatedEvents;
            synchronized (list) {
                if (!this.delayedCreatedEvents.contains(event)) {
                    this.delayedCreatedEvents.add(event);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disposed(String streamType, String streamId) {
        Iterator<Object> iterator;
        if (!this.svcProcessesName.equals(streamType)) {
            return;
        }
        if (CoreBundleActivator.getTraceHandler().isSlotEnabled(0, "trace/launcher/streamsListener")) {
            CoreBundleActivator.getTraceHandler().trace("Remote process stream disposed: streamId='" + streamId + "'", 0, "trace/launcher/streamsListener", 1, this.getClass());
        }
        List<Object> list = this.delayedCreatedEvents;
        synchronized (list) {
            iterator = this.delayedCreatedEvents.iterator();
            while (iterator.hasNext()) {
                StreamCreatedEvent event = iterator.next();
                if (event.streamType == null || !event.streamType.equals(streamType) || event.streamId == null || !event.streamId.equals(streamId)) continue;
                iterator.remove();
            }
        }
        list = this.runnables;
        synchronized (list) {
            iterator = this.runnables.iterator();
            while (iterator.hasNext()) {
                StreamReaderRunnable myRunnable;
                Runnable runnable = (Runnable)iterator.next();
                if (!(runnable instanceof StreamReaderRunnable) || !(myRunnable = (StreamReaderRunnable)runnable).getStreamId().equals(streamId)) continue;
                myRunnable.stop(null);
                iterator.remove();
            }
        }
    }

    protected class ProcessStreamWriterRunnable
    implements Runnable {
        private final String streamId;
        private final String streamTypeId;
        private final StreamsDataProvider provider;
        private TCFTask<Object> activeTask;
        private ICallback callback;
        private boolean stopped = false;

        public ProcessStreamWriterRunnable(String streamId, String streamTypeId, StreamsDataProvider provider) {
            Assert.isNotNull((Object)streamId);
            Assert.isNotNull((Object)streamTypeId);
            Assert.isNotNull((Object)provider);
            Assert.isTrue((boolean)provider.isApplicable(streamTypeId));
            this.streamId = streamId;
            this.streamTypeId = streamTypeId;
            this.provider = provider;
        }

        public final String getStreamId() {
            return this.streamId;
        }

        public final String getStreamTypeId() {
            return this.streamTypeId;
        }

        public final synchronized void stop(ICallback callback) {
            if (this.stopped) {
                if (callback != null) {
                    callback.done((Object)this, Status.OK_STATUS);
                }
                return;
            }
            this.callback = callback;
            this.stopped = true;
        }

        protected final synchronized boolean isStopped() {
            return this.stopped;
        }

        protected final void setActiveTask(TCFTask<Object> task) {
            this.activeTask = task;
        }

        protected final TCFTask<Object> getActiveTask() {
            return this.activeTask;
        }

        protected final ICallback getCallback() {
            return this.callback;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (this.provider == null) {
                ProcessStreamWriterRunnable processStreamWriterRunnable = this;
                synchronized (processStreamWriterRunnable) {
                    this.stopped = true;
                }
                if (this.callback != null) {
                    this.callback.done((Object)this, Status.OK_STATUS);
                }
                return;
            }
            char[] buffer = new char[1024];
            while (!this.isStopped() && ProcessStreamsListener.this.svcStreams != null) {
                try {
                    int charactersRead = this.provider.getReader().read(buffer, 0, 1024);
                    if (charactersRead == -1) break;
                    if (charactersRead <= 0) continue;
                    this.write(ProcessStreamsListener.this.svcStreams, this.streamId, new String(buffer).getBytes(), charactersRead);
                }
                catch (Exception e) {
                    e = ExceptionUtils.checkAndUnwrapException((Exception)e);
                    if (e instanceof CancellationException) break;
                    Status status = new Status(4, CoreBundleActivator.getUniqueIdentifier(), NLS.bind((String)Messages.ProcessStreamWriterRunnable_error_writeFailed, (Object)this.streamId, (Object)e.getLocalizedMessage()), (Throwable)e);
                    Platform.getLog((Bundle)CoreBundleActivator.getContext().getBundle()).log((IStatus)status);
                    break;
                }
            }
            if (ProcessStreamsListener.this.svcStreams != null) {
                ProcessStreamsListener.this.svcStreams.disconnect(this.streamId, new IStreams.DoneDisconnect(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void doneDisconnect(IToken token, Exception error) {
                        1 var3_3 = this;
                        synchronized (var3_3) {
                            ProcessStreamWriterRunnable.this.stopped = true;
                        }
                        if (ProcessStreamWriterRunnable.this.getCallback() != null) {
                            ProcessStreamWriterRunnable.this.getCallback().done((Object)this, Status.OK_STATUS);
                        }
                    }
                });
            } else {
                ProcessStreamWriterRunnable processStreamWriterRunnable = this;
                synchronized (processStreamWriterRunnable) {
                    this.stopped = true;
                }
                if (this.callback != null) {
                    this.callback.done((Object)this, Status.OK_STATUS);
                }
            }
        }

        protected final void write(final IStreams service, final String streamId, final byte[] data, final int size) throws Exception {
            Assert.isNotNull((Object)service);
            Assert.isNotNull((Object)streamId);
            Assert.isTrue((!Protocol.isDispatchThread() ? 1 : 0) != 0);
            TCFTask<Object> task = new TCFTask<Object>(){

                public void run() {
                    service.write(streamId, data, 0, size, new IStreams.DoneWrite(){

                        public void doneWrite(IToken token, Exception error) {
                            if (error == null) {
                                this.done(null);
                            } else {
                                this.error(error);
                            }
                        }
                    });
                }
            };
            task.get();
            this.setActiveTask(task);
            task.get();
        }
    }

    private static final class StreamCreatedEvent {
        public final String streamType;
        public final String streamId;
        public final String contextId;
        private final String toString;

        public StreamCreatedEvent(String streamType, String streamId, String contextId) {
            this.streamType = streamType;
            this.streamId = streamId;
            this.contextId = contextId;
            this.toString = this.toString();
        }

        public boolean equals(Object obj) {
            return obj instanceof StreamCreatedEvent && this.toString().equals(((StreamCreatedEvent)obj).toString());
        }

        public int hashCode() {
            return this.toString().hashCode();
        }

        public String toString() {
            if (this.toString != null) {
                return this.toString;
            }
            StringBuilder builder = new StringBuilder(this.getClass().getSimpleName());
            builder.append(": streamType = ");
            builder.append(this.streamType);
            builder.append("; streamId = ");
            builder.append(this.streamId);
            builder.append("; contextId = ");
            builder.append(this.contextId);
            return builder.toString();
        }
    }

    protected class StreamReaderRunnable
    implements Runnable {
        private final String streamId;
        private final String streamTypeId;
        private final List<StreamsDataReceiver> receivers = new ArrayList<StreamsDataReceiver>();
        private TCFTask<ReadData> activeTask;
        private ICallback callback;
        private boolean stopped = false;

        public StreamReaderRunnable(String streamId, String streamTypeId, StreamsDataReceiver[] receivers) {
            Assert.isNotNull((Object)streamId);
            Assert.isNotNull((Object)streamTypeId);
            Assert.isNotNull((Object)receivers);
            this.streamId = streamId;
            this.streamTypeId = streamTypeId;
            StreamsDataReceiver[] streamsDataReceiverArray = receivers;
            int n = receivers.length;
            int n2 = 0;
            while (n2 < n) {
                StreamsDataReceiver receiver = streamsDataReceiverArray[n2];
                if (receiver.isApplicable(this.streamTypeId)) {
                    this.receivers.add(receiver);
                }
                ++n2;
            }
        }

        public final String getStreamId() {
            return this.streamId;
        }

        public final boolean isEmpty() {
            return this.receivers.isEmpty();
        }

        public final synchronized void stop(ICallback callback) {
            if (this.stopped) {
                if (callback != null) {
                    callback.done((Object)this, Status.OK_STATUS);
                }
                return;
            }
            this.callback = callback;
        }

        protected final synchronized boolean isStopped() {
            return this.stopped;
        }

        protected final void setActiveTask(TCFTask<ReadData> task) {
            this.activeTask = task;
        }

        protected final TCFTask<ReadData> getActiveTask() {
            return this.activeTask;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object e2;
            StreamsDataReceiver[] receivers = this.receivers.toArray(new StreamsDataReceiver[this.receivers.size()]);
            while (!this.isStopped() && ProcessStreamsListener.this.svcStreams != null) {
                try {
                    ReadData streamData = this.read(ProcessStreamsListener.this.svcStreams, this.streamId, 1024);
                    if (streamData == null) continue;
                    if (streamData.data != null) {
                        this.notifyReceiver(new String(streamData.data), receivers);
                    }
                    if (!streamData.eos) continue;
                }
                catch (Exception e2) {
                    e2 = ExceptionUtils.checkAndUnwrapException((Exception)e2);
                    if (e2 instanceof CancellationException) break;
                    Status status = new Status(4, CoreBundleActivator.getUniqueIdentifier(), NLS.bind((String)Messages.ProcessStreamReaderRunnable_error_readFailed, (Object)this.streamId, (Object)((Throwable)e2).getLocalizedMessage()), (Throwable)e2);
                    Platform.getLog((Bundle)CoreBundleActivator.getContext().getBundle()).log((IStatus)status);
                }
                break;
            }
            if (ProcessStreamsListener.this.svcStreams != null) {
                ProcessStreamsListener.this.svcStreams.disconnect(this.streamId, new IStreams.DoneDisconnect(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void doneDisconnect(IToken token, Exception error) {
                        1 var3_3 = this;
                        synchronized (var3_3) {
                            StreamReaderRunnable.this.stopped = true;
                            if (StreamReaderRunnable.this.callback != null) {
                                StreamReaderRunnable.this.callback.done((Object)this, Status.OK_STATUS);
                            }
                        }
                    }
                });
            } else {
                e2 = this;
                synchronized (e2) {
                    this.stopped = true;
                    if (this.callback != null) {
                        this.callback.done((Object)this, Status.OK_STATUS);
                    }
                }
            }
            StreamsDataReceiver[] streamsDataReceiverArray = receivers;
            int n = receivers.length;
            int n2 = 0;
            while (n2 < n) {
                StreamsDataReceiver receiver = streamsDataReceiverArray[n2];
                receiver.dispose();
                ++n2;
            }
        }

        protected final ReadData read(final IStreams service, final String streamId, final int size) throws Exception {
            Assert.isNotNull((Object)service);
            Assert.isNotNull((Object)streamId);
            Assert.isTrue((!Protocol.isDispatchThread() ? 1 : 0) != 0);
            TCFTask<ReadData> task = new TCFTask<ReadData>(ProcessStreamsListener.this.channel){

                public void run() {
                    service.read(streamId, size, new IStreams.DoneRead(){

                        public void doneRead(IToken token, Exception error, int lostSize, byte[] data, boolean eos) {
                            if (error == null) {
                                this.done(new ReadData(lostSize, data, eos));
                            } else {
                                this.error(error);
                            }
                        }
                    });
                }
            };
            this.setActiveTask(task);
            return (ReadData)task.get();
        }

        protected final void notifyReceiver(String data, StreamsDataReceiver[] receivers) {
            if (data == null) {
                return;
            }
            StreamsDataReceiver[] streamsDataReceiverArray = receivers;
            int n = receivers.length;
            int n2 = 0;
            while (n2 < n) {
                block4: {
                    StreamsDataReceiver receiver = streamsDataReceiverArray[n2];
                    try {
                        Writer writer = receiver.getWriter();
                        writer.write(data);
                        writer.flush();
                        receiver.notifyListener(data);
                    }
                    catch (IOException e) {
                        if (!CoreBundleActivator.getTraceHandler().isSlotEnabled(1, null)) break block4;
                        Status status = new Status(2, CoreBundleActivator.getUniqueIdentifier(), NLS.bind((String)Messages.ProcessStreamReaderRunnable_error_appendFailed, (Object)this.streamId, (Object)data), (Throwable)e);
                        Platform.getLog((Bundle)CoreBundleActivator.getContext().getBundle()).log((IStatus)status);
                    }
                }
                ++n2;
            }
        }

        protected class ReadData {
            public final int lostBytes;
            public final byte[] data;
            public final boolean eos;

            public ReadData(int lostBytes, byte[] data, boolean eos) {
                this.lostBytes = lostBytes;
                this.data = data;
                this.eos = eos;
            }
        }
    }
}

