/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.processes.core.model;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.runtime.Assert;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerModel;
import org.eclipse.tcf.te.tcf.processes.core.model.interfaces.runtime.IRuntimeModel;
import org.eclipse.tcf.te.tcf.processes.core.model.runtime.RuntimeModel;

public class ModelManager {
    static final Map<String, IRuntimeModel> runtimeModels = new HashMap<String, IRuntimeModel>();

    public static IRuntimeModel getRuntimeModel(final IPeerModel peerModel) {
        Assert.isNotNull((Object)peerModel);
        final AtomicReference runtimeModel = new AtomicReference();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                Assert.isTrue((boolean)Protocol.isDispatchThread());
                String id = peerModel.getPeerId();
                IRuntimeModel candidate = runtimeModels.get(id);
                if (candidate == null && (candidate = ModelManager.initializeRuntimeModel(peerModel)) != null) {
                    runtimeModels.put(id, candidate);
                }
                runtimeModel.set(candidate);
            }
        };
        if (Protocol.isDispatchThread()) {
            runnable.run();
        } else {
            Protocol.invokeAndWait((Runnable)runnable);
        }
        return (IRuntimeModel)runtimeModel.get();
    }

    protected static IRuntimeModel initializeRuntimeModel(IPeerModel peerModel) {
        Assert.isTrue((boolean)Protocol.isDispatchThread());
        RuntimeModel runtimeModel = new RuntimeModel(peerModel);
        return runtimeModel;
    }

    public static void disposeRuntimeModel(final IPeerModel peerModel) {
        Assert.isNotNull((Object)peerModel);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                Assert.isTrue((boolean)Protocol.isDispatchThread());
                String id = peerModel.getPeerId();
                IRuntimeModel candidate = runtimeModels.remove(id);
                if (candidate != null) {
                    candidate.dispose();
                }
            }
        };
        if (Protocol.isDispatchThread()) {
            runnable.run();
        } else {
            Protocol.invokeAndWait((Runnable)runnable);
        }
    }

    public static void disposeAllRuntimeModels() {
        if (runtimeModels.isEmpty()) {
            return;
        }
        final IRuntimeModel[] models = runtimeModels.values().toArray(new IRuntimeModel[runtimeModels.values().size()]);
        runtimeModels.clear();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                IRuntimeModel[] iRuntimeModelArray = models;
                int n = models.length;
                int n2 = 0;
                while (n2 < n) {
                    IRuntimeModel model = iRuntimeModelArray[n2];
                    model.dispose();
                    ++n2;
                }
            }
        };
        if (Protocol.isDispatchThread()) {
            runnable.run();
        } else {
            Protocol.invokeAndWait((Runnable)runnable);
        }
    }
}

