/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.processes.core.model.runtime.services;

import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.tcf.protocol.IChannel;
import org.eclipse.tcf.protocol.IToken;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.services.IProcesses;
import org.eclipse.tcf.services.ISysMonitor;
import org.eclipse.tcf.te.core.async.AsyncCallbackCollector;
import org.eclipse.tcf.te.runtime.callback.Callback;
import org.eclipse.tcf.te.runtime.events.ChangeEvent;
import org.eclipse.tcf.te.runtime.events.EventManager;
import org.eclipse.tcf.te.runtime.interfaces.callback.ICallback;
import org.eclipse.tcf.te.runtime.model.PendingOperationModelNode;
import org.eclipse.tcf.te.runtime.model.interfaces.IModelNode;
import org.eclipse.tcf.te.runtime.model.interfaces.contexts.IAsyncRefreshableCtx;
import org.eclipse.tcf.te.tcf.core.async.CallbackInvocationDelegate;
import org.eclipse.tcf.te.tcf.core.model.interfaces.IModel;
import org.eclipse.tcf.te.tcf.core.model.interfaces.services.IModelChannelService;
import org.eclipse.tcf.te.tcf.core.model.interfaces.services.IModelLookupService;
import org.eclipse.tcf.te.tcf.core.model.interfaces.services.IModelRefreshService;
import org.eclipse.tcf.te.tcf.core.model.interfaces.services.IModelUpdateService;
import org.eclipse.tcf.te.tcf.core.model.services.AbstractModelService;
import org.eclipse.tcf.te.tcf.processes.core.activator.CoreBundleActivator;
import org.eclipse.tcf.te.tcf.processes.core.model.interfaces.IProcessContextNode;
import org.eclipse.tcf.te.tcf.processes.core.model.interfaces.runtime.IRuntimeModel;
import org.eclipse.tcf.te.tcf.processes.core.model.nodes.PendingOperationNode;

public class RuntimeModelRefreshService
extends AbstractModelService<IRuntimeModel>
implements IModelRefreshService {
    public RuntimeModelRefreshService(IRuntimeModel model) {
        super((IModel)model);
    }

    public void refresh(ICallback callback) {
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        this.refresh(0, callback);
    }

    public void refresh(int flags, final ICallback callback) {
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        final IRuntimeModel model = (IRuntimeModel)this.getModel();
        if (model.isDisposed()) {
            if (callback != null) {
                callback.done((Object)this, Status.OK_STATUS);
            }
            return;
        }
        final List oldChildren = model.getChildren(IProcessContextNode.class);
        this.refreshContextChildren(oldChildren, model, null, 2, (ICallback)new Callback(){

            protected void internalDone(Object caller, IStatus status) {
                final AtomicBoolean isDisposed = new AtomicBoolean();
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        isDisposed.set(model.isDisposed());
                    }
                };
                if (Protocol.isDispatchThread()) {
                    runnable.run();
                } else {
                    Protocol.invokeAndWait((Runnable)runnable);
                }
                if (!isDisposed.get()) {
                    for (IProcessContextNode oldChild : oldChildren) {
                        ((IModelUpdateService)model.getService(IModelUpdateService.class)).remove((IModelNode)oldChild);
                    }
                }
                if (callback != null) {
                    callback.done((Object)this, Status.OK_STATUS);
                }
            }
        });
    }

    public void refresh(IModelNode node, ICallback callback) {
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        this.refresh(node, 0, callback);
    }

    public void refresh(IModelNode node, int flags, ICallback callback) {
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        IRuntimeModel model = (IRuntimeModel)this.getModel();
        if (model.isDisposed() || !(node instanceof IProcessContextNode)) {
            if (callback != null) {
                callback.done((Object)this, Status.OK_STATUS);
            }
            return;
        }
        this.doRefresh(model, node, flags, callback);
    }

    protected void doRefresh(final IRuntimeModel model, final IModelNode node, int flags, final ICallback callback) {
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        Assert.isNotNull((Object)model);
        Assert.isNotNull((Object)node);
        this.refreshContext(model, node, (ICallback)new Callback(){

            protected void internalDone(Object caller, IStatus status) {
                if (status.getSeverity() == 4) {
                    if (callback != null) {
                        callback.done(caller, status);
                    }
                    return;
                }
                final List oldChildren = ((IProcessContextNode)node).getChildren(IProcessContextNode.class);
                RuntimeModelRefreshService.this.refreshContextChildren(oldChildren, model, (IProcessContextNode)node, 2, (ICallback)new Callback(){

                    protected void internalDone(Object caller, IStatus status) {
                        final AtomicBoolean isDisposed = new AtomicBoolean();
                        Runnable runnable = new Runnable(){

                            @Override
                            public void run() {
                                isDisposed.set(model.isDisposed());
                            }
                        };
                        if (Protocol.isDispatchThread()) {
                            runnable.run();
                        } else {
                            Protocol.invokeAndWait((Runnable)runnable);
                        }
                        if (!isDisposed.get()) {
                            for (IProcessContextNode oldChild : oldChildren) {
                                ((IProcessContextNode)node).remove((IModelNode)oldChild, true);
                            }
                        }
                        if (callback != null) {
                            callback.done((Object)RuntimeModelRefreshService.this, Status.OK_STATUS);
                        }
                    }
                });
            }
        });
    }

    protected void processContexts(Map<UUID, IProcessContextNode> contexts, List<IProcessContextNode> oldChildren, IModel model, IProcessContextNode parent) {
        Assert.isNotNull(contexts);
        Assert.isNotNull(oldChildren);
        Assert.isNotNull((Object)model);
        for (Map.Entry<UUID, IProcessContextNode> entry : contexts.entrySet()) {
            IProcessContextNode candidate = entry.getValue();
            IModelNode[] nodes = ((IModelLookupService)model.getService(IModelLookupService.class)).lkupModelNodesById(candidate.getStringProperty("id"));
            if (nodes.length > 0) {
                IModelNode[] iModelNodeArray = nodes;
                int n = nodes.length;
                int n2 = 0;
                while (n2 < n) {
                    IModelNode node = iModelNodeArray[n2];
                    ((IModelUpdateService)model.getService(IModelUpdateService.class)).update(node, (IModelNode)candidate);
                    oldChildren.remove(node);
                    ++n2;
                }
                continue;
            }
            if (parent == null) {
                ((IModelUpdateService)model.getService(IModelUpdateService.class)).add((IModelNode)candidate);
                continue;
            }
            nodes = ((IModelLookupService)model.getService(IModelLookupService.class)).lkupModelNodesById(parent.getStringProperty("id"));
            if (nodes.length > 0) {
                Assert.isTrue((nodes.length == 1 ? 1 : 0) != 0);
                Assert.isTrue((boolean)(nodes[0] instanceof IProcessContextNode));
                ((IProcessContextNode)nodes[0]).add((IModelNode)candidate);
                continue;
            }
            parent.add((IModelNode)candidate);
        }
    }

    protected void refreshContext(IRuntimeModel model, final IModelNode node, final ICallback callback) {
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        Assert.isNotNull((Object)model);
        Assert.isNotNull((Object)node);
        IModelChannelService channelService = (IModelChannelService)((IRuntimeModel)this.getModel()).getService(IModelChannelService.class);
        channelService.openChannel(new IModelChannelService.DoneOpenChannel(){

            public void doneOpenChannel(Throwable error, IChannel channel) {
                if (error == null) {
                    final IProcesses service = (IProcesses)channel.getRemoteService(IProcesses.class);
                    Assert.isNotNull((Object)service);
                    final ISysMonitor sysMonService = (ISysMonitor)channel.getRemoteService(ISysMonitor.class);
                    Assert.isNotNull((Object)sysMonService);
                    final String contextId = ((IProcessContextNode)node).getStringProperty("id");
                    sysMonService.getContext(contextId, new ISysMonitor.DoneGetContext(){

                        public void doneGetContext(IToken token, Exception error, ISysMonitor.SysMonitorContext context) {
                            ((IProcessContextNode)node).setSysMonitorContext(context);
                            sysMonService.getCommandLine(contextId, new ISysMonitor.DoneGetCommandLine(){

                                public void doneGetCommandLine(IToken token, Exception error, String[] cmd_line) {
                                    node.setProperty("cmdline", error == null ? cmd_line : null);
                                    service.getContext(contextId, new IProcesses.DoneGetContext(){

                                        public void doneGetContext(IToken token, Exception error, IProcesses.ProcessContext context) {
                                            ((IProcessContextNode)node).setProcessContext(context);
                                            callback.done((Object)RuntimeModelRefreshService.this, Status.OK_STATUS);
                                        }
                                    });
                                }
                            });
                        }
                    });
                } else {
                    callback.done((Object)RuntimeModelRefreshService.this, (IStatus)new Status(4, CoreBundleActivator.getUniqueIdentifier(), error.getLocalizedMessage(), error));
                }
            }
        });
    }

    protected void refreshContextChildren(final List<IProcessContextNode> oldChildren, final IModel model, final IProcessContextNode parent, final int depth, final ICallback callback) {
        Assert.isNotNull(oldChildren);
        Assert.isNotNull((Object)model);
        Assert.isNotNull((Object)callback);
        try {
            final HashMap contexts = new HashMap();
            IModelChannelService channelService = (IModelChannelService)((IRuntimeModel)this.getModel()).getService(IModelChannelService.class);
            channelService.openChannel(new IModelChannelService.DoneOpenChannel(){

                public void doneOpenChannel(Throwable error, IChannel channel) {
                    if (error == null) {
                        String parentContextId = null;
                        if (parent != null) {
                            parentContextId = parent.getStringProperty("id");
                        }
                        final IProcesses service = (IProcesses)channel.getRemoteService(IProcesses.class);
                        Assert.isNotNull((Object)service);
                        final ISysMonitor sysMonService = (ISysMonitor)channel.getRemoteService(ISysMonitor.class);
                        Assert.isNotNull((Object)sysMonService);
                        sysMonService.getChildren(parentContextId, new ISysMonitor.DoneGetChildren(){

                            public void doneGetChildren(IToken token, Exception error, String[] context_ids) {
                                if (error == null) {
                                    if (context_ids != null && context_ids.length > 0) {
                                        AsyncCallbackCollector collector = new AsyncCallbackCollector((ICallback)new Callback(){

                                            protected void internalDone(Object caller, IStatus status) {
                                                Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
                                                if (status.getSeverity() == 0) {
                                                    if (!contexts.isEmpty()) {
                                                        RuntimeModelRefreshService.this.processContexts(contexts, oldChildren, model, parent);
                                                    }
                                                    callback.done((Object)RuntimeModelRefreshService.this, Status.OK_STATUS);
                                                } else {
                                                    callback.done((Object)RuntimeModelRefreshService.this, (IStatus)new Status(4, CoreBundleActivator.getUniqueIdentifier(), status.getMessage(), status.getException()));
                                                }
                                            }
                                        }, (AsyncCallbackCollector.ICallbackInvocationDelegate)new CallbackInvocationDelegate());
                                        String[] stringArray = context_ids;
                                        int n = context_ids.length;
                                        int n2 = 0;
                                        while (n2 < n) {
                                            String id;
                                            final String contextId = id = stringArray[n2];
                                            AsyncCallbackCollector.SimpleCollectorCallback innerCallback = new AsyncCallbackCollector.SimpleCollectorCallback(collector);
                                            sysMonService.getContext(contextId, new ISysMonitor.DoneGetContext((ICallback)innerCallback, service, depth, model){
                                                private final /* synthetic */ ICallback val$innerCallback;
                                                private final /* synthetic */ IProcesses val$service;
                                                private final /* synthetic */ int val$depth;
                                                private final /* synthetic */ IModel val$model;
                                                {
                                                    this.val$innerCallback = iCallback;
                                                    this.val$service = iProcesses;
                                                    this.val$depth = n;
                                                    this.val$model = iModel;
                                                }

                                                public void doneGetContext(IToken token, Exception error, ISysMonitor.SysMonitorContext context) {
                                                    if (context != null) {
                                                        final IProcessContextNode node = RuntimeModelRefreshService.this.createContextNodeFrom(context);
                                                        Assert.isNotNull((Object)node);
                                                        node.setType(parent == null ? IProcessContextNode.TYPE.Process : IProcessContextNode.TYPE.Thread);
                                                        contexts.put(node.getUUID(), node);
                                                        sysMonService.getCommandLine(contextId, new ISysMonitor.DoneGetCommandLine(){

                                                            public void doneGetCommandLine(IToken token, Exception error, String[] cmd_line) {
                                                                node.setProperty("cmdline", error == null ? cmd_line : null);
                                                                val$service.getContext(contextId, new IProcesses.DoneGetContext(){

                                                                    public void doneGetContext(IToken token, Exception error, IProcesses.ProcessContext context) {
                                                                        node.setProcessContext(context);
                                                                        if (context != null) {
                                                                            node.setProperty("name", context.getName());
                                                                        }
                                                                        final IAsyncRefreshableCtx refreshable = (IAsyncRefreshableCtx)node.getAdapter(IAsyncRefreshableCtx.class);
                                                                        if (!(val$depth - 1 <= 0 || refreshable != null && refreshable.getQueryState(IAsyncRefreshableCtx.QueryType.CHILD_LIST).equals((Object)IAsyncRefreshableCtx.QueryState.IN_PROGRESS))) {
                                                                            if (refreshable != null) {
                                                                                refreshable.setQueryState(IAsyncRefreshableCtx.QueryType.CHILD_LIST, IAsyncRefreshableCtx.QueryState.IN_PROGRESS);
                                                                                PendingOperationNode pendingNode = new PendingOperationNode();
                                                                                pendingNode.setParent(node);
                                                                                refreshable.setPendingOperationNode((PendingOperationModelNode)pendingNode);
                                                                            }
                                                                            final boolean changed = node.setChangeEventsEnabled(false);
                                                                            List oldChildren = node.getChildren(IProcessContextNode.class);
                                                                            RuntimeModelRefreshService.this.refreshContextChildren(oldChildren, val$model, node, val$depth - 1, (ICallback)new Callback(){

                                                                                protected void internalDone(Object caller, IStatus status) {
                                                                                    refreshable.setQueryState(IAsyncRefreshableCtx.QueryType.CHILD_LIST, IAsyncRefreshableCtx.QueryState.DONE);
                                                                                    refreshable.setPendingOperationNode(null);
                                                                                    if (changed) {
                                                                                        node.setChangeEventsEnabled(true);
                                                                                    }
                                                                                    ChangeEvent event = new ChangeEvent((Object)node, (Object)"changed", null, null);
                                                                                    EventManager.getInstance().fireEvent((EventObject)event);
                                                                                    val$innerCallback.done((Object)RuntimeModelRefreshService.this, Status.OK_STATUS);
                                                                                }
                                                                            });
                                                                        } else {
                                                                            val$innerCallback.done((Object)RuntimeModelRefreshService.this, Status.OK_STATUS);
                                                                        }
                                                                    }
                                                                });
                                                            }
                                                        });
                                                    } else {
                                                        this.val$innerCallback.done((Object)RuntimeModelRefreshService.this, Status.OK_STATUS);
                                                    }
                                                }
                                            });
                                            ++n2;
                                        }
                                        collector.initDone();
                                    } else {
                                        callback.done((Object)RuntimeModelRefreshService.this, Status.OK_STATUS);
                                    }
                                } else {
                                    callback.done((Object)RuntimeModelRefreshService.this, (IStatus)new Status(4, CoreBundleActivator.getUniqueIdentifier(), error.getLocalizedMessage(), (Throwable)error));
                                }
                            }
                        });
                    } else {
                        callback.done((Object)RuntimeModelRefreshService.this, (IStatus)new Status(4, CoreBundleActivator.getUniqueIdentifier(), error.getLocalizedMessage(), error));
                    }
                }
            });
        }
        catch (Throwable e) {
            callback.done((Object)this, (IStatus)new Status(4, CoreBundleActivator.getUniqueIdentifier(), e.getLocalizedMessage(), e));
        }
    }

    public IProcessContextNode createContextNodeFrom(ISysMonitor.SysMonitorContext context) {
        Assert.isNotNull((Object)context);
        IProcessContextNode node = (IProcessContextNode)((IRuntimeModel)this.getModel()).getFactory().newInstance(IProcessContextNode.class);
        node.setSysMonitorContext(context);
        node.setProperty("id", context.getID());
        return node;
    }
}

