/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.launch.ui.activator;

import java.net.URL;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.tcf.te.runtime.tracing.TraceHandler;
import org.eclipse.tcf.te.ui.jface.images.AbstractImageDescriptor;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class UIPlugin
extends AbstractUIPlugin {
    private static UIPlugin plugin;
    private static volatile TraceHandler traceHandler;

    public static UIPlugin getDefault() {
        return plugin;
    }

    public static String getUniqueIdentifier() {
        if (UIPlugin.getDefault() != null && UIPlugin.getDefault().getBundle() != null) {
            return UIPlugin.getDefault().getBundle().getSymbolicName();
        }
        return "org.eclipse.tcf.te.launch.ui";
    }

    public static TraceHandler getTraceHandler() {
        if (traceHandler == null) {
            traceHandler = new TraceHandler(UIPlugin.getUniqueIdentifier());
        }
        return traceHandler;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        traceHandler = null;
        super.stop(context);
    }

    protected void initializeImageRegistry(ImageRegistry registry) {
        URL url;
        Bundle bundle = Platform.getBundle((String)"org.eclipse.ui");
        if (bundle != null) {
            url = bundle.getEntry("icons/full/elcl16/refresh_nav.gif");
            registry.put("RefreshAction_enabled", ImageDescriptor.createFromURL((URL)url));
            url = bundle.getEntry("icons/full/dlcl16/refresh_nav.gif");
            registry.put("RefreshAction_disabled", ImageDescriptor.createFromURL((URL)url));
        }
        url = this.getBundle().getEntry("icons/obj16/launches_root.gif");
        registry.put("OBJ_Launches_Root", ImageDescriptor.createFromURL((URL)url));
        url = this.getBundle().getEntry("icons/ovr16/redX_ovr.gif");
        registry.put("RedXOverlay", ImageDescriptor.createFromURL((URL)url));
    }

    public static Image getImage(String key) {
        return UIPlugin.getDefault().getImageRegistry().get(key);
    }

    public static ImageDescriptor getImageDescriptor(String key) {
        return UIPlugin.getDefault().getImageRegistry().getDescriptor(key);
    }

    public static Image getSharedImage(AbstractImageDescriptor descriptor) {
        String imageKey;
        ImageRegistry registry = UIPlugin.getDefault().getImageRegistry();
        Image image = registry.get(imageKey = descriptor.getDecriptorKey());
        if (image == null) {
            registry.put(imageKey, (ImageDescriptor)descriptor);
            image = registry.get(imageKey);
        }
        return image;
    }
}

