/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.launch.core.persistence;

import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.tcf.te.launch.core.persistence.LaunchConfigurationChangedEvent;
import org.eclipse.tcf.te.runtime.events.EventManager;

public class DefaultPersistenceDelegate {
    public static final boolean isAttributeChanged(ILaunchConfigurationWorkingCopy wc, String attributeId, Object attributeValue) {
        boolean changed = false;
        Assert.isNotNull((Object)wc);
        Assert.isNotNull((Object)attributeId);
        try {
            Object oldAttributeValue;
            Map attributes = wc.getAttributes();
            if (attributeValue == null && attributes.containsKey(attributeId)) {
                changed = true;
            } else if (attributeValue != null && !attributes.containsKey(attributeId)) {
                changed = true;
            } else if (attributeValue != null && attributes.containsKey(attributeId) && !attributeValue.equals(oldAttributeValue = attributes.get(attributeId))) {
                changed = true;
            }
        }
        catch (CoreException coreException) {}
        return changed;
    }

    public static final void setAttribute(ILaunchConfigurationWorkingCopy wc, String attributeId, boolean attributeValue) {
        if (wc == null || attributeId == null) {
            return;
        }
        if (DefaultPersistenceDelegate.isAttributeChanged(wc, attributeId, attributeValue)) {
            Object oldValue = null;
            if (DefaultPersistenceDelegate.hasAttribute((ILaunchConfiguration)wc, attributeId)) {
                try {
                    oldValue = wc.getAttributes().get(attributeId);
                }
                catch (CoreException coreException) {}
            }
            wc.setAttribute(attributeId, attributeValue);
            EventManager.getInstance().fireEvent((EventObject)new LaunchConfigurationChangedEvent((ILaunchConfiguration)wc, attributeId, oldValue, attributeValue));
        }
    }

    public static final void setAttribute(ILaunchConfigurationWorkingCopy wc, String attributeId, int attributeValue) {
        if (wc == null || attributeId == null) {
            return;
        }
        if (DefaultPersistenceDelegate.isAttributeChanged(wc, attributeId, attributeValue)) {
            Object oldValue = null;
            if (DefaultPersistenceDelegate.hasAttribute((ILaunchConfiguration)wc, attributeId)) {
                try {
                    oldValue = wc.getAttributes().get(attributeId);
                }
                catch (CoreException coreException) {}
            }
            wc.setAttribute(attributeId, attributeValue);
            EventManager.getInstance().fireEvent((EventObject)new LaunchConfigurationChangedEvent((ILaunchConfiguration)wc, attributeId, oldValue, attributeValue));
        }
    }

    public static final void setAttribute(ILaunchConfigurationWorkingCopy wc, String attributeId, String attributeValue) {
        if (wc == null || attributeId == null) {
            return;
        }
        if (DefaultPersistenceDelegate.isAttributeChanged(wc, attributeId, attributeValue)) {
            Object oldValue = null;
            if (DefaultPersistenceDelegate.hasAttribute((ILaunchConfiguration)wc, attributeId)) {
                try {
                    oldValue = wc.getAttributes().get(attributeId);
                }
                catch (CoreException coreException) {}
            }
            wc.setAttribute(attributeId, attributeValue);
            EventManager.getInstance().fireEvent((EventObject)new LaunchConfigurationChangedEvent((ILaunchConfiguration)wc, attributeId, oldValue, attributeValue));
        }
    }

    public static final void setAttribute(ILaunchConfigurationWorkingCopy wc, String attributeId, List<?> attributeValue) {
        if (wc == null || attributeId == null) {
            return;
        }
        if (DefaultPersistenceDelegate.isAttributeChanged(wc, attributeId, attributeValue)) {
            Object oldValue = null;
            if (DefaultPersistenceDelegate.hasAttribute((ILaunchConfiguration)wc, attributeId)) {
                try {
                    oldValue = wc.getAttributes().get(attributeId);
                }
                catch (CoreException coreException) {}
            }
            wc.setAttribute(attributeId, attributeValue);
            EventManager.getInstance().fireEvent((EventObject)new LaunchConfigurationChangedEvent((ILaunchConfiguration)wc, attributeId, oldValue, attributeValue));
        }
    }

    public static final void setAttribute(ILaunchConfigurationWorkingCopy wc, String attributeId, Map<?, ?> attributeValue) {
        if (wc == null || attributeId == null) {
            return;
        }
        if (DefaultPersistenceDelegate.isAttributeChanged(wc, attributeId, attributeValue)) {
            Object oldValue = null;
            if (DefaultPersistenceDelegate.hasAttribute((ILaunchConfiguration)wc, attributeId)) {
                try {
                    oldValue = wc.getAttributes().get(attributeId);
                }
                catch (CoreException coreException) {}
            }
            wc.setAttribute(attributeId, attributeValue);
            EventManager.getInstance().fireEvent((EventObject)new LaunchConfigurationChangedEvent((ILaunchConfiguration)wc, attributeId, oldValue, attributeValue));
        }
    }

    public static final boolean getAttribute(ILaunchConfiguration lc, String attributeName, boolean defaultValue) {
        Assert.isNotNull((Object)lc);
        Assert.isNotNull((Object)attributeName);
        boolean value = defaultValue;
        try {
            value = lc.getAttribute(attributeName, defaultValue);
        }
        catch (CoreException coreException) {}
        return value;
    }

    public static final int getAttribute(ILaunchConfiguration lc, String attributeName, int defaultValue) {
        Assert.isNotNull((Object)lc);
        Assert.isNotNull((Object)attributeName);
        int value = defaultValue;
        try {
            value = lc.getAttribute(attributeName, defaultValue);
        }
        catch (CoreException coreException) {}
        return value;
    }

    public static final List<?> getAttribute(ILaunchConfiguration lc, String attributeName, List<?> defaultValue) {
        Assert.isNotNull((Object)lc);
        Assert.isNotNull((Object)attributeName);
        List value = defaultValue;
        try {
            value = lc.getAttribute(attributeName, defaultValue);
        }
        catch (CoreException coreException) {}
        return value;
    }

    public static final Set<?> getAttribute(ILaunchConfiguration lc, String attributeName, Set<?> defaultValue) {
        Assert.isNotNull((Object)lc);
        Assert.isNotNull((Object)attributeName);
        Set value = defaultValue;
        try {
            value = lc.getAttribute(attributeName, defaultValue);
        }
        catch (CoreException coreException) {}
        return value;
    }

    public static final Map<?, ?> getAttribute(ILaunchConfiguration lc, String attributeName, Map<?, ?> defaultValue) {
        Assert.isNotNull((Object)lc);
        Assert.isNotNull((Object)attributeName);
        Map value = defaultValue;
        try {
            value = lc.getAttribute(attributeName, defaultValue);
        }
        catch (CoreException coreException) {}
        return value;
    }

    public static final String getAttribute(ILaunchConfiguration lc, String attributeName, String defaultValue) {
        Assert.isNotNull((Object)lc);
        Assert.isNotNull((Object)attributeName);
        String value = defaultValue;
        try {
            value = lc.getAttribute(attributeName, defaultValue);
        }
        catch (CoreException coreException) {}
        return value;
    }

    public static final boolean hasAttribute(ILaunchConfiguration lc, String attributeName) {
        Assert.isNotNull((Object)lc);
        Assert.isNotNull((Object)attributeName);
        boolean hasAttribute = false;
        try {
            hasAttribute = lc.hasAttribute(attributeName);
        }
        catch (CoreException coreException) {}
        return hasAttribute;
    }
}

