/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.launch.ui.editor.tabs;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.tcf.internal.debug.ui.launch.TCFPathMapTab;
import org.eclipse.tcf.te.tcf.launch.ui.editor.AbstractTcfLaunchTabContainerEditorPage;
import org.eclipse.tcf.te.tcf.launch.ui.editor.tabs.TableUtils;
import org.eclipse.tcf.te.tcf.launch.ui.nls.Messages;

public class PathMapTab
extends TCFPathMapTab {
    private final AbstractTcfLaunchTabContainerEditorPage parentEditorPage;

    public PathMapTab(AbstractTcfLaunchTabContainerEditorPage parentEditorPage) {
        Assert.isNotNull((Object)((Object)parentEditorPage));
        this.parentEditorPage = parentEditorPage;
    }

    public final AbstractTcfLaunchTabContainerEditorPage getParentEditorPage() {
        return this.parentEditorPage;
    }

    protected void updateLaunchConfigurationDialog() {
        super.updateLaunchConfigurationDialog();
        this.performApply(AbstractTcfLaunchTabContainerEditorPage.getLaunchConfig(this.parentEditorPage.getPeerModel(this.parentEditorPage.getEditorInput())));
        this.parentEditorPage.checkLaunchConfigDirty();
    }

    public String getName() {
        return Messages.PathMapEditorPage_name;
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        TableViewer viewer = this.getViewer();
        if (viewer != null) {
            TableUtils.adjustTableColumnWidth((Viewer)viewer);
        }
    }

    protected String getColumnText(int column) {
        String text = super.getColumnText(column);
        String key = "PathMapEditorPage_column_" + text;
        if (Messages.hasString(key)) {
            text = Messages.getString(key);
        }
        return text;
    }

    protected int getColumnWidth(int column) {
        int width = -1;
        switch (column) {
            case 0: 
            case 1: {
                width = 27;
                break;
            }
            case 2: {
                width = 15;
                break;
            }
            default: {
                width = -1;
            }
        }
        return width != -1 ? width : super.getColumnWidth(column);
    }
}

