/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.processes.ui.editor.tree.columns;

import java.io.Serializable;
import java.util.Comparator;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.runtime.Assert;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.te.tcf.processes.core.model.interfaces.IProcessContextNode;
import org.eclipse.tcf.te.tcf.processes.ui.editor.tree.columns.CommandLineLabelProvider;

public class CommandLineComparator
implements Comparator<IProcessContextNode>,
Serializable {
    private static final long serialVersionUID = 1L;

    @Override
    public int compare(final IProcessContextNode o1, final IProcessContextNode o2) {
        final AtomicReference cmd1 = new AtomicReference();
        final AtomicReference cmdArgs1 = new AtomicReference();
        final AtomicReference cmd2 = new AtomicReference();
        final AtomicReference cmdArgs2 = new AtomicReference();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                String[] cmdline2;
                String[] cmdline1 = (String[])o1.getProperty("cmdline");
                if (cmdline1 != null && cmdline1.length > 0) {
                    cmd1.set(cmdline1[0]);
                    String[] args = new String[cmdline1.length - 1];
                    System.arraycopy(cmdline1, 1, args, 0, cmdline1.length - 1);
                    cmdArgs1.set(CommandLineLabelProvider.makeString(args));
                }
                if ((cmdline2 = (String[])o2.getProperty("cmdline")) != null && cmdline2.length > 0) {
                    cmd2.set(cmdline2[0]);
                    String[] args = new String[cmdline2.length - 1];
                    System.arraycopy(cmdline2, 1, args, 0, cmdline2.length - 1);
                    cmdArgs2.set(CommandLineLabelProvider.makeString(args));
                }
            }
        };
        Assert.isTrue((!Protocol.isDispatchThread() ? 1 : 0) != 0);
        Protocol.invokeAndWait((Runnable)runnable);
        if (cmd1.get() == null) {
            if (cmd2.get() == null) {
                return 0;
            }
            return -1;
        }
        if (cmd2.get() == null) {
            return 1;
        }
        int result = ((String)cmd1.get()).compareTo((String)cmd2.get());
        if (result == 0) {
            if (cmdArgs1.get() == null) {
                if (cmdArgs2.get() == null) {
                    return 0;
                }
                return -1;
            }
            if (cmdArgs2.get() == null) {
                return 1;
            }
            result = ((String)cmdArgs1.get()).compareTo((String)cmdArgs2.get());
        }
        return result;
    }
}

