/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.ui.editor;

import java.io.IOException;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.IMessageProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.te.runtime.persistence.interfaces.IURIPersistenceService;
import org.eclipse.tcf.te.runtime.services.ServiceManager;
import org.eclipse.tcf.te.runtime.services.interfaces.ISimulatorService;
import org.eclipse.tcf.te.runtime.statushandler.StatusHandlerUtil;
import org.eclipse.tcf.te.runtime.utils.StatusHelper;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerModel;
import org.eclipse.tcf.te.tcf.locator.interfaces.services.ILocatorModelRefreshService;
import org.eclipse.tcf.te.tcf.ui.help.IContextHelpIds;
import org.eclipse.tcf.te.tcf.ui.nls.Messages;
import org.eclipse.tcf.te.tcf.ui.sections.TargetSelectorSection;
import org.eclipse.tcf.te.ui.jface.interfaces.IValidatingContainer;
import org.eclipse.tcf.te.ui.views.ViewsUtil;
import org.eclipse.tcf.te.ui.views.editor.pages.AbstractCustomFormToolkitEditorPage;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.TableWrapData;

public abstract class AbstractConfigurationEditorPage
extends AbstractCustomFormToolkitEditorPage {
    TargetSelectorSection targetSelectorSection = null;

    protected void setInput(IEditorInput input) {
        IEditorInput oldInput = this.getEditorInput();
        if (oldInput != null && oldInput.equals(input)) {
            return;
        }
        super.setInput(input);
    }

    protected abstract String getHistoryId();

    protected boolean hasApplyAction() {
        return true;
    }

    protected void addTargetSelectorSection(IManagedForm form, Composite parent) {
        ISimulatorService service = (ISimulatorService)ServiceManager.getInstance().getService(this.getEditorInputNode(), ISimulatorService.class);
        if (service != null) {
            this.targetSelectorSection = this.doCreateTargetSelectorSection(form, parent);
            this.targetSelectorSection.getSection().setLayoutData((Object)new TableWrapData(256, 16));
            this.getManagedForm().addPart((IFormPart)this.targetSelectorSection);
        }
    }

    protected TargetSelectorSection getTargetSelectorSection() {
        return this.targetSelectorSection;
    }

    protected TargetSelectorSection doCreateTargetSelectorSection(IManagedForm form, Composite parent) {
        return new TargetSelectorSection(this.getManagedForm(), parent);
    }

    public void dispose() {
        if (this.targetSelectorSection != null) {
            this.targetSelectorSection.dispose();
            this.targetSelectorSection = null;
        }
        super.dispose();
    }

    public void setActive(boolean active) {
        super.setActive(active);
        if (this.targetSelectorSection != null) {
            this.targetSelectorSection.setActive(active);
        }
    }

    protected IValidatingContainer.ValidationResult doValidate() {
        IValidatingContainer.ValidationResult result = super.doValidate();
        if (this.targetSelectorSection != null) {
            this.targetSelectorSection.isValid();
            result.setResult((IMessageProvider)this.targetSelectorSection);
        }
        return result;
    }

    public void postDoSave(IProgressMonitor monitor) {
        super.postDoSave(monitor);
        final Object input = this.getEditorInputNode();
        if (input instanceof IPeerModel) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    try {
                        boolean isDynamic = !((IPeerModel)input).isStatic();
                        IURIPersistenceService uRIPersistenceService = (IURIPersistenceService)ServiceManager.getInstance().getService(IURIPersistenceService.class);
                        if (uRIPersistenceService == null) {
                            throw new IOException("Persistence service instance unavailable.");
                        }
                        uRIPersistenceService.write((Object)((IPeerModel)input).getPeer(), null);
                        if (isDynamic) {
                            ((ILocatorModelRefreshService)((IPeerModel)input).getModel().getService(ILocatorModelRefreshService.class)).refreshStaticPeers();
                            ViewsUtil.reopenEditor((IEditorPart)AbstractConfigurationEditorPage.this.getEditor(), (String)AbstractConfigurationEditorPage.this.getEditor().getActivePageInstance().getId(), (boolean)false);
                        }
                    }
                    catch (IOException e) {
                        String template = NLS.bind((String)Messages.AbstractConfigurationEditorPage_error_save, (Object)((IPeerModel)input).getName(), (Object)Messages.AbstractConfigurationEditorPage_error_possibleCause);
                        StatusHandlerUtil.handleStatus((IStatus)StatusHelper.getStatus((Throwable)e), (Object)input, (String)template, null, (String)IContextHelpIds.MESSAGE_SAVE_FAILED, (Object)((Object)AbstractConfigurationEditorPage.this), null);
                    }
                }
            };
            Assert.isTrue((!Protocol.isDispatchThread() ? 1 : 0) != 0);
            Protocol.invokeAndWait((Runnable)runnable);
            Protocol.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    ((IPeerModel)input).fireChangeEvent("properties", null, (Object)((IPeerModel)input).getProperties());
                }
            });
        }
    }
}

