/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.ui.navigator;

import java.util.HashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.tcf.protocol.IPeer;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.te.runtime.utils.net.IPAddressUtil;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerModel;
import org.eclipse.tcf.te.tcf.locator.interfaces.services.ILocatorModelLookupService;
import org.eclipse.tcf.te.tcf.locator.model.Model;
import org.eclipse.tcf.te.tcf.ui.activator.UIPlugin;
import org.eclipse.tcf.te.tcf.ui.navigator.images.PeerImageDescriptor;
import org.eclipse.tcf.te.tcf.ui.navigator.nodes.PeerRedirectorGroupNode;
import org.eclipse.tcf.te.tcf.ui.nls.Messages;
import org.eclipse.tcf.te.ui.views.extensions.LabelProviderDelegateExtensionPointManager;

public class DelegatingLabelProvider
extends LabelProvider
implements ILabelDecorator {
    public String getText(final Object element) {
        String text;
        ILabelProvider[] delegates = LabelProviderDelegateExtensionPointManager.getInstance().getDelegates(element, false);
        if (delegates != null && delegates.length > 0 && (text = delegates[0].getText(element)) != null) {
            return text;
        }
        if (element instanceof IPeerModel || element instanceof IPeer) {
            String label;
            StringBuilder builder = new StringBuilder();
            final HashMap attrs = new HashMap();
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    if (element instanceof IPeerModel) {
                        attrs.putAll(((IPeerModel)element).getProperties());
                        attrs.putAll(((IPeerModel)element).getPeer().getAttributes());
                    } else if (element instanceof IPeer) {
                        attrs.putAll(((IPeer)element).getAttributes());
                    }
                }
            };
            if (Protocol.isDispatchThread()) {
                runnable.run();
            } else {
                Protocol.invokeAndWait((Runnable)runnable);
            }
            builder.append((String)attrs.get("Name"));
            if (this.isAppendAddressText(builder.toString())) {
                String dnsName = (String)attrs.get("dns.name.transient");
                String ip = (String)attrs.get("Host");
                String port = (String)attrs.get("Port");
                if (ip != null && !"".equals(ip.trim())) {
                    builder.append(" ");
                    if (!IPAddressUtil.getInstance().isLocalHost(ip)) {
                        builder.append(dnsName != null && !"".equals(dnsName.trim()) ? dnsName.trim() : ip.trim());
                    }
                    if (port != null && !"".equals(port.trim()) && !"1534".equals(port.trim())) {
                        builder.append(":");
                        builder.append(port.trim());
                    }
                }
            }
            if (!"".equals((label = builder.toString()).trim())) {
                return label;
            }
        } else if (element instanceof PeerRedirectorGroupNode) {
            return Messages.RemotePeerDiscoveryRootNode_label;
        }
        return "";
    }

    protected boolean isAppendAddressText(final String label) {
        boolean append;
        Assert.isNotNull((Object)label);
        boolean bl = append = "TCF Agent".equals(label) || "TCF Proxy".equals(label);
        if (!append) {
            final AtomicInteger count = new AtomicInteger();
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    count.set(((ILocatorModelLookupService)Model.getModel().getService(ILocatorModelLookupService.class)).lkupPeerModelByName(label).length);
                }
            };
            if (Protocol.isDispatchThread()) {
                runnable.run();
            } else {
                Protocol.invokeAndWait((Runnable)runnable);
            }
            append = count.get() > 1;
        }
        return append;
    }

    public Image getImage(final Object element) {
        Image image;
        ILabelProvider[] delegates = LabelProviderDelegateExtensionPointManager.getInstance().getDelegates(element, false);
        if (delegates != null && delegates.length > 0 && (image = delegates[0].getImage(element)) != null) {
            return image;
        }
        if (element instanceof IPeerModel || element instanceof IPeer) {
            final AtomicBoolean isStatic = new AtomicBoolean();
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    if (element instanceof IPeerModel) {
                        isStatic.set(((IPeerModel)element).isStatic());
                    } else if (element instanceof IPeer) {
                        String value = (String)((IPeer)element).getAttributes().get("static.transient");
                        isStatic.set(value != null && Boolean.parseBoolean(value.trim()));
                    }
                }
            };
            if (Protocol.isDispatchThread()) {
                runnable.run();
            } else {
                Protocol.invokeAndWait((Runnable)runnable);
            }
            return isStatic.get() ? UIPlugin.getImage("PeerObject") : UIPlugin.getImage("PeerObjectDiscovered");
        }
        if (element instanceof PeerRedirectorGroupNode) {
            return UIPlugin.getImage("RemotePeerDiscoverRootNodeObject");
        }
        return super.getImage(element);
    }

    public Image decorateImage(Image image, Object element) {
        Image decoratedImage = null;
        if (image != null && element instanceof IPeerModel) {
            boolean isStatic;
            Image candidate;
            ILabelProvider[] delegates = LabelProviderDelegateExtensionPointManager.getInstance().getDelegates(element, false);
            if (delegates != null && delegates.length > 0 && delegates[0] instanceof ILabelDecorator && (candidate = ((ILabelDecorator)delegates[0]).decorateImage(image, element)) != null) {
                image = candidate;
            }
            if (!(isStatic = ((IPeerModel)element).isStatic())) {
                PeerImageDescriptor descriptor = new PeerImageDescriptor(UIPlugin.getDefault().getImageRegistry(), image, (IPeerModel)element);
                decoratedImage = UIPlugin.getSharedImage(descriptor);
            }
        }
        return decoratedImage;
    }

    public String decorateText(String text, final Object element) {
        String candidate;
        String label = text;
        ILabelProvider[] delegates = LabelProviderDelegateExtensionPointManager.getInstance().getDelegates(element, false);
        if (delegates != null && delegates.length > 0 && delegates[0] instanceof ILabelDecorator && (candidate = ((ILabelDecorator)delegates[0]).decorateText(label, element)) != null) {
            label = candidate;
        }
        if (element instanceof IPeerModel) {
            final StringBuilder builder = new StringBuilder(label != null && !"".equals(label.trim()) ? label.trim() : "<noname>");
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    DelegatingLabelProvider.this.doDecorateText(builder, (IPeerModel)element);
                }
            };
            if (Protocol.isDispatchThread()) {
                runnable.run();
            } else {
                Protocol.invokeAndWait((Runnable)runnable);
            }
            label = builder.toString();
            if (!"".equals(label.trim()) && !"<noname>".equals(label.trim())) {
                return label;
            }
        }
        return null;
    }

    void doDecorateText(StringBuilder builder, IPeerModel peerModel) {
        Assert.isNotNull((Object)builder);
        Assert.isNotNull((Object)peerModel);
        Assert.isTrue((boolean)Protocol.isDispatchThread());
        boolean isStatic = peerModel.isStatic();
        int state = peerModel.getIntProperty("state");
        if (!(state <= -1 || isStatic && state != 0 && state != 1 && state != 4)) {
            builder.append(" [");
            builder.append(Messages.getString("LabelProviderDelegate_state_" + state));
            builder.append("]");
        }
    }
}

