/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.ui.navigator;

import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.te.runtime.interfaces.IDisposable;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerModel;
import org.eclipse.tcf.te.tcf.locator.model.Model;
import org.eclipse.tcf.te.tcf.ui.navigator.nodes.PeerRedirectorGroupNode;
import org.eclipse.ui.navigator.CommonViewer;

public class TreeViewerListener
implements ITreeViewerListener,
IDisposable {
    private final CommonViewer viewer;

    public TreeViewerListener(CommonViewer viewer) {
        Assert.isNotNull((Object)viewer);
        this.viewer = viewer;
    }

    public void dispose() {
        this.viewer.removeTreeListener((ITreeViewerListener)this);
    }

    public void treeCollapsed(TreeExpansionEvent event) {
        List candidates;
        if (event.getElement() instanceof PeerRedirectorGroupNode && (candidates = Model.getModel().getChildren(((PeerRedirectorGroupNode)event.getElement()).peerId)) != null && candidates.size() > 0) {
            Protocol.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    for (IPeerModel candidate : candidates) {
                        TreeViewerListener.this.markExcluded(candidate);
                    }
                }
            });
        }
    }

    void markExcluded(IPeerModel peerModel) {
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        Assert.isNotNull((Object)peerModel);
        peerModel.setProperty("scanner.exclude.silent", true);
        List candidates = Model.getModel().getChildren(peerModel.getPeerId());
        if (candidates != null && candidates.size() > 0) {
            for (IPeerModel candidate : candidates) {
                this.markExcluded(candidate);
            }
        }
    }

    public void treeExpanded(TreeExpansionEvent event) {
    }
}

