/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.debug.ui.model;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;

public class TCFNumberFormat {
    public static String isValidHexNumber(String s) {
        int l = s.length();
        if (l == 0) {
            return "Need at least one digit";
        }
        int i = 0;
        while (i < l) {
            char ch = s.charAt(i);
            if (!(ch >= '0' && ch <= '9' || ch >= 'A' && ch <= 'F' || ch >= 'a' && ch <= 'f')) {
                return "Hex digit expected";
            }
            ++i;
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public static String isValidDecNumber(boolean fp, String s) {
        i = 0;
        l = s.length();
        if (l == 0) {
            return "Need at least one digit";
        }
        if ((ch = s.charAt(i++)) == '-' || ch == '+') {
            if (i >= l) {
                return "Need at least one digit";
            }
            ch = s.charAt(i++);
        }
        if (!fp) ** GOTO lbl18
        n = s.substring(i - 1);
        if (n.equals("NaN")) {
            return null;
        }
        if (!n.equals("Infinity")) ** GOTO lbl18
        return null;
lbl-1000:
        // 1 sources

        {
            if (i >= l) {
                return null;
            }
            ch = s.charAt(i++);
lbl18:
            // 3 sources

            ** while (ch >= '0' && ch <= '9')
        }
lbl19:
        // 1 sources

        if (fp) {
            if (ch == '.') {
                if (i >= l) {
                    return null;
                }
                ch = s.charAt(i++);
                while (ch >= '0' && ch <= '9') {
                    if (i >= l) {
                        return null;
                    }
                    ch = s.charAt(i++);
                }
            }
            if (ch == 'e' || ch == 'E') {
                if (i >= l) {
                    return "Invalid exponent: need at least one digit";
                }
                if ((ch = s.charAt(i++)) == '-' || ch == '+') {
                    if (i >= l) {
                        return "Invalid exponent: need at least one digit";
                    }
                    ch = s.charAt(i++);
                }
                while (ch >= '0' && ch <= '9') {
                    if (i >= l) {
                        return null;
                    }
                    ch = s.charAt(i++);
                }
                return "Invalid exponent: decimal digit expected";
            }
        }
        return "Decimal digit expected";
    }

    public static byte[] toByteArray(String s, int radix, boolean fp, int size, boolean signed, boolean big_endian) throws Exception {
        int i;
        byte[] bf = null;
        if (!fp) {
            bf = new BigInteger(s, radix).toByteArray();
        } else if (size == 4) {
            int n = Float.floatToIntBits(Float.parseFloat(s));
            bf = new byte[size];
            i = 0;
            while (i < size) {
                bf[i] = (byte)(n >> (size - 1 - i) * 8 & 0xFF);
                ++i;
            }
        } else if (size == 8) {
            long n = Double.doubleToLongBits(Double.parseDouble(s));
            bf = new byte[size];
            int i2 = 0;
            while (i2 < size) {
                bf[i2] = (byte)(n >> (size - 1 - i2) * 8 & 0xFFL);
                ++i2;
            }
        } else if (size == 2 || size == 10 || size == 16) {
            BigDecimal d = new BigDecimal(s);
            int n = 0;
            int bin_scale = 0;
            n = 0;
            while (n < 1000) {
                int x;
                int scale = (d = d.stripTrailingZeros()).scale();
                if (scale > 0 && (x = d.precision()) > 36) {
                    if ((x -= 36) > scale) {
                        x = scale;
                    }
                    d = d.setScale(scale - x, RoundingMode.HALF_DOWN);
                } else if (scale < 0) {
                    d = d.divide(BigDecimal.valueOf(2L).pow(-scale));
                    bin_scale += scale;
                } else {
                    if (scale <= 0) break;
                    d = d.multiply(BigDecimal.valueOf(2L).pow(scale));
                    bin_scale += scale;
                }
                ++n;
            }
            BigInteger man = d.unscaledValue();
            int cmp = man.compareTo(BigInteger.ZERO);
            bf = new byte[size];
            if (cmp != 0) {
                boolean sign;
                boolean bl = sign = cmp < 0;
                if (sign) {
                    man = man.negate();
                }
                int man_bits = man.bitLength();
                int man_offs = 0;
                int exp = 0;
                while (true) {
                    if (size == 2) {
                        exp = man_bits - bin_scale + 14;
                        if (exp <= 0) {
                            man_bits += 1 - exp;
                            exp = 0;
                        }
                        if (exp > 31) {
                            exp = 31;
                        }
                        man_offs = 5;
                    } else {
                        exp = man_bits - bin_scale + 16382;
                        if (exp <= 0) {
                            man_bits += 1 - exp;
                            exp = 0;
                        } else if (size == 10) {
                            ++man_bits;
                        }
                        if (exp > Short.MAX_VALUE) {
                            exp = Short.MAX_VALUE;
                        }
                        man_offs = 15;
                    }
                    int rb = man_offs + man_bits - size * 8 - 1;
                    if (rb < 0 || !man.testBit(rb)) break;
                    man = man.add(BigInteger.ONE.shiftLeft(rb));
                    man_bits = man.bitLength();
                }
                if (sign) {
                    bf[0] = (byte)(bf[0] | 0x80);
                }
                int i3 = 1;
                while (i3 <= man_offs) {
                    if ((1 << man_offs - i3 & exp) != 0) {
                        int n2 = i3 / 8;
                        bf[n2] = (byte)(bf[n2] | 1 << 7 - i3 % 8);
                    }
                    ++i3;
                }
                i3 = 0;
                while (i3 < man_bits) {
                    int j = man_offs + i3;
                    int k = man_bits - i3 - 1;
                    if (j / 8 < bf.length) {
                        if (i3 == 0) {
                            assert (man.testBit(k) == (exp > 0 && size != 10));
                        } else if (man.testBit(k)) {
                            int n3 = j / 8;
                            bf[n3] = (byte)(bf[n3] | 1 << 7 - j % 8);
                        }
                        ++i3;
                        continue;
                    }
                    break;
                }
            }
        } else {
            throw new Exception("Unsupported floating point format");
        }
        byte[] rs = new byte[size];
        if (signed && rs.length > bf.length && (bf[0] & 0x80) != 0) {
            i = 0;
            while (i < rs.length) {
                rs[i] = -1;
                ++i;
            }
        }
        i = 0;
        while (i < bf.length) {
            int j;
            byte b = bf[bf.length - i - 1];
            int n = j = big_endian ? rs.length - i - 1 : i;
            if (j >= 0 && j < rs.length) {
                rs[j] = b;
            }
            ++i;
        }
        return rs;
    }

    public static String toFPString(byte[] data, boolean big_endian) {
        return TCFNumberFormat.toFPString(data, 0, data.length, big_endian);
    }

    public static String toFPString(byte[] data, int offs, int size, boolean big_endian) {
        assert (offs + size <= data.length);
        byte[] arr = new byte[size];
        if (big_endian) {
            System.arraycopy(data, offs, arr, 0, size);
        } else {
            int i = 0;
            while (i < size) {
                arr[arr.length - i - 1] = data[offs + i];
                ++i;
            }
        }
        boolean neg = (arr[0] & 0x80) != 0;
        arr[0] = (byte)(arr[0] & 0x7F);
        int precision = 0;
        int exponent = 0;
        boolean nan = false;
        switch (size) {
            case 2: {
                precision = 3;
                exponent = (arr[0] & 0x7C) >> 2;
                nan = exponent == 31;
                arr[0] = (byte)(arr[0] & 3);
                if (exponent == 0) {
                    exponent = 1;
                } else if (!nan) {
                    arr[0] = (byte)(arr[0] | 4);
                }
                exponent -= 10;
                exponent -= 15;
                break;
            }
            case 4: {
                precision = 7;
                exponent = (arr[0] & 0x7F) << 1 | (arr[1] & 0x80) >> 7;
                nan = exponent == 255;
                arr[0] = 0;
                arr[1] = (byte)(arr[1] & 0x7F);
                if (exponent == 0) {
                    exponent = 1;
                } else if (!nan) {
                    arr[1] = (byte)(arr[1] | 0x80);
                }
                exponent -= 23;
                exponent -= 127;
                break;
            }
            case 8: {
                precision = 16;
                exponent = (arr[0] & 0x7F) << 4 | (arr[1] & 0xF0) >> 4;
                nan = exponent == 2047;
                arr[0] = 0;
                arr[1] = (byte)(arr[1] & 0xF);
                if (exponent == 0) {
                    exponent = 1;
                } else if (!nan) {
                    arr[1] = (byte)(arr[1] | 0x10);
                }
                exponent -= 52;
                exponent -= 1023;
                break;
            }
            case 10: 
            case 16: {
                precision = 34;
                exponent = (arr[0] & 0x7F) << 8 | arr[1] & 0xFF;
                nan = exponent == Short.MAX_VALUE;
                arr[1] = 0;
                arr[0] = 0;
                if (size == 10) {
                    exponent -= 63;
                    if (nan) {
                        arr[2] = (byte)(arr[2] & 0x7F);
                    }
                } else {
                    if (exponent == 0) {
                        exponent = 1;
                    } else if (!nan) {
                        arr[1] = 1;
                    }
                    exponent -= 112;
                }
                exponent -= 16383;
                break;
            }
            default: {
                return null;
            }
        }
        if (nan) {
            int i = 0;
            while (i < arr.length) {
                if (arr[i] != 0) {
                    return neg ? "-NaN" : "+NaN";
                }
                ++i;
            }
            return neg ? "-Infinity" : "+Infinity";
        }
        BigDecimal a = new BigDecimal(new BigInteger(arr), 0);
        if (a.signum() != 0 && exponent != 0) {
            BigDecimal p = new BigDecimal(BigInteger.valueOf(2L), 0);
            if (exponent > 0) {
                a = a.multiply(p.pow(exponent));
            } else {
                BigDecimal b = p.pow(-exponent);
                a = a.divide(b, b.precision(), RoundingMode.HALF_DOWN);
            }
            if (precision != 0 && a.precision() > precision) {
                int scale = a.scale() - a.precision() + precision;
                a = a.setScale(scale, RoundingMode.HALF_DOWN);
            }
        }
        String s = a.toString();
        if (neg) {
            s = "-" + s;
        }
        return s;
    }

    public static BigInteger toBigInteger(byte[] data, boolean big_endian, boolean sign_extension) {
        return TCFNumberFormat.toBigInteger(data, 0, data.length, big_endian, sign_extension);
    }

    public static BigInteger toBigInteger(byte[] data, int offs, int size, boolean big_endian, boolean sign_extension) {
        assert (offs + size <= data.length);
        byte[] temp = null;
        if (sign_extension) {
            temp = new byte[size];
        } else {
            temp = new byte[size + 1];
            temp[0] = 0;
        }
        if (big_endian) {
            System.arraycopy(data, offs, temp, sign_extension ? 0 : 1, size);
        } else {
            int i = 0;
            while (i < size) {
                temp[temp.length - i - 1] = data[i + offs];
                ++i;
            }
        }
        return new BigInteger(temp);
    }
}

