/*******************************************************************************
 * Copyright (c) 2011, 2013 Wind River Systems, Inc. and others. All rights reserved.
 * This program and the accompanying materials are made available under the terms
 * of the Eclipse Public License v1.0 which accompanies this distribution, and is
 * available at http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * Wind River Systems - initial API and implementation
 *******************************************************************************/
package org.eclipse.tcf.te.ui.views.expressions;

import org.eclipse.tcf.te.runtime.services.ServiceManager;
import org.eclipse.tcf.te.runtime.services.interfaces.IUIService;
import org.eclipse.tcf.te.ui.interfaces.handler.IEditorHandlerDelegate;
import org.eclipse.tcf.te.ui.views.editor.Editor;
import org.eclipse.tcf.te.ui.views.editor.EditorInput;
import org.eclipse.tcf.te.ui.views.extensions.EditorPageBindingExtensionPointManager;
import org.eclipse.ui.IEditorInput;


/**
 * Property tester implementation.
 */
public class PropertyTester extends org.eclipse.core.expressions.PropertyTester {

	/* (non-Javadoc)
	 * @see org.eclipse.core.expressions.IPropertyTester#test(java.lang.Object, java.lang.String, java.lang.Object[], java.lang.Object)
	 */
	@Override
	public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {

		if ("hasApplicableEditorBindings".equals(property)) { //$NON-NLS-1$
			IUIService service = ServiceManager.getInstance().getService(receiver, IUIService.class);
			IEditorHandlerDelegate delegate = service != null ? service.getDelegate(receiver, IEditorHandlerDelegate.class) : null;
			IEditorInput input = (delegate != null) ? delegate.getEditorInput(receiver) : new EditorInput(receiver);

			return (expectedValue != null ? expectedValue : Boolean.TRUE).equals(Boolean.valueOf(EditorPageBindingExtensionPointManager.getInstance().getApplicableEditorPageBindings(input).length > 0));
		}

		if ("isDirty".equals(property) && receiver instanceof Editor && expectedValue instanceof Boolean) { //$NON-NLS-1$
			Editor editor = (Editor) receiver;
			return ((Boolean)expectedValue).booleanValue() == editor.isDirty();
		}

		return false;
	}

}
