/*******************************************************************************
 * Copyright (c) 2013 Xilinx, Inc. and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Xilinx - initial API and implementation
 *******************************************************************************/
package org.eclipse.tcf.services;

import java.util.Map;

import org.eclipse.tcf.protocol.IService;
import org.eclipse.tcf.protocol.IToken;

/**
 * DPrintf service provides access to "dynamic printf" output stream that is generated by invocations of
 * '$printf' function on the remote target. '$printf' is usually used as a breakpoint action.
 */
public interface IDPrintf extends IService {

    /**
     * Service name.
     */
    static final String NAME = "DPrintf";

    /**
     * Open "dynamic printf" stream and get ID of the stream.
     * The service maintains one such stream per client.
     * The stream is managed by Streams service.
     * @param properties - optional stream properties.
     * @param done - command result call back object.
     * @return - pending command handle.
     */
    IToken open(Map<String,Object>[] properties, DoneCommandOpen done);

    interface DoneCommandOpen {
        void doneCommandOpen(IToken token, Exception error, String id);
    }

    /**
     * Close "dynamic printf" stream.
     * Further '$printf' output will be discarded.
     * @param done - command result call back object.
     * @return - pending command handle.
     */
    IToken close(DoneCommandClose done);

    interface DoneCommandClose {
        void doneCommandClose(IToken token, Exception error);
    }
}
