/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.services.remote;

import java.util.Collection;
import java.util.Map;
import org.eclipse.tcf.core.Command;
import org.eclipse.tcf.protocol.IChannel;
import org.eclipse.tcf.protocol.IService;
import org.eclipse.tcf.protocol.IToken;
import org.eclipse.tcf.services.IProfiler;

public class ProfilerProxy
implements IProfiler {
    private final IChannel channel;

    public ProfilerProxy(IChannel channel) {
        this.channel = channel;
    }

    @Override
    public String getName() {
        return "Profiler";
    }

    @Override
    public IToken configure(String ctx, Map<String, Object> params, final IProfiler.DoneConfigure done) {
        return new Command((IChannel)this.channel, (IService)this, (String)"configure", (Object[])new Object[]{ctx, params}){

            @Override
            public void done(Exception error, Object[] args) {
                if (error == null) {
                    if (!$assertionsDisabled && args.length != 1) {
                        throw new AssertionError();
                    }
                    error = this.toError(args[0]);
                }
                done.doneConfigure(this.token, error);
            }
        }.token;
    }

    @Override
    public IToken read(String ctx, final IProfiler.DoneRead done) {
        return new Command((IChannel)this.channel, (IService)this, (String)"read", (Object[])new Object[]{ctx}){

            @Override
            public void done(Exception error, Object[] args) {
                Map[] data = null;
                if (error == null) {
                    if (!$assertionsDisabled && args.length != 2) {
                        throw new AssertionError();
                    }
                    error = this.toError(args[0]);
                    data = ProfilerProxy.this.toDataArray(args[1]);
                }
                done.doneRead(this.token, error, data);
            }
        }.token;
    }

    private Map<String, Object>[] toDataArray(Object o) {
        if (o == null) {
            return null;
        }
        Collection c = (Collection)o;
        return c.toArray(new Map[c.size()]);
    }
}

