/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.debug.ui.launch;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.tcf.internal.debug.ui.ImageCache;
import org.eclipse.tcf.internal.debug.ui.model.TCFModel;
import org.eclipse.tcf.services.IPathMap;

class PathMapRuleDialog
extends Dialog {
    private final IPathMap.PathMapRule pathMapRule;
    private final boolean enable_editing;
    private final Image image;
    private Text source_text;
    private Text destination_text;
    private Text context_query_text;
    private Button destination_button;

    PathMapRuleDialog(Shell parent, Image image, IPathMap.PathMapRule pathMapRule, boolean enable_editing) {
        super(parent);
        this.image = image != null ? image : ImageCache.getImage("icons/path.gif");
        this.pathMapRule = pathMapRule;
        this.enable_editing = enable_editing;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("File Path Map Rule");
        shell.setImage(this.image);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.updateButtons();
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.createFileNameFields(composite);
        this.setData();
        composite.setSize(composite.computeSize(-1, -1));
        return composite;
    }

    private void createFileNameFields(Composite parent) {
        Font font = parent.getFont();
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(3, false);
        composite.setFont(font);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(768));
        Label source_label = new Label(composite, 0);
        source_label.setLayoutData((Object)new GridData(32));
        source_label.setFont(font);
        source_label.setText("Source:");
        this.source_text = new Text(composite, 2052);
        GridData gd = new GridData(768);
        gd.widthHint = 300;
        gd.horizontalSpan = 2;
        this.source_text.setLayoutData((Object)gd);
        this.source_text.setFont(font);
        this.source_text.setEditable(this.enable_editing);
        this.source_text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PathMapRuleDialog.this.updateButtons();
            }
        });
        Label destination_label = new Label(composite, 0);
        destination_label.setLayoutData((Object)new GridData(32));
        destination_label.setFont(font);
        destination_label.setText("Destination:");
        this.destination_text = new Text(composite, 2052);
        this.destination_text.setLayoutData((Object)new GridData(768));
        this.destination_text.setFont(font);
        this.destination_text.setEditable(this.enable_editing);
        this.destination_text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PathMapRuleDialog.this.updateButtons();
            }
        });
        this.destination_button = new Button(composite, 8);
        this.destination_button.setText("Browse...");
        this.destination_button.setFont(font);
        this.destination_button.setLayoutData((Object)new GridData(32));
        this.destination_button.setEnabled(this.enable_editing);
        this.destination_button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dialog = new DirectoryDialog(PathMapRuleDialog.this.getShell(), 0);
                dialog.setFilterPath(PathMapRuleDialog.this.destination_text.getText());
                String path = dialog.open();
                if (path != null) {
                    PathMapRuleDialog.this.destination_text.setText(path);
                }
            }
        });
        Label context_query_label = new Label(composite, 0);
        context_query_label.setLayoutData((Object)new GridData(32));
        context_query_label.setFont(font);
        context_query_label.setText("Context Query:");
        this.context_query_text = new Text(composite, 2052);
        gd = new GridData(768);
        gd.widthHint = 200;
        gd.horizontalSpan = 2;
        this.context_query_text.setLayoutData((Object)gd);
        this.context_query_text.setFont(font);
        this.context_query_text.setEditable(this.enable_editing);
        this.context_query_text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PathMapRuleDialog.this.updateButtons();
            }
        });
    }

    private void setData() {
        this.source_text.setText(this.pathMapRule.getSource() != null ? this.pathMapRule.getSource() : "");
        this.destination_text.setText(this.pathMapRule.getDestination() != null ? this.pathMapRule.getDestination() : "");
        this.context_query_text.setText(this.pathMapRule.getContextQuery() != null ? this.pathMapRule.getContextQuery() : "");
        this.updateButtons();
    }

    private void getData() {
        if (this.source_text.getText().trim().length() > 0) {
            this.pathMapRule.getProperties().put("Source", this.source_text.getText());
        } else {
            this.pathMapRule.getProperties().remove("Source");
        }
        if (this.destination_text.getText().trim().length() > 0) {
            this.pathMapRule.getProperties().put("Destination", this.destination_text.getText());
        } else {
            this.pathMapRule.getProperties().remove("Destination");
        }
        if (this.context_query_text.getText().trim().length() > 0) {
            this.pathMapRule.getProperties().put("ContextQuery", this.context_query_text.getText());
        } else {
            this.pathMapRule.getProperties().remove("ContextQuery");
        }
    }

    private void updateButtons() {
        Button btn = this.getButton(0);
        if (btn != null && this.source_text != null) {
            btn.setEnabled(!this.enable_editing || this.source_text.getText().trim().length() > 0);
        }
    }

    protected void okPressed() {
        if (this.enable_editing) {
            try {
                this.getData();
            }
            catch (Throwable x) {
                MessageBox mb = new MessageBox(this.getShell(), 33);
                mb.setText("Invalid data");
                mb.setMessage(TCFModel.getErrorMessage(x, true));
                mb.open();
                return;
            }
        }
        super.okPressed();
    }
}

