/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.locator.internal.adapters;

import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.tcf.protocol.IPeer;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.te.runtime.model.factory.Factory;
import org.eclipse.tcf.te.runtime.persistence.interfaces.IPersistableURIProvider;
import org.eclipse.tcf.te.runtime.stepper.interfaces.IStepContext;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.ILocatorModel;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerModel;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerModelProvider;
import org.eclipse.tcf.te.tcf.locator.interfaces.services.ILocatorModelLookupService;
import org.eclipse.tcf.te.tcf.locator.internal.adapters.PeerModelStepContext;
import org.eclipse.tcf.te.tcf.locator.internal.adapters.PeerPersistableURIProvider;
import org.eclipse.tcf.te.tcf.locator.model.Model;

public class AdapterFactory
implements IAdapterFactory {
    private final IPersistableURIProvider peerModelPersistableURIProvider = new PeerPersistableURIProvider();
    private static final Class<?>[] CLASSES = new Class[]{IPersistableURIProvider.class, IPeerModel.class};

    public Object getAdapter(Object adaptableObject, Class adapterType) {
        if (adaptableObject instanceof Map && IPersistableURIProvider.class.equals((Object)adapterType)) {
            Assert.isTrue((boolean)false);
        }
        if (ILocatorModel.class.isAssignableFrom(adapterType) && adaptableObject instanceof IPeerModel) {
            return ((IPeerModel)adaptableObject).getModel();
        }
        if (adaptableObject instanceof IPeerModel || adaptableObject instanceof IPeer || adaptableObject instanceof IPeerModelProvider) {
            if (IPersistableURIProvider.class.equals((Object)adapterType)) {
                return this.peerModelPersistableURIProvider;
            }
            if (IPeerModel.class.equals((Object)adapterType)) {
                if (adaptableObject instanceof IPeer) {
                    final AtomicReference node = new AtomicReference();
                    final IPeer peer = (IPeer)adaptableObject;
                    Runnable runnable = new Runnable(){

                        @Override
                        public void run() {
                            String id = peer.getID();
                            ILocatorModel model = Model.getModel();
                            Assert.isNotNull((Object)model);
                            IPeerModel candidate = model.getService(ILocatorModelLookupService.class).lkupPeerModelById(id);
                            if (candidate != null) {
                                node.set(candidate);
                            } else {
                                candidate = (IPeerModel)Factory.getInstance().newInstance(IPeerModel.class, new Object[]{model, peer});
                                if (candidate != null) {
                                    node.set(candidate);
                                }
                            }
                        }
                    };
                    if (Protocol.isDispatchThread()) {
                        runnable.run();
                    } else {
                        Protocol.invokeAndWait((Runnable)runnable);
                    }
                    return node.get();
                }
                if (adaptableObject instanceof IPeerModel) {
                    return adaptableObject;
                }
                if (adaptableObject instanceof IPeerModelProvider) {
                    final AtomicReference node = new AtomicReference();
                    final IPeerModelProvider provider = (IPeerModelProvider)adaptableObject;
                    Runnable runnable = new Runnable(){

                        @Override
                        public void run() {
                            node.set(provider.getPeerModel());
                        }
                    };
                    if (Protocol.isDispatchThread()) {
                        runnable.run();
                    } else {
                        Protocol.invokeAndWait((Runnable)runnable);
                    }
                    return node.get();
                }
            }
            if (IStepContext.class.equals((Object)adapterType) && adaptableObject instanceof IPeerModel) {
                return new PeerModelStepContext((IPeerModel)adaptableObject);
            }
        }
        return null;
    }

    public Class[] getAdapterList() {
        return CLASSES;
    }
}

