/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.ui.terminals.process;

import org.eclipse.cdt.utils.pty.PTY;
import org.eclipse.core.runtime.Assert;
import org.eclipse.tcf.te.runtime.interfaces.properties.IPropertiesContainer;
import org.eclipse.tcf.te.ui.terminals.streams.OutputStreamMonitor;
import org.eclipse.tm.internal.terminal.provisional.api.ISettingsStore;

public class ProcessSettings {
    private String image;
    private String arguments;
    private Process process;
    private PTY pty;
    private boolean localEcho = !PTY.isSupported();
    private String lineSeparator = null;
    private OutputStreamMonitor.Listener[] stdoutListeners = null;
    private OutputStreamMonitor.Listener[] stderrListeners = null;

    public void setImage(String image) {
        this.image = image;
    }

    public String getImage() {
        return this.image;
    }

    public void setArguments(String arguments) {
        this.arguments = arguments;
    }

    public String getArguments() {
        return this.arguments;
    }

    public void setProcess(Process process) {
        this.process = process;
    }

    public Process getProcess() {
        return this.process;
    }

    public void setPTY(PTY pty) {
        this.pty = pty;
        if (pty == null) {
            this.setLocalEcho(true);
        }
    }

    public PTY getPTY() {
        return this.pty;
    }

    public void setLocalEcho(boolean value) {
        this.localEcho = value;
    }

    public boolean isLocalEcho() {
        return this.localEcho;
    }

    public void setLineSeparator(String separator) {
        this.lineSeparator = separator;
    }

    public String getLineSeparator() {
        return this.lineSeparator;
    }

    public void setStdOutListeners(OutputStreamMonitor.Listener[] listeners) {
        this.stdoutListeners = listeners;
    }

    public OutputStreamMonitor.Listener[] getStdOutListeners() {
        return this.stdoutListeners;
    }

    public void setStdErrListeners(OutputStreamMonitor.Listener[] listeners) {
        this.stderrListeners = listeners;
    }

    public OutputStreamMonitor.Listener[] getStdErrListeners() {
        return this.stderrListeners;
    }

    public void load(ISettingsStore store) {
        Assert.isNotNull((Object)store);
        this.image = store.get("Path", null);
        this.arguments = store.get("Arguments", null);
        this.localEcho = Boolean.parseBoolean(store.get("LocalEcho", Boolean.FALSE.toString()));
        this.lineSeparator = store.get("LineSeparator", null);
        if (store instanceof IPropertiesContainer) {
            this.process = (Process)((IPropertiesContainer)store).getProperty("Process");
            this.pty = (PTY)((IPropertiesContainer)store).getProperty("PTY");
            this.stdoutListeners = (OutputStreamMonitor.Listener[])((IPropertiesContainer)store).getProperty("StdOutListeners");
            this.stderrListeners = (OutputStreamMonitor.Listener[])((IPropertiesContainer)store).getProperty("StdErrListeners");
        }
    }

    public void save(ISettingsStore store) {
        Assert.isNotNull((Object)store);
        store.put("Path", this.image);
        store.put("Arguments", this.arguments);
        store.put("LocalEcho", Boolean.toString(this.localEcho));
        store.put("LineSeparator", this.lineSeparator);
        if (store instanceof IPropertiesContainer) {
            ((IPropertiesContainer)store).setProperty("Process", (Object)this.process);
            ((IPropertiesContainer)store).setProperty("PTY", (Object)this.pty);
            ((IPropertiesContainer)store).setProperty("StdOutListeners", (Object)this.stdoutListeners);
            ((IPropertiesContainer)store).setProperty("StdErrListeners", (Object)this.stderrListeners);
        }
    }
}

