/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.services.remote;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.tcf.core.Command;
import org.eclipse.tcf.protocol.IChannel;
import org.eclipse.tcf.protocol.IService;
import org.eclipse.tcf.protocol.IToken;
import org.eclipse.tcf.protocol.JSON;
import org.eclipse.tcf.services.IExpressions;
import org.eclipse.tcf.services.ISymbols;

public class ExpressionsProxy
implements IExpressions {
    private final IChannel channel;
    private final Map<IExpressions.ExpressionsListener, IChannel.IEventListener> listeners = new HashMap<IExpressions.ExpressionsListener, IChannel.IEventListener>();

    public ExpressionsProxy(IChannel channel) {
        this.channel = channel;
    }

    @Override
    public IToken assign(String id, byte[] value, final IExpressions.DoneAssign done) {
        return new Command((IChannel)this.channel, (IService)this, (String)"assign", (Object[])new Object[]{id, new JSON.Binary((byte[])value, (int)0, (int)value.length)}){

            @Override
            public void done(Exception error, Object[] args) {
                if (error == null) {
                    if (!$assertionsDisabled && args.length != 1) {
                        throw new AssertionError();
                    }
                    error = this.toError(args[0]);
                }
                done.doneAssign(this.token, error);
            }
        }.token;
    }

    @Override
    public IToken create(String parent_id, String language, String expression, final IExpressions.DoneCreate done) {
        return new Command((IChannel)this.channel, (IService)this, (String)"create", (Object[])new Object[]{parent_id, language, expression}){

            @Override
            public void done(Exception error, Object[] args) {
                Context ctx = null;
                if (error == null) {
                    if (!$assertionsDisabled && args.length != 2) {
                        throw new AssertionError();
                    }
                    error = this.toError(args[0]);
                    if (args[1] != null) {
                        ctx = new Context((Map)args[1]);
                    }
                }
                done.doneCreate(this.token, error, ctx);
            }
        }.token;
    }

    @Override
    public IToken createInScope(Map<String, Object> scope, String expression, final IExpressions.DoneCreate done) {
        return new Command((IChannel)this.channel, (IService)this, (String)"createInScope", (Object[])new Object[]{scope, expression}){

            @Override
            public void done(Exception error, Object[] args) {
                Context ctx = null;
                if (error == null) {
                    if (!$assertionsDisabled && args.length != 2) {
                        throw new AssertionError();
                    }
                    error = this.toError(args[0]);
                    if (args[1] != null) {
                        ctx = new Context((Map)args[1]);
                    }
                }
                done.doneCreate(this.token, error, ctx);
            }
        }.token;
    }

    @Override
    public IToken dispose(String id, final IExpressions.DoneDispose done) {
        return new Command((IChannel)this.channel, (IService)this, (String)"dispose", (Object[])new Object[]{id}){

            @Override
            public void done(Exception error, Object[] args) {
                if (error == null) {
                    if (!$assertionsDisabled && args.length != 1) {
                        throw new AssertionError();
                    }
                    error = this.toError(args[0]);
                }
                done.doneDispose(this.token, error);
            }
        }.token;
    }

    @Override
    public IToken evaluate(String id, final IExpressions.DoneEvaluate done) {
        return new Command((IChannel)this.channel, (IService)this, (String)"evaluate", (Object[])new Object[]{id}){

            @Override
            public void done(Exception error, Object[] args) {
                byte[] value = null;
                Map props = null;
                if (error == null) {
                    if (!$assertionsDisabled && args.length != 3) {
                        throw new AssertionError();
                    }
                    value = JSON.toByteArray(args[0]);
                    error = this.toError(args[1]);
                    props = (Map)args[2];
                }
                done.doneEvaluate(this.token, error, new ContextValue(value, props));
            }
        }.token;
    }

    @Override
    public IToken getChildren(String parent_context_id, final IExpressions.DoneGetChildren done) {
        return new Command((IChannel)this.channel, (IService)this, (String)"getChildren", (Object[])new Object[]{parent_context_id}){

            @Override
            public void done(Exception error, Object[] args) {
                String[] lst = null;
                if (error == null) {
                    if (!$assertionsDisabled && args.length != 2) {
                        throw new AssertionError();
                    }
                    error = this.toError(args[0]);
                    lst = ExpressionsProxy.this.toStringArray(args[1]);
                }
                done.doneGetChildren(this.token, error, lst);
            }
        }.token;
    }

    @Override
    public IToken getContext(String id, final IExpressions.DoneGetContext done) {
        return new Command((IChannel)this.channel, (IService)this, (String)"getContext", (Object[])new Object[]{id}){

            @Override
            public void done(Exception error, Object[] args) {
                Context ctx = null;
                if (error == null) {
                    if (!$assertionsDisabled && args.length != 2) {
                        throw new AssertionError();
                    }
                    error = this.toError(args[0]);
                    if (args[1] != null) {
                        ctx = new Context((Map)args[1]);
                    }
                }
                done.doneGetContext(this.token, error, ctx);
            }
        }.token;
    }

    @Override
    public String getName() {
        return "Expressions";
    }

    @Override
    public void addListener(final IExpressions.ExpressionsListener listener) {
        IChannel.IEventListener l = new IChannel.IEventListener(){

            @Override
            public void event(String name, byte[] data) {
                try {
                    Object[] args = JSON.parseSequence(data);
                    if (name.equals("valueChanged")) {
                        if (!$assertionsDisabled && args.length != 1) {
                            throw new AssertionError();
                        }
                    } else {
                        throw new IOException("Expressions service: unknown event: " + name);
                    }
                    listener.valueChanged((String)args[0]);
                }
                catch (Throwable x) {
                    ExpressionsProxy.this.channel.terminate(x);
                }
            }
        };
        this.channel.addEventListener(this, l);
        this.listeners.put(listener, l);
    }

    @Override
    public void removeListener(IExpressions.ExpressionsListener listener) {
        IChannel.IEventListener l = this.listeners.remove(listener);
        if (l != null) {
            this.channel.removeEventListener(this, l);
        }
    }

    private String[] toStringArray(Object o) {
        if (o == null) {
            return null;
        }
        Collection c = (Collection)o;
        return c.toArray(new String[c.size()]);
    }

    private class Context
    implements IExpressions.Expression {
        private final Map<String, Object> props;

        Context(Map<String, Object> props) {
            this.props = props;
        }

        @Override
        public boolean canAssign() {
            Boolean n = (Boolean)this.props.get("CanAssign");
            if (n == null) {
                return false;
            }
            return n;
        }

        @Override
        public boolean hasFuncCall() {
            Boolean n = (Boolean)this.props.get("HasFuncCall");
            if (n == null) {
                return false;
            }
            return n;
        }

        @Override
        public int getBits() {
            Number n = (Number)this.props.get("Bits");
            if (n == null) {
                return 0;
            }
            return n.intValue();
        }

        @Override
        public String getExpression() {
            return (String)this.props.get("Expression");
        }

        @Override
        public String getID() {
            return (String)this.props.get("ID");
        }

        @Override
        public String getParentID() {
            return (String)this.props.get("ParentID");
        }

        @Override
        public String getSymbolID() {
            return (String)this.props.get("SymbolID");
        }

        @Override
        public String getLanguage() {
            return (String)this.props.get("Language");
        }

        @Override
        public int getSize() {
            Number n = (Number)this.props.get("Size");
            if (n == null) {
                return 0;
            }
            return n.intValue();
        }

        @Override
        public String getTypeID() {
            return (String)this.props.get("Type");
        }

        @Override
        public Map<String, Object> getProperties() {
            return this.props;
        }
    }

    private class ContextValue
    implements IExpressions.Value {
        private final byte[] value;
        private final Map<String, Object> props;

        ContextValue(byte[] value, Map<String, Object> props) {
            if (props == null) {
                props = new HashMap<String, Object>();
            }
            this.value = value;
            this.props = props;
        }

        @Override
        public Map<String, Object> getProperties() {
            return this.props;
        }

        @Override
        public String getTypeID() {
            return (String)this.props.get("Type");
        }

        @Override
        public byte[] getValue() {
            return this.value;
        }

        @Override
        public String getRegisterID() {
            return (String)this.props.get("Register");
        }

        @Override
        public String getSymbolID() {
            return (String)this.props.get("Symbol");
        }

        @Override
        public Number getAddress() {
            return (Number)this.props.get("Address");
        }

        @Override
        public ISymbols.TypeClass getTypeClass() {
            Number n = (Number)this.props.get("Class");
            if (n != null) {
                switch (n.intValue()) {
                    case 1: {
                        return ISymbols.TypeClass.cardinal;
                    }
                    case 2: {
                        return ISymbols.TypeClass.integer;
                    }
                    case 3: {
                        return ISymbols.TypeClass.real;
                    }
                    case 4: {
                        return ISymbols.TypeClass.pointer;
                    }
                    case 5: {
                        return ISymbols.TypeClass.array;
                    }
                    case 6: {
                        return ISymbols.TypeClass.composite;
                    }
                    case 7: {
                        return ISymbols.TypeClass.enumeration;
                    }
                    case 8: {
                        return ISymbols.TypeClass.function;
                    }
                }
            }
            return ISymbols.TypeClass.unknown;
        }

        @Override
        public boolean isBigEndian() {
            Boolean n = (Boolean)this.props.get("BigEndian");
            if (n == null) {
                return false;
            }
            return n;
        }
    }
}

