/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.debug.ui.launch;

import java.math.BigInteger;
import java.util.Map;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.tcf.internal.debug.ui.ImageCache;
import org.eclipse.tcf.internal.debug.ui.launch.ContextSelection;
import org.eclipse.tcf.internal.debug.ui.launch.ContextSelectionDialog;
import org.eclipse.tcf.internal.debug.ui.model.TCFModel;
import org.eclipse.tcf.protocol.JSON;

class DownloadFileDialog
extends Dialog {
    private final Image image = ImageCache.getImage("icons/download_tab.gif");
    private final String peer_id;
    private final Map<String, Object> map;
    private Text context_text;
    private Text file_text;
    private Text addr_text;
    private Text size_text;
    private Text offs_text;
    private Button file_button;
    private Button context_button;
    private Button load_syms_button;
    private Button relocate_button;
    private Button download_button;
    private Button set_pc_button;
    private Button osa_button;

    DownloadFileDialog(Shell parentShell, String peer_id, Map<String, Object> map) {
        super(parentShell);
        this.peer_id = peer_id;
        this.map = map;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("Download File");
        shell.setImage(this.image);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.updateButtons();
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.createFileFields(composite);
        this.setData();
        composite.setSize(composite.computeSize(-1, -1));
        return composite;
    }

    private void createFileFields(Composite parent) {
        Font font = parent.getFont();
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(3, false);
        composite.setFont(font);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(768));
        Label context_label = new Label(composite, 0);
        context_label.setLayoutData((Object)new GridData(32));
        context_label.setFont(font);
        context_label.setText("Context:");
        this.context_text = new Text(composite, 2052);
        GridData gd = new GridData(768);
        gd.widthHint = 400;
        this.context_text.setLayoutData((Object)gd);
        this.context_text.setFont(font);
        this.context_text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DownloadFileDialog.this.updateButtons();
            }
        });
        this.context_button = new Button(composite, 8);
        this.context_button.setText("Select...");
        this.context_button.setFont(font);
        this.context_button.setLayoutData((Object)new GridData(768));
        this.context_button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String context = DownloadFileDialog.this.context_text.getText().trim();
                ContextSelection selection = new ContextSelection();
                selection.fPeerId = DownloadFileDialog.this.peer_id;
                selection.fContextFullName = context;
                ContextSelectionDialog diag = new ContextSelectionDialog((IShellProvider)DownloadFileDialog.this, false);
                diag.setSelection(selection);
                if (diag.open() == 0) {
                    selection = diag.getSelection();
                    DownloadFileDialog.this.context_text.setText(selection.fContextFullName);
                }
            }
        });
        Label file_label = new Label(composite, 0);
        file_label.setLayoutData((Object)new GridData(32));
        file_label.setFont(font);
        file_label.setText("File:");
        this.file_text = new Text(composite, 2052);
        this.file_text.setLayoutData((Object)new GridData(768));
        this.file_text.setFont(font);
        this.file_text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DownloadFileDialog.this.updateButtons();
            }
        });
        this.file_button = new Button(composite, 8);
        this.file_button.setText("Browse...");
        this.file_button.setFont(font);
        this.file_button.setLayoutData((Object)new GridData(768));
        this.file_button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String path = DownloadFileDialog.this.file_text.getText().trim();
                if (path.length() == 0) {
                    path = ResourcesPlugin.getWorkspace().getRoot().getLocation().toOSString();
                }
                FileDialog dialog = new FileDialog(DownloadFileDialog.this.getShell(), 0);
                dialog.setFilterPath(path);
                path = dialog.open();
                if (path != null) {
                    DownloadFileDialog.this.file_text.setText(path);
                }
            }
        });
        this.load_syms_button = new Button(composite, 32);
        this.load_syms_button.setText("Load symbols");
        gd = new GridData(768);
        gd.horizontalSpan = 3;
        this.load_syms_button.setLayoutData((Object)gd);
        this.load_syms_button.setFont(font);
        this.load_syms_button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                DownloadFileDialog.this.updateButtons();
            }
        });
        this.load_syms_button.setEnabled(true);
        this.relocate_button = new Button(composite, 32);
        this.relocate_button.setText("Relocate the file");
        gd = new GridData(768);
        gd.horizontalSpan = 3;
        this.relocate_button.setLayoutData((Object)gd);
        this.relocate_button.setFont(font);
        this.relocate_button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                DownloadFileDialog.this.updateButtons();
            }
        });
        this.relocate_button.setEnabled(true);
        Composite rel_group = this.createRelocateGroup(composite);
        gd = new GridData(768);
        gd.horizontalSpan = 3;
        rel_group.setLayoutData((Object)gd);
        this.download_button = new Button(composite, 32);
        this.download_button.setText("Download the file into the context memory");
        gd = new GridData(768);
        gd.horizontalSpan = 3;
        this.download_button.setLayoutData((Object)gd);
        this.download_button.setFont(font);
        this.download_button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                DownloadFileDialog.this.updateButtons();
            }
        });
        this.download_button.setEnabled(true);
        this.set_pc_button = new Button(composite, 32);
        this.set_pc_button.setText("Set PC to program entry address");
        gd = new GridData(768);
        gd.horizontalSpan = 3;
        this.set_pc_button.setLayoutData((Object)gd);
        this.set_pc_button.setFont(font);
        this.set_pc_button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                DownloadFileDialog.this.updateButtons();
            }
        });
        this.set_pc_button.setEnabled(true);
        this.osa_button = new Button(composite, 32);
        this.osa_button.setText("Enable OS awarennes - the file is an OS kernel");
        gd = new GridData(768);
        gd.horizontalSpan = 3;
        this.osa_button.setLayoutData((Object)gd);
        this.osa_button.setFont(font);
        this.osa_button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                DownloadFileDialog.this.updateButtons();
            }
        });
        this.osa_button.setEnabled(true);
    }

    private Composite createRelocateGroup(Composite parent) {
        Font font = parent.getFont();
        Group group = new Group(parent, 0);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 0;
        layout.numColumns = 2;
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)new GridData(1808));
        group.setFont(font);
        group.setText("File location in the context memory");
        Label addr_label = new Label((Composite)group, 64);
        addr_label.setLayoutData((Object)new GridData(32));
        addr_label.setFont(font);
        addr_label.setText("Address:");
        this.addr_text = new Text((Composite)group, 2052);
        this.addr_text.setLayoutData((Object)new GridData(768));
        this.addr_text.setFont(font);
        Label size_label = new Label((Composite)group, 64);
        size_label.setLayoutData((Object)new GridData(32));
        size_label.setFont(font);
        size_label.setText("Size:");
        this.size_text = new Text((Composite)group, 2052);
        this.size_text.setLayoutData((Object)new GridData(768));
        this.size_text.setFont(font);
        Label offset_label = new Label((Composite)group, 64);
        offset_label.setLayoutData((Object)new GridData(32));
        offset_label.setFont(font);
        offset_label.setText("File offset:");
        this.offs_text = new Text((Composite)group, 2052);
        this.offs_text.setLayoutData((Object)new GridData(768));
        this.offs_text.setFont(font);
        return group;
    }

    private String toHex(Number n) {
        if (n == null) {
            return null;
        }
        BigInteger x = JSON.toBigInteger((Number)n);
        String s = x.toString(16);
        int l = 16 - s.length();
        if (l < 0) {
            l = 0;
        }
        if (l > 16) {
            l = 16;
        }
        return String.valueOf("0x0000000000000000".substring(0, 2 + l)) + s;
    }

    private void setString(Text text, String key) {
        String s = (String)this.map.get(key);
        if (s == null) {
            s = "";
        }
        text.setText(s);
    }

    private void setBoolean(Button btn, String key) {
        Boolean b = (Boolean)this.map.get(key);
        if (b == null) {
            btn.setSelection(false);
        } else {
            btn.setSelection(b.booleanValue());
        }
    }

    private void setNumber(Text text, String key) {
        Number n = (Number)this.map.get(key);
        if (n == null) {
            text.setText("");
        } else {
            text.setText(this.toHex(n));
        }
    }

    private void setData() {
        this.setString(this.context_text, "Context");
        this.setString(this.file_text, "File");
        this.setBoolean(this.load_syms_button, "LoadSymbols");
        this.setBoolean(this.relocate_button, "Relocate");
        this.setBoolean(this.download_button, "Download");
        this.setBoolean(this.set_pc_button, "SetPC");
        this.setBoolean(this.osa_button, "EnableOSA");
        this.setNumber(this.addr_text, "Addr");
        this.setNumber(this.offs_text, "Offs");
        this.setNumber(this.size_text, "Size");
        this.updateButtons();
    }

    private void getBoolean(Button btn, String key) {
        boolean b = btn.getSelection();
        if (!b) {
            this.map.remove(key);
        } else {
            this.map.put(key, Boolean.TRUE);
        }
    }

    private void getString(Text text, String key) {
        String s = text.getText().trim();
        if (s == null || s.length() == 0) {
            this.map.remove(key);
        } else {
            this.map.put(key, s);
        }
    }

    private void getNumber(Text text, String key) {
        String s = text.getText().trim();
        if (s == null || s.length() == 0) {
            this.map.remove(key);
        } else if (s.startsWith("0x")) {
            this.map.put(key, new BigInteger(s.substring(2), 16));
        } else {
            this.map.put(key, new BigInteger(s));
        }
    }

    private void getData() {
        this.getString(this.context_text, "Context");
        this.getString(this.file_text, "File");
        this.getBoolean(this.load_syms_button, "LoadSymbols");
        this.getBoolean(this.relocate_button, "Relocate");
        this.getBoolean(this.download_button, "Download");
        this.getBoolean(this.set_pc_button, "SetPC");
        this.getBoolean(this.osa_button, "EnableOSA");
        this.getNumber(this.addr_text, "Addr");
        this.getNumber(this.offs_text, "Offs");
        this.getNumber(this.size_text, "Size");
    }

    private void updateButtons() {
        Button btn = this.getButton(0);
        if (btn != null && this.context_text != null && this.file_text != null) {
            String context = this.context_text.getText().trim();
            String file = this.file_text.getText().trim();
            btn.setEnabled(context.length() > 0 && file.length() > 0);
        }
        if (this.relocate_button != null) {
            boolean reloc = this.relocate_button.getSelection();
            this.addr_text.setEnabled(reloc);
            this.size_text.setEnabled(reloc);
            this.offs_text.setEnabled(reloc);
        }
    }

    protected void okPressed() {
        try {
            this.getData();
        }
        catch (Throwable x) {
            MessageBox mb = new MessageBox(this.getShell(), 33);
            mb.setText("Invalid data");
            mb.setMessage(TCFModel.getErrorMessage(x, true));
            mb.open();
            return;
        }
        super.okPressed();
    }
}

