/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.debug.ui.model;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.IMemoryBlockManager;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IMemoryBlockExtension;
import org.eclipse.debug.core.model.IMemoryBlockRetrieval;
import org.eclipse.debug.core.model.IMemoryBlockRetrievalExtension;
import org.eclipse.debug.core.model.MemoryByte;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelDelta;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelProxy;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelProxyFactory;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ModelDelta;
import org.eclipse.debug.internal.ui.viewers.provisional.AbstractModelProxy;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.memory.IMemoryRendering;
import org.eclipse.debug.ui.memory.IMemoryRenderingContainer;
import org.eclipse.debug.ui.memory.IMemoryRenderingManager;
import org.eclipse.debug.ui.memory.IMemoryRenderingSite;
import org.eclipse.debug.ui.memory.IMemoryRenderingType;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Display;
import org.eclipse.tcf.internal.debug.model.TCFLaunch;
import org.eclipse.tcf.internal.debug.ui.Activator;
import org.eclipse.tcf.internal.debug.ui.model.TCFDebugTask;
import org.eclipse.tcf.internal.debug.ui.model.TCFModel;
import org.eclipse.tcf.internal.debug.ui.model.TCFNodeExecContext;
import org.eclipse.tcf.internal.debug.ui.model.TCFNumberFormat;
import org.eclipse.tcf.protocol.IChannel;
import org.eclipse.tcf.protocol.IToken;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.services.IExpressions;
import org.eclipse.tcf.services.IMemory;
import org.eclipse.tcf.services.ISymbols;
import org.eclipse.tcf.util.TCFDataCache;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.helpers.DefaultHandler;

class TCFMemoryBlockRetrieval
implements IMemoryBlockRetrievalExtension {
    private final TCFNodeExecContext exec_ctx;
    private final HashSet<MemoryBlock> mem_blocks = new HashSet();
    private final LinkedList<ModelProxy> model_proxies = new LinkedList();
    private static final String XML_NODE_MEMORY = "Memory";
    private static final String XML_NODE_BLOCK = "Block";
    private static final String XML_NODE_RENDERING = "Rendering";
    private static final String XML_ATTR_ID = "ID";
    private static final String XML_ATTR_VIEW = "View";
    private static final String XML_ATTR_PANE = "Pane";
    private static final String XML_ATTR_CTX = "Context";
    private static final String XML_ATTR_ADDR = "Addr";
    private static final String XML_ATTR_SIZE = "Size";
    private static final String XML_FILE_NAME = "memview.xml";
    private static final Display display = Display.getDefault();
    private static final Map<String, List<Element>> blocks_memento = new HashMap<String, List<Element>>();
    private static final Set<Runnable> pending_updates = new HashSet<Runnable>();
    static boolean memento_loaded;

    TCFMemoryBlockRetrieval(TCFNodeExecContext exec_ctx) {
        this.exec_ctx = exec_ctx;
    }

    public IMemoryBlockExtension getExtendedMemoryBlock(final String expression, Object context) throws DebugException {
        return (IMemoryBlockExtension)new TCFDebugTask<IMemoryBlockExtension>(){

            public void run() {
                if (!TCFMemoryBlockRetrieval.this.exec_ctx.getMemoryContext().validate((Runnable)((Object)this))) {
                    return;
                }
                if (TCFMemoryBlockRetrieval.this.exec_ctx.getMemoryContext().getError() != null) {
                    this.error(TCFMemoryBlockRetrieval.this.exec_ctx.getMemoryContext().getError());
                } else {
                    this.done((Object)new MemoryBlock(expression, -1L));
                }
            }
        }.getD();
    }

    public IMemoryBlock getMemoryBlock(final long address, final long length) throws DebugException {
        return (IMemoryBlock)new TCFDebugTask<IMemoryBlockExtension>(){

            public void run() {
                if (!TCFMemoryBlockRetrieval.this.exec_ctx.getMemoryContext().validate((Runnable)((Object)this))) {
                    return;
                }
                if (TCFMemoryBlockRetrieval.this.exec_ctx.getMemoryContext().getError() != null) {
                    this.error(TCFMemoryBlockRetrieval.this.exec_ctx.getMemoryContext().getError());
                } else {
                    this.done((Object)new MemoryBlock("0x" + Long.toHexString(address), length));
                }
            }
        }.getD();
    }

    public boolean supportsStorageRetrieval() {
        return true;
    }

    public String getMemoryID() {
        return this.exec_ctx.id;
    }

    void flushAllCaches() {
        for (MemoryBlock b : this.mem_blocks) {
            b.mem_data = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onMemoryChanged(boolean suspended) {
        assert (Protocol.isDispatchThread());
        if (this.mem_blocks.size() == 0) {
            return;
        }
        for (MemoryBlock b : this.mem_blocks) {
            if (suspended) {
                b.mem_prev = b.mem_last;
            }
            b.mem_data = null;
        }
        LinkedList<ModelProxy> linkedList = this.model_proxies;
        synchronized (linkedList) {
            for (ModelProxy p : this.model_proxies) {
                p.onMemoryChanged(suspended);
            }
        }
    }

    void dispose() {
        MemoryBlock[] list;
        MemoryBlock[] memoryBlockArray = list = this.mem_blocks.toArray(new MemoryBlock[this.mem_blocks.size()]);
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            MemoryBlock b = memoryBlockArray[n2];
            b.close();
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void asyncExec(TCFModel model, Runnable r) {
        Set<Runnable> set = pending_updates;
        synchronized (set) {
            Class<Device> clazz = Device.class;
            synchronized (Device.class) {
                if (display.isDisposed()) {
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    return;
                }
                display.asyncExec(r);
                // ** MonitorExit[var3_3] (shouldn't be in output)
                pending_updates.add(r);
            }
        }
    }

    private static Node cloneXML(Document document, Node node) {
        if (node instanceof Element) {
            Element x = (Element)node;
            Element y = document.createElement(x.getTagName());
            NamedNodeMap attrs = x.getAttributes();
            int l = attrs.getLength();
            int i = 0;
            while (i < l) {
                Attr a = (Attr)attrs.item(i);
                y.setAttribute(a.getName(), a.getValue());
                ++i;
            }
            Node c = x.getFirstChild();
            while (c != null) {
                Node d = TCFMemoryBlockRetrieval.cloneXML(document, c);
                if (d != null) {
                    y.appendChild(d);
                }
                c = c.getNextSibling();
            }
            return y;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void onModelCreated(TCFModel model) {
        assert (Protocol.isDispatchThread());
        if (memento_loaded) {
            return;
        }
        memento_loaded = true;
        try {
            Map<String, List<Element>> map = blocks_memento;
            synchronized (map) {
                blocks_memento.clear();
                IPath path = Activator.getDefault().getStateLocation();
                File f = path.append(XML_FILE_NAME).toFile();
                if (!f.exists()) {
                    return;
                }
                FileInputStream inp = new FileInputStream(f);
                DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                parser.setErrorHandler(new DefaultHandler());
                Element xml_memory = parser.parse(inp).getDocumentElement();
                if (xml_memory.getTagName().equals(XML_NODE_MEMORY)) {
                    Node node = xml_memory.getFirstChild();
                    while (node != null) {
                        Element xml_block;
                        String id;
                        if (node instanceof Element && ((Element)node).getTagName().equals(XML_NODE_BLOCK) && (id = (xml_block = (Element)node).getAttribute(XML_ATTR_CTX)) != null) {
                            List<Element> list = blocks_memento.get(id);
                            if (list == null) {
                                list = new ArrayList<Element>();
                                blocks_memento.put(id, list);
                            }
                            list.add(xml_block);
                        }
                        node = node.getNextSibling();
                    }
                }
                ((InputStream)inp).close();
            }
        }
        catch (Exception x) {
            Activator.log("Cannot read memory monitors memento", x);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void onMemoryNodeCreated(TCFNodeExecContext exe_ctx) {
        assert (Protocol.isDispatchThread());
        Map<String, List<Element>> map = blocks_memento;
        synchronized (map) {
            final List<Element> memento = blocks_memento.remove(exe_ctx.id);
            if (memento == null || memento.size() == 0) {
                return;
            }
            ArrayList<MemoryBlock> list = new ArrayList<MemoryBlock>();
            TCFMemoryBlockRetrieval r = exe_ctx.model.getMemoryBlockRetrieval(exe_ctx);
            for (Element xml_block : memento) {
                String expr = xml_block.getAttribute(XML_ATTR_ADDR);
                long length = Long.parseLong(xml_block.getAttribute(XML_ATTR_SIZE));
                TCFMemoryBlockRetrieval tCFMemoryBlockRetrieval = r;
                tCFMemoryBlockRetrieval.getClass();
                list.add(tCFMemoryBlockRetrieval.new MemoryBlock(expr, length));
            }
            final IMemoryBlock[] blks = list.toArray(new IMemoryBlock[list.size()]);
            TCFMemoryBlockRetrieval.asyncExec(exe_ctx.model, new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Set set = pending_updates;
                    synchronized (set) {
                        pending_updates.remove(this);
                    }
                    try {
                        int i = 0;
                        DebugPlugin.getDefault().getMemoryBlockManager().addMemoryBlocks(blks);
                        IMemoryRenderingManager rmngr = DebugUITools.getMemoryRenderingManager();
                        for (Element xml_block : memento) {
                            IMemoryBlock mb = blks[i++];
                            Node node = xml_block.getFirstChild();
                            while (node != null) {
                                if (node instanceof Element && ((Element)node).getTagName().equals(TCFMemoryBlockRetrieval.XML_NODE_RENDERING)) {
                                    Element xml_rendering = (Element)node;
                                    String view_id = xml_rendering.getAttribute(TCFMemoryBlockRetrieval.XML_ATTR_VIEW);
                                    if (view_id != null && view_id.length() == 0) {
                                        view_id = null;
                                    }
                                    IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                                    IMemoryRenderingSite part = (IMemoryRenderingSite)page.showView("org.eclipse.debug.ui.MemoryView", view_id, 3);
                                    IMemoryRenderingType rendering_type = rmngr.getRenderingType(xml_rendering.getAttribute(TCFMemoryBlockRetrieval.XML_ATTR_ID));
                                    IMemoryRendering rendering = rendering_type.createRendering();
                                    IMemoryRenderingContainer container = part.getContainer(xml_rendering.getAttribute(TCFMemoryBlockRetrieval.XML_ATTR_PANE));
                                    rendering.init(container, mb);
                                    container.addMemoryRendering(rendering);
                                }
                                node = node.getNextSibling();
                            }
                        }
                    }
                    catch (Exception x) {
                        Activator.log("Cannot restore memory monitors", x);
                    }
                }
            });
        }
    }

    static void onModelDisconnected(final TCFModel model) {
        assert (Protocol.isDispatchThread());
        TCFMemoryBlockRetrieval.asyncExec(model, new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Set set = pending_updates;
                synchronized (set) {
                    pending_updates.remove(this);
                }
                ArrayList<MemoryBlock> block_list = new ArrayList<MemoryBlock>();
                IMemoryBlockManager manager = DebugPlugin.getDefault().getMemoryBlockManager();
                try {
                    Document document = DebugPlugin.newDocument();
                    HashMap<String, ArrayList<Element>> memento = new HashMap<String, ArrayList<Element>>();
                    HashMap<MemoryBlock, Element> mb_to_xml = new HashMap<MemoryBlock, Element>();
                    Element xml_memory = document.createElement(TCFMemoryBlockRetrieval.XML_NODE_MEMORY);
                    IMemoryBlock[] iMemoryBlockArray = manager.getMemoryBlocks();
                    int n = iMemoryBlockArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IMemoryBlock mb = iMemoryBlockArray[n2];
                        if (mb instanceof MemoryBlock) {
                            MemoryBlock m = (MemoryBlock)mb;
                            TCFMemoryBlockRetrieval r = (TCFMemoryBlockRetrieval)m.getMemoryBlockRetrieval();
                            if (((TCFMemoryBlockRetrieval)r).exec_ctx.model == model) {
                                if (!$assertionsDisabled && !r.exec_ctx.isDisposed()) {
                                    throw new AssertionError();
                                }
                                if (!$assertionsDisabled && !m.disposed) {
                                    throw new AssertionError();
                                }
                                Element xml_block = document.createElement(TCFMemoryBlockRetrieval.XML_NODE_BLOCK);
                                xml_block.setAttribute(TCFMemoryBlockRetrieval.XML_ATTR_CTX, m.ctx_id);
                                xml_block.setAttribute(TCFMemoryBlockRetrieval.XML_ATTR_ADDR, m.expression);
                                xml_block.setAttribute(TCFMemoryBlockRetrieval.XML_ATTR_SIZE, Long.toString(m.length));
                                xml_memory.appendChild(xml_block);
                                mb_to_xml.put(m, xml_block);
                                ArrayList<Element> l = (ArrayList<Element>)memento.get(m.ctx_id);
                                if (l == null) {
                                    l = new ArrayList<Element>();
                                    memento.put(m.ctx_id, l);
                                }
                                l.add(xml_block);
                                block_list.add(m);
                            }
                        }
                        ++n2;
                    }
                    iMemoryBlockArray = PlatformUI.getWorkbench().getWorkbenchWindows();
                    n = iMemoryBlockArray.length;
                    n2 = 0;
                    while (n2 < n) {
                        IMemoryBlock window = iMemoryBlockArray[n2];
                        IWorkbenchPage[] iWorkbenchPageArray = window.getPages();
                        int n3 = iWorkbenchPageArray.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            IWorkbenchPage page = iWorkbenchPageArray[n4];
                            String[] pane_ids = new String[]{"org.eclipse.debug.ui.MemoryView.RenderingViewPane.1", "org.eclipse.debug.ui.MemoryView.RenderingViewPane.2"};
                            IViewReference[] iViewReferenceArray = page.getViewReferences();
                            int n5 = iViewReferenceArray.length;
                            int n6 = 0;
                            while (n6 < n5) {
                                IViewReference ref = iViewReferenceArray[n6];
                                IViewPart part = ref.getView(false);
                                if (part instanceof IMemoryRenderingSite) {
                                    IMemoryRenderingSite memory_view = (IMemoryRenderingSite)part;
                                    String[] stringArray = pane_ids;
                                    int n7 = pane_ids.length;
                                    int n8 = 0;
                                    while (n8 < n7) {
                                        IMemoryRendering[] renderings;
                                        String pane_id = stringArray[n8];
                                        IMemoryRenderingContainer container = memory_view.getContainer(pane_id);
                                        IMemoryRendering[] iMemoryRenderingArray = renderings = container.getRenderings();
                                        int n9 = renderings.length;
                                        int n10 = 0;
                                        while (n10 < n9) {
                                            IMemoryRendering rendering = iMemoryRenderingArray[n10];
                                            Element xml_block = (Element)mb_to_xml.get(rendering.getMemoryBlock());
                                            if (xml_block != null) {
                                                Element xml_rendering = document.createElement(TCFMemoryBlockRetrieval.XML_NODE_RENDERING);
                                                xml_rendering.setAttribute(TCFMemoryBlockRetrieval.XML_ATTR_ID, rendering.getRenderingId());
                                                if (ref.getSecondaryId() != null) {
                                                    xml_rendering.setAttribute(TCFMemoryBlockRetrieval.XML_ATTR_VIEW, ref.getSecondaryId());
                                                }
                                                xml_rendering.setAttribute(TCFMemoryBlockRetrieval.XML_ATTR_PANE, pane_id);
                                                xml_block.appendChild(xml_rendering);
                                            }
                                            ++n10;
                                        }
                                        ++n8;
                                    }
                                }
                                ++n6;
                            }
                            ++n4;
                        }
                        ++n2;
                    }
                    Map map = blocks_memento;
                    synchronized (map) {
                        for (String id : blocks_memento.keySet()) {
                            if (memento.containsKey(id)) continue;
                            for (Element xml_block : (List)blocks_memento.get(id)) {
                                xml_memory.appendChild(TCFMemoryBlockRetrieval.cloneXML(document, xml_block));
                            }
                        }
                        blocks_memento.clear();
                        Node node = xml_memory.getFirstChild();
                        while (node != null) {
                            Element xml_block;
                            String id;
                            if (node instanceof Element && ((Element)node).getTagName().equals(TCFMemoryBlockRetrieval.XML_NODE_BLOCK) && (id = (xml_block = (Element)node).getAttribute(TCFMemoryBlockRetrieval.XML_ATTR_CTX)) != null) {
                                ArrayList<Element> l = (ArrayList<Element>)blocks_memento.get(id);
                                if (l == null) {
                                    l = new ArrayList<Element>();
                                    blocks_memento.put(id, l);
                                }
                                l.add(xml_block);
                            }
                            node = node.getNextSibling();
                        }
                        document.appendChild(xml_memory);
                        IPath path = Activator.getDefault().getStateLocation();
                        File f = path.append(TCFMemoryBlockRetrieval.XML_FILE_NAME).toFile();
                        BufferedWriter wr = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(f), "UTF-8"));
                        wr.write(DebugPlugin.serializeDocument((Document)document));
                        wr.close();
                    }
                }
                catch (Exception x) {
                    Activator.log("Cannot save memory monitors", x);
                }
                if (block_list.size() != 0) {
                    manager.removeMemoryBlocks(block_list.toArray(new IMemoryBlock[block_list.size()]));
                }
            }
        });
    }

    static void onWorkbenchShutdown() {
        display.syncExec(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (true) {
                    Set set = pending_updates;
                    synchronized (set) {
                        if (pending_updates.size() == 0) {
                            return;
                        }
                    }
                    if (display.readAndDispatch()) continue;
                    display.sleep();
                }
            }
        });
    }

    private static class MemData {
        final BigInteger addr;
        final MemoryByte[] data;
        final byte[] bytes;

        MemData(BigInteger addr, MemoryByte[] data) {
            int i = 0;
            this.addr = addr;
            this.data = data;
            this.bytes = new byte[data.length];
            MemoryByte[] memoryByteArray = data;
            int n = data.length;
            int n2 = 0;
            while (n2 < n) {
                MemoryByte b = memoryByteArray[n2];
                this.bytes[i++] = b.getValue();
                ++n2;
            }
        }
    }

    private class MemoryBlock
    extends PlatformObject
    implements IMemoryBlockExtension,
    IModelProxyFactory {
        private final String ctx_id;
        private final String expression;
        private final long length;
        private final Set<Object> connections = new HashSet<Object>();
        private final TCFDataCache<IExpressions.Expression> remote_expression;
        private final TCFDataCache<IExpressions.Value> expression_value;
        private final TCFDataCache<ISymbols.Symbol> expression_type;
        private boolean disposed;
        private MemData mem_data;
        private MemData mem_prev;
        private MemData mem_last;

        MemoryBlock(final String expression, long length) {
            this.ctx_id = ((TCFMemoryBlockRetrieval)TCFMemoryBlockRetrieval.this).exec_ctx.id;
            this.expression = expression;
            this.length = length;
            TCFMemoryBlockRetrieval.this.mem_blocks.add(this);
            final TCFLaunch launch = ((TCFMemoryBlockRetrieval)TCFMemoryBlockRetrieval.this).exec_ctx.model.getLaunch();
            IChannel channel = launch.getChannel();
            this.remote_expression = new TCFDataCache<IExpressions.Expression>(channel){

                protected boolean startDataRetrieval() {
                    IExpressions exps = (IExpressions)launch.getService(IExpressions.class);
                    if (exps == null) {
                        this.set(null, new Exception("Expressions service not available"), null);
                        return true;
                    }
                    this.command = exps.create(MemoryBlock.this.ctx_id, null, expression, new IExpressions.DoneCreate(){

                        public void doneCreate(IToken token, Exception error, IExpressions.Expression context) {
                            if (MemoryBlock.this.disposed) {
                                IExpressions exps = (IExpressions)channel.getRemoteService(IExpressions.class);
                                exps.dispose(context.getID(), new IExpressions.DoneDispose(){

                                    public void doneDispose(IToken token, Exception error) {
                                        if (error == null) {
                                            return;
                                        }
                                        if (channel.getState() != 1) {
                                            return;
                                        }
                                        Activator.log("Error disposing remote expression evaluator", error);
                                    }
                                });
                                return;
                            }
                            this.set(token, error, context);
                        }
                    });
                    return false;
                }
            };
            this.expression_value = new TCFDataCache<IExpressions.Value>(channel){

                protected boolean startDataRetrieval() {
                    if (!MemoryBlock.this.remote_expression.validate((Runnable)((Object)this))) {
                        return false;
                    }
                    IExpressions.Expression ctx = (IExpressions.Expression)MemoryBlock.this.remote_expression.getData();
                    if (ctx == null) {
                        this.set(null, null, null);
                        return true;
                    }
                    IExpressions exps = (IExpressions)launch.getService(IExpressions.class);
                    this.command = exps.evaluate(ctx.getID(), new IExpressions.DoneEvaluate(){

                        public void doneEvaluate(IToken token, Exception error, IExpressions.Value value) {
                            this.set(token, error, value);
                        }
                    });
                    return false;
                }
            };
            this.expression_type = new TCFDataCache<ISymbols.Symbol>(channel){

                protected boolean startDataRetrieval() {
                    if (!MemoryBlock.this.expression_value.validate((Runnable)((Object)this))) {
                        return false;
                    }
                    IExpressions.Value val = (IExpressions.Value)MemoryBlock.this.expression_value.getData();
                    if (val == null) {
                        this.set(null, MemoryBlock.this.expression_value.getError(), null);
                        return true;
                    }
                    TCFDataCache<ISymbols.Symbol> type_cache = ((TCFMemoryBlockRetrieval)((MemoryBlock)MemoryBlock.this).TCFMemoryBlockRetrieval.this).exec_ctx.model.getSymbolInfoCache(val.getTypeID());
                    if (type_cache == null) {
                        this.set(null, null, null);
                        return true;
                    }
                    if (!type_cache.validate((Runnable)((Object)this))) {
                        return false;
                    }
                    this.set(null, type_cache.getError(), (ISymbols.Symbol)type_cache.getData());
                    return true;
                }
            };
        }

        private void close() {
            IChannel channel;
            assert (Protocol.isDispatchThread());
            assert (!this.disposed);
            this.disposed = true;
            this.expression_value.dispose();
            this.expression_type.dispose();
            if (this.remote_expression.isValid() && this.remote_expression.getData() != null && (channel = ((TCFMemoryBlockRetrieval)TCFMemoryBlockRetrieval.this).exec_ctx.channel).getState() == 1) {
                IExpressions exps = (IExpressions)channel.getRemoteService(IExpressions.class);
                exps.dispose(((IExpressions.Expression)this.remote_expression.getData()).getID(), new IExpressions.DoneDispose(){

                    public void doneDispose(IToken token, Exception error) {
                        if (error == null) {
                            return;
                        }
                        if (channel.getState() != 1) {
                            return;
                        }
                        Activator.log("Error disposing remote expression evaluator", error);
                    }
                });
            }
            this.remote_expression.dispose();
            TCFMemoryBlockRetrieval.this.mem_blocks.remove((Object)this);
        }

        public synchronized void connect(Object client) {
            this.connections.add(client);
        }

        public synchronized void disconnect(Object client) {
            this.connections.remove(client);
        }

        public synchronized Object[] getConnections() {
            return this.connections.toArray(new Object[this.connections.size()]);
        }

        public void dispose() throws DebugException {
            if (this.disposed) {
                return;
            }
            new TCFDebugTask<Boolean>(TCFMemoryBlockRetrieval.this.exec_ctx.getChannel()){

                public void run() {
                    if (!MemoryBlock.this.disposed) {
                        MemoryBlock.this.close();
                    }
                    this.done(Boolean.TRUE);
                }
            }.getD();
        }

        public int getAddressSize() throws DebugException {
            return (Integer)new TCFDebugTask<Integer>(TCFMemoryBlockRetrieval.this.exec_ctx.getChannel()){

                public void run() {
                    if (TCFMemoryBlockRetrieval.this.exec_ctx.isDisposed()) {
                        this.error("Context is disposed");
                    } else {
                        TCFDataCache<IMemory.MemoryContext> cache = TCFMemoryBlockRetrieval.this.exec_ctx.getMemoryContext();
                        if (!cache.validate((Runnable)((Object)this))) {
                            return;
                        }
                        if (cache.getError() != null) {
                            this.error(cache.getError());
                        } else {
                            IMemory.MemoryContext mem = (IMemory.MemoryContext)cache.getData();
                            if (mem == null) {
                                this.error("Context does not provide memory access");
                            } else {
                                this.done(mem.getAddressSize());
                            }
                        }
                    }
                }
            }.getD();
        }

        public int getAddressableSize() throws DebugException {
            return 1;
        }

        public BigInteger getBigBaseAddress() throws DebugException {
            return (BigInteger)new TCFDebugTask<BigInteger>(TCFMemoryBlockRetrieval.this.exec_ctx.getChannel()){

                public void run() {
                    if (!MemoryBlock.this.expression_value.validate()) {
                        MemoryBlock.this.expression_value.wait((Runnable)((Object)this));
                    } else if (MemoryBlock.this.expression_value.getError() != null) {
                        this.error(MemoryBlock.this.expression_value.getError());
                    } else if (MemoryBlock.this.expression_value.getData() == null) {
                        this.error("Address expression evaluation failed");
                    } else if (!MemoryBlock.this.expression_type.validate()) {
                        MemoryBlock.this.expression_type.wait((Runnable)((Object)this));
                    } else if (MemoryBlock.this.expression_type.getError() != null) {
                        this.error(MemoryBlock.this.expression_type.getError());
                    } else {
                        IExpressions.Value value = (IExpressions.Value)MemoryBlock.this.expression_value.getData();
                        byte[] data = value.getValue();
                        if (data == null || data.length == 0) {
                            this.error("Address expression value is empty (void)");
                        } else {
                            ISymbols.Symbol type = (ISymbols.Symbol)MemoryBlock.this.expression_type.getData();
                            boolean signed = type != null && type.getTypeClass() == ISymbols.TypeClass.integer;
                            this.done(TCFNumberFormat.toBigInteger(data, value.isBigEndian(), signed));
                        }
                    }
                }
            }.getD();
        }

        public MemoryByte[] getBytesFromAddress(final BigInteger address, final long units) throws DebugException {
            return (MemoryByte[])new TCFDebugTask<MemoryByte[]>(TCFMemoryBlockRetrieval.this.exec_ctx.getChannel()){
                int offs;
                {
                    super($anonymous0);
                    this.offs = 0;
                }

                public void run() {
                    if (MemoryBlock.this.mem_data != null && address.compareTo(((MemoryBlock)MemoryBlock.this).mem_data.addr) >= 0 && address.add(BigInteger.valueOf(units)).compareTo(((MemoryBlock)MemoryBlock.this).mem_data.addr.add(BigInteger.valueOf(((MemoryBlock)MemoryBlock.this).mem_data.data.length))) <= 0) {
                        this.offs = address.subtract(((MemoryBlock)MemoryBlock.this).mem_data.addr).intValue();
                        MemoryByte[] res = ((MemoryBlock)MemoryBlock.this).mem_data.data;
                        if (units < (long)((MemoryBlock)MemoryBlock.this).mem_data.data.length) {
                            res = new MemoryByte[(int)units];
                            System.arraycopy(((MemoryBlock)MemoryBlock.this).mem_data.data, this.offs, res, 0, res.length);
                        }
                        MemoryBlock.this.setHistoryFlags();
                        this.done(res);
                        return;
                    }
                    if (TCFMemoryBlockRetrieval.this.exec_ctx.isDisposed()) {
                        this.error("Context is disposed");
                        return;
                    }
                    TCFDataCache<IMemory.MemoryContext> cache = TCFMemoryBlockRetrieval.this.exec_ctx.getMemoryContext();
                    if (!cache.validate((Runnable)((Object)this))) {
                        return;
                    }
                    if (cache.getError() != null) {
                        this.error(cache.getError());
                        return;
                    }
                    final IMemory.MemoryContext mem = (IMemory.MemoryContext)cache.getData();
                    if (mem == null) {
                        this.error("Context does not provide memory access");
                        return;
                    }
                    final int size = (int)units;
                    final byte[] buf = new byte[size];
                    final MemoryByte[] res = new MemoryByte[size];
                    mem.get((Number)address, 1, buf, 0, size, 3, new IMemory.DoneMemory(){

                        public void doneMemory(IToken token, IMemory.MemoryError error) {
                            int big_endian = 0;
                            if (mem.getProperties().get("BigEndian") != null) {
                                big_endian |= 0x20;
                                if (mem.isBigEndian()) {
                                    big_endian |= 0x10;
                                }
                            }
                            int cnt = 0;
                            while (offs < size) {
                                int flags = big_endian;
                                if (error instanceof IMemory.ErrorOffset) {
                                    IMemory.ErrorOffset ofs = (IMemory.ErrorOffset)error;
                                    int status = ofs.getStatus(cnt);
                                    if (status == 0) {
                                        flags |= 3;
                                    } else if ((status & 1) != 0 && cnt > 0) {
                                        break;
                                    }
                                } else if (error == null) {
                                    flags |= 3;
                                }
                                res[offs] = new MemoryByte(buf[offs], (byte)flags);
                                ++offs;
                                ++cnt;
                            }
                            if (offs < size) {
                                mem.get((Number)address.add(BigInteger.valueOf(offs)), 1, buf, offs, size - offs, 3, (IMemory.DoneMemory)this);
                            } else {
                                MemoryBlock memoryBlock = MemoryBlock.this;
                                MemData memData = new MemData(address, res);
                                MemoryBlock.this.mem_data = memData;
                                memoryBlock.mem_last = memData;
                                MemoryBlock.this.setHistoryFlags();
                                this.done(res);
                            }
                        }
                    });
                }
            }.getD();
        }

        private void setHistoryFlags() {
            if (this.mem_data == null) {
                return;
            }
            BigInteger addr = this.mem_data.addr;
            BigInteger his_start = null;
            BigInteger his_end = null;
            if (this.mem_prev != null) {
                his_start = this.mem_prev.addr;
                his_end = this.mem_prev.addr.add(BigInteger.valueOf(this.mem_prev.data.length));
            }
            MemoryByte[] memoryByteArray = this.mem_data.data;
            int n = this.mem_data.data.length;
            int n2 = 0;
            while (n2 < n) {
                MemoryByte b = memoryByteArray[n2];
                int flags = b.getFlags();
                if (this.mem_prev != null && addr.compareTo(his_start) >= 0 && addr.compareTo(his_end) < 0) {
                    flags |= 8;
                    int offs = addr.subtract(his_start).intValue();
                    if (b.getValue() != this.mem_prev.data[offs].getValue()) {
                        flags |= 4;
                    }
                } else {
                    flags &= 0xFFFFFFF3;
                }
                b.setFlags((byte)flags);
                addr = addr.add(BigInteger.valueOf(1L));
                ++n2;
            }
        }

        public MemoryByte[] getBytesFromOffset(BigInteger offset, long units) throws DebugException {
            return this.getBytesFromAddress(this.getBigBaseAddress().add(offset), units);
        }

        public String getExpression() {
            return this.expression;
        }

        public IMemoryBlockRetrieval getMemoryBlockRetrieval() {
            return TCFMemoryBlockRetrieval.this;
        }

        public long getStartAddress() {
            return 0L;
        }

        public long getLength() {
            return this.length;
        }

        public BigInteger getMemoryBlockStartAddress() throws DebugException {
            return null;
        }

        public BigInteger getMemoryBlockEndAddress() throws DebugException {
            return null;
        }

        public BigInteger getBigLength() throws DebugException {
            return BigInteger.valueOf(this.length);
        }

        public void setBaseAddress(BigInteger address) throws DebugException {
        }

        public void setValue(BigInteger offset, final byte[] bytes) throws DebugException {
            final BigInteger address = this.getBigBaseAddress().add(offset);
            new TCFDebugTask<Object>(TCFMemoryBlockRetrieval.this.exec_ctx.getChannel()){

                public void run() {
                    if (TCFMemoryBlockRetrieval.this.exec_ctx.isDisposed()) {
                        this.error("Context is disposed");
                        return;
                    }
                    TCFDataCache<IMemory.MemoryContext> cache = TCFMemoryBlockRetrieval.this.exec_ctx.getMemoryContext();
                    if (!cache.validate((Runnable)((Object)this))) {
                        return;
                    }
                    if (cache.getError() != null) {
                        this.error(cache.getError());
                        return;
                    }
                    IMemory.MemoryContext mem = (IMemory.MemoryContext)cache.getData();
                    if (mem == null) {
                        this.error("Context does not provide memory access");
                        return;
                    }
                    mem.set((Number)address, 1, bytes, 0, bytes.length, 3, new IMemory.DoneMemory(){

                        public void doneMemory(IToken token, IMemory.MemoryError error) {
                            if (error != null) {
                                this.error((Throwable)error);
                            } else {
                                this.done(null);
                            }
                        }
                    });
                }
            }.getD();
        }

        public boolean supportBaseAddressModification() throws DebugException {
            return false;
        }

        public boolean supportsChangeManagement() {
            return true;
        }

        public byte[] getBytes() throws DebugException {
            if (this.mem_data == null) {
                return null;
            }
            return this.mem_data.bytes;
        }

        public void setValue(long offset, byte[] bytes) throws DebugException {
            this.setValue(BigInteger.valueOf(offset), bytes);
        }

        public boolean supportsValueModification() {
            return true;
        }

        public IDebugTarget getDebugTarget() {
            return null;
        }

        public ILaunch getLaunch() {
            return ((TCFMemoryBlockRetrieval)TCFMemoryBlockRetrieval.this).exec_ctx.model.getLaunch();
        }

        public String getModelIdentifier() {
            return "org.eclipse.tcf.debug";
        }

        public IModelProxy createModelProxy(Object element, IPresentationContext context) {
            assert (element == this);
            return new ModelProxy(this, context.getWindow().getShell().getDisplay());
        }

        public Object getAdapter(Class adapter) {
            if (adapter == IMemoryBlockRetrieval.class) {
                return TCFMemoryBlockRetrieval.this;
            }
            if (adapter == IMemoryBlockRetrievalExtension.class) {
                return TCFMemoryBlockRetrieval.this;
            }
            return super.getAdapter(adapter);
        }
    }

    private class ModelProxy
    extends AbstractModelProxy
    implements Runnable {
        final MemoryBlock mem_block;
        final Display display;
        ModelDelta delta;

        public ModelProxy(MemoryBlock mem_block, Display display) {
            this.mem_block = mem_block;
            this.display = display;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void installed(Viewer viewer) {
            LinkedList linkedList = TCFMemoryBlockRetrieval.this.model_proxies;
            synchronized (linkedList) {
                if (this.isDisposed()) {
                    return;
                }
                this.setInstalled(true);
                super.installed(viewer);
                TCFMemoryBlockRetrieval.this.model_proxies.add(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dispose() {
            LinkedList linkedList = TCFMemoryBlockRetrieval.this.model_proxies;
            synchronized (linkedList) {
                if (this.isDisposed()) {
                    return;
                }
                TCFMemoryBlockRetrieval.this.model_proxies.remove(this);
                super.dispose();
            }
        }

        void onMemoryChanged(boolean suspended) {
            assert (Protocol.isDispatchThread());
            int flags = 1024;
            if (suspended) {
                flags |= 0x800;
            }
            if (this.delta != null) {
                this.delta.setFlags(this.delta.getFlags() | flags);
            } else {
                this.delta = new ModelDelta((Object)this.mem_block, flags);
                Protocol.invokeLater((Runnable)this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            assert (Protocol.isDispatchThread());
            final ModelDelta d = this.delta;
            this.delta = null;
            Class<Device> clazz = Device.class;
            synchronized (Device.class) {
                if (!this.display.isDisposed()) {
                    this.display.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            ModelProxy.this.fireModelChanged((IModelDelta)d);
                        }
                    });
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
        }
    }
}

