/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.debug.ui.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.internal.ui.viewers.model.IInternalTreeModelViewer;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenCountUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelDelta;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelProxy;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ITreeModelViewer;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdateListener;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ModelDelta;
import org.eclipse.debug.internal.ui.viewers.provisional.AbstractModelProxy;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Display;
import org.eclipse.tcf.internal.debug.model.TCFLaunch;
import org.eclipse.tcf.internal.debug.ui.model.TCFModel;
import org.eclipse.tcf.internal.debug.ui.model.TCFNode;
import org.eclipse.tcf.internal.debug.ui.model.TCFNodeLaunch;
import org.eclipse.tcf.protocol.Protocol;

public class TCFModelProxy
extends AbstractModelProxy
implements IModelProxy,
Runnable,
ITreeViewerListener {
    private static final TCFNode[] EMPTY_NODE_ARRAY = new TCFNode[0];
    private static boolean is_linux = "Linux".equals(System.getProperty("os.name"));
    private final TCFModel model;
    private final TCFLaunch launch;
    private final Display display;
    private final Map<TCFNode, Integer> node2flags = new HashMap<TCFNode, Integer>();
    private final Map<TCFNode, TCFNode[]> node2children = new HashMap<TCFNode, TCFNode[]>();
    private final Map<TCFNode, ModelDelta> node2delta = new HashMap<TCFNode, ModelDelta>();
    private final Set<ModelDelta> content_deltas = new HashSet<ModelDelta>();
    private final LinkedList<TCFNode> selection = new LinkedList();
    private final Set<String> auto_expand_set = new HashSet<String>();
    private final Map<String, Boolean> expanded_nodes = Collections.synchronizedMap(new HashMap());
    private ITreeModelViewer viewer;
    private boolean posted;
    private boolean installed;
    private boolean disposed;
    private boolean realized;
    private long last_update_time;
    private boolean enable_auto_expand;
    private Set<TCFNode> auto_expand_removed_nodes;
    private Set<TCFNode> auto_expand_created_nodes;
    private final Runnable timer = new Runnable(){

        @Override
        public void run() {
            int congestion;
            TCFModelProxy.this.posted = false;
            if (TCFModelProxy.this.pending_update != null) {
                return;
            }
            long idle_time = System.currentTimeMillis() - TCFModelProxy.this.last_update_time;
            long min_idle_time = TCFModelProxy.this.model.getMinViewUpdatesInterval();
            if (TCFModelProxy.this.model.getViewUpdatesThrottleEnabled() && (congestion = Protocol.getCongestionLevel() + 50) > 0) {
                min_idle_time += (long)(congestion * 3);
            }
            if (TCFModelProxy.this.model.getChannelThrottleEnabled() && (congestion = TCFModelProxy.this.model.getChannel().getCongestion() + 50) > 0) {
                min_idle_time += (long)(congestion * 3);
            }
            if (idle_time < min_idle_time - 10L) {
                Protocol.invokeLater((long)(min_idle_time - idle_time), (Runnable)this);
                TCFModelProxy.this.posted = true;
            } else {
                TCFModelProxy.this.run();
            }
        }
    };
    private final IViewerUpdateListener update_listener = new IViewerUpdateListener(){

        public void viewerUpdatesBegin() {
            if (!TCFModelProxy.this.model.getWaitForViewsUpdateAfterStep()) {
                return;
            }
            TCFModelProxy.this.launch.addPendingClient((Object)this);
        }

        public void viewerUpdatesComplete() {
            TCFModelProxy.this.launch.removePendingClient((Object)this);
        }

        public void updateStarted(IViewerUpdate update) {
        }

        public void updateComplete(IViewerUpdate update) {
        }
    };
    private IViewerUpdate pending_update;
    private final Comparator<IModelDelta> delta_comparator = new Comparator<IModelDelta>(){

        @Override
        public int compare(IModelDelta o1, IModelDelta o2) {
            int i2;
            int f1 = o1.getFlags();
            int f2 = o2.getFlags();
            if ((f1 & 2) != 0 && (f2 & 2) == 0) {
                return -1;
            }
            if ((f1 & 2) == 0 && (f2 & 2) != 0) {
                return 1;
            }
            if ((f1 & 1) != 0 && (f2 & 1) == 0) {
                return -1;
            }
            if ((f1 & 1) == 0 && (f2 & 1) != 0) {
                return 1;
            }
            if ((f1 & 0x10) != 0 && (f2 & 0x10) == 0) {
                return -1;
            }
            if ((f1 & 0x10) == 0 && (f2 & 0x10) != 0) {
                return 1;
            }
            int i1 = o1.getIndex();
            if (i1 < (i2 = o2.getIndex())) {
                return -1;
            }
            if (i1 > i2) {
                return 1;
            }
            return 0;
        }
    };

    TCFModelProxy(TCFModel model) {
        this.model = model;
        this.launch = model.getLaunch();
        this.display = model.getDisplay();
    }

    public void initialize(ITreeModelViewer viewer) {
        if (this.isDisposed()) {
            return;
        }
        this.viewer = viewer;
        super.initialize(viewer);
        this.enable_auto_expand = "org.eclipse.debug.ui.DebugView".equals(this.getPresentationContext().getId()) && viewer instanceof IInternalTreeModelViewer;
        viewer.addViewerUpdateListener(this.update_listener);
        if (is_linux && viewer instanceof TreeViewer) {
            ((TreeViewer)viewer).addTreeListener((ITreeViewerListener)this);
        }
        Protocol.invokeAndWait((Runnable)new Runnable(){

            @Override
            public void run() {
                if (!$assertionsDisabled && TCFModelProxy.this.installed) {
                    throw new AssertionError();
                }
                if (!$assertionsDisabled && TCFModelProxy.this.disposed) {
                    throw new AssertionError();
                }
                TCFModelProxy.this.model.onProxyInstalled(TCFModelProxy.this);
                TCFModelProxy.this.installed = true;
            }
        });
    }

    public void dispose() {
        if (this.isDisposed()) {
            return;
        }
        Protocol.invokeAndWait((Runnable)new Runnable(){

            @Override
            public void run() {
                if (!$assertionsDisabled && !TCFModelProxy.this.installed) {
                    throw new AssertionError();
                }
                if (!$assertionsDisabled && TCFModelProxy.this.disposed) {
                    throw new AssertionError();
                }
                TCFModelProxy.this.model.onProxyDisposed(TCFModelProxy.this);
                TCFModelProxy.this.launch.removePendingClient((Object)TCFModelProxy.this.update_listener);
                TCFModelProxy.this.launch.removePendingClient((Object)TCFModelProxy.this);
                TCFModelProxy.this.disposed = true;
            }
        });
        this.viewer.removeViewerUpdateListener(this.update_listener);
        if (is_linux && this.viewer instanceof TreeViewer) {
            ((TreeViewer)this.viewer).removeTreeListener((ITreeViewerListener)this);
        }
        super.dispose();
    }

    public void addDelta(TCFNode node, int flags) {
        assert (Protocol.isDispatchThread());
        assert (this.installed && !this.disposed);
        if (flags == 0) {
            return;
        }
        Integer delta = this.node2flags.get(node);
        if (delta != null) {
            flags |= delta.intValue();
        }
        this.node2flags.put(node, flags);
        this.post();
    }

    public void expand(TCFNode node) {
        Object input = this.getInput();
        IPresentationContext ctx = this.getPresentationContext();
        while (node != null && node != input) {
            this.addDelta(node, 0x100000);
            node = node.getParent(ctx);
        }
        this.post();
    }

    void saveExpandState(TCFNode node) {
        if (!this.enable_auto_expand) {
            return;
        }
        if (this.auto_expand_removed_nodes == null) {
            this.auto_expand_removed_nodes = new HashSet<TCFNode>();
        }
        this.auto_expand_removed_nodes.add(node);
    }

    public void setSelection(TCFNode node) {
        if (this.selection.size() > 0 && this.selection.getLast() == node) {
            return;
        }
        this.selection.add(node);
        this.expand(node.getParent(this.getPresentationContext()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean getAutoExpandNode(TCFNode node, boolean user_request) {
        String id = node.id;
        node.getParent();
        Boolean expand = null;
        Map<String, Boolean> map = this.expanded_nodes;
        synchronized (map) {
            expand = this.expanded_nodes.get(id);
            if (expand == null) {
                if (user_request) {
                    expand = Boolean.FALSE;
                } else {
                    expand = Boolean.TRUE;
                    while (node != null) {
                        this.expanded_nodes.put(node.getID(), is_linux);
                        node = node.getParent();
                    }
                }
            }
        }
        return expand;
    }

    void clearAutoExpandStack(String id) {
        if (id != null) {
            this.expanded_nodes.remove(id);
        }
    }

    Object getInput() {
        return this.viewer.getInput();
    }

    public void post() {
        assert (Protocol.isDispatchThread());
        assert (this.installed && !this.disposed);
        if (!this.posted && this.pending_update == null) {
            long idle_time = System.currentTimeMillis() - this.last_update_time;
            Protocol.invokeLater((long)(this.model.getMinViewUpdatesInterval() - idle_time), (Runnable)this.timer);
            if (this.model.getWaitForViewsUpdateAfterStep()) {
                this.launch.addPendingClient((Object)this);
            }
            this.posted = true;
        }
    }

    private TCFNode[] getNodeChildren(TCFNode node) {
        TCFNode[] res = this.node2children.get(node);
        if (res == null) {
            res = EMPTY_NODE_ARRAY;
            if (!node.isDisposed()) {
                ChildrenCountUpdate children_count_update = new ChildrenCountUpdate(node);
                node.update(children_count_update);
                if (!children_count_update.done) {
                    this.pending_update = children_count_update;
                } else {
                    ChildrenUpdate children_update = new ChildrenUpdate(node);
                    children_update.setLength(children_count_update.count);
                    node.update(children_update);
                    if (!children_update.done) {
                        this.pending_update = children_update;
                    } else {
                        res = children_update.children;
                    }
                }
            }
            this.node2children.put(node, res);
        }
        return res;
    }

    private int getNodeIndex(TCFNode node, TCFNode parent) {
        TCFNode[] arr = this.getNodeChildren(parent);
        int i = 0;
        while (i < arr.length) {
            if (arr[i] == node) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private ModelDelta makeDelta(ModelDelta root, TCFNode node, TCFNode selection) {
        int flags;
        ModelDelta delta = this.node2delta.get(node);
        if (delta == null) {
            if (node == root.getElement()) {
                delta = root;
            } else {
                flags = 0;
                Integer flags_obj = this.node2flags.get(node);
                if (flags_obj != null) {
                    flags = flags_obj;
                }
                if ((flags & 2) != 0 && (flags & 0x11) != 0) {
                    return null;
                }
                if (node == selection) {
                    flags |= 0x200800;
                    if (this.selection.size() <= 1) {
                        flags |= 0x1000000;
                    }
                }
                if (this.auto_expand_set.contains(node.id) && this.getNodeChildren(node).length > 0) {
                    if (this.auto_expand_created_nodes == null) {
                        this.auto_expand_created_nodes = new HashSet<TCFNode>();
                    }
                    this.auto_expand_created_nodes.add(node);
                }
                if (node.parent == null) {
                    if (root.getElement() instanceof TCFNode) {
                        return null;
                    }
                    int children = -1;
                    if (selection != null && selection != node || (flags & 0x100000) != 0) {
                        children = this.getNodeChildren(node).length;
                    }
                    delta = root.addNode((Object)this.launch, -1, flags, children);
                } else {
                    TCFNode parent = node.getParent(this.getPresentationContext());
                    if (parent == null) {
                        return null;
                    }
                    ModelDelta up = this.makeDelta(root, parent, selection);
                    if (up == null) {
                        return null;
                    }
                    boolean content = this.content_deltas.contains(up);
                    if (content) {
                        assert (selection == null);
                        if ((flags &= 0xFFFFF3E4) == 0) {
                            return null;
                        }
                    }
                    int index = -1;
                    int children = -1;
                    if ((flags & 1) != 0) {
                        index = this.getNodeIndex(node, parent);
                        if (index < 0) {
                            return null;
                        }
                        int up_children = up.getChildCount();
                        if (up_children < 0) {
                            up_children = this.getNodeChildren(parent).length;
                            up.setChildCount(up_children);
                        }
                        if (index != up_children - 1) {
                            if (!content) {
                                up.setFlags(up.getFlags() | 0x400);
                                this.content_deltas.add(up);
                                content = true;
                            }
                            if ((flags &= 0xFFFFF3E4) == 0) {
                                return null;
                            }
                        }
                    } else if ((selection != null || (flags & 0x10) != 0 || (flags & 0x100000) != 0) && (index = this.getNodeIndex(node, parent)) < 0) {
                        return null;
                    }
                    if (selection != null && selection != node || (flags & 0x100000) != 0) {
                        children = this.getNodeChildren(node).length;
                    }
                    delta = up.addNode((Object)node, index, flags, children);
                    if (content) {
                        this.content_deltas.add(delta);
                    }
                }
                this.node2delta.put(node, delta);
            }
        }
        if (((flags = delta.getFlags()) & 2) != 0) {
            return null;
        }
        return delta;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void asyncExec(Runnable r) {
        Class<Device> clazz = Device.class;
        synchronized (Device.class) {
            if (!this.display.isDisposed()) {
                this.display.asyncExec(r);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    private void sortDeltaChildren(IModelDelta delta) {
        IModelDelta[] arr = delta.getChildDeltas();
        Arrays.sort(arr, this.delta_comparator);
        IModelDelta[] iModelDeltaArray = arr;
        int n = arr.length;
        int n2 = 0;
        while (n2 < n) {
            IModelDelta d = iModelDeltaArray[n2];
            this.sortDeltaChildren(d);
            ++n2;
        }
    }

    private void postDelta(final ModelDelta root) {
        assert (this.pending_update == null);
        if (root.getFlags() != 0 || root.getChildDeltas().length > 0) {
            this.last_update_time = System.currentTimeMillis();
            final Set<TCFNode> save_expand_state = this.auto_expand_removed_nodes;
            this.auto_expand_removed_nodes = null;
            this.asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (save_expand_state != null && save_expand_state.size() > 0 && TCFModelProxy.this.viewer instanceof IInternalTreeModelViewer) {
                        final HashSet<String> expanded = new HashSet<String>();
                        for (TCFNode node : save_expand_state) {
                            if (!TCFModelProxy.this.getExpandedState(node) && !Boolean.TRUE.equals(TCFModelProxy.this.expanded_nodes.get(node.getID()))) continue;
                            expanded.add(node.id);
                        }
                        if (expanded.size() > 0) {
                            Protocol.invokeLater((Runnable)new Runnable(){

                                @Override
                                public void run() {
                                    TCFModelProxy.this.auto_expand_set.addAll(expanded);
                                }
                            });
                        }
                    }
                    TCFModelProxy.this.sortDeltaChildren((IModelDelta)root);
                    TCFModelProxy.this.fireModelChanged((IModelDelta)root);
                }
            });
        }
    }

    private boolean getExpandedState(TCFNode node) {
        IInternalTreeModelViewer tree_viewer = (IInternalTreeModelViewer)this.viewer;
        TCFNode element = node;
        if (node instanceof TCFNodeLaunch) {
            element = node.getModel().getLaunch();
        }
        return tree_viewer.getExpandedState((Object)element);
    }

    private void postDelta() {
        TCFNode node3;
        Integer i;
        assert (Protocol.isDispatchThread());
        if (this.disposed) {
            return;
        }
        if (this.node2flags.isEmpty() && this.selection.isEmpty()) {
            return;
        }
        if (!this.realized) {
            if (this.getPresentationContext().getId().equals("org.eclipse.debug.ui.DebugView")) {
                this.asyncExec(new Runnable(){
                    boolean found;

                    @Override
                    public void run() {
                        if (TCFModelProxy.this.viewer instanceof IInternalTreeModelViewer) {
                            this.found = ((IInternalTreeModelViewer)TCFModelProxy.this.viewer).findElementIndex(TreePath.EMPTY, (Object)TCFModelProxy.this.launch) >= 0;
                        }
                        Protocol.invokeLater((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                if (TCFModelProxy.this.disposed) {
                                    return;
                                }
                                if (found) {
                                    TCFModelProxy.this.realized = true;
                                } else {
                                    TCFModelProxy.this.last_update_time = System.currentTimeMillis() + 20L;
                                }
                                TCFModelProxy.this.post();
                            }
                        });
                    }
                });
                return;
            }
            this.realized = true;
        }
        Object input = this.getInput();
        int flags = 0;
        if (input instanceof TCFNode && (i = this.node2flags.get(node3 = (TCFNode)input)) != null && ((flags = i.intValue()) & 0x800) != 0) {
            if ((flags &= 0xFFFFF7FF) == 0) {
                this.node2flags.remove(node3);
                if (this.node2flags.isEmpty() && this.selection.isEmpty()) {
                    return;
                }
            } else {
                this.node2flags.put(node3, flags);
            }
        }
        this.node2delta.clear();
        this.content_deltas.clear();
        if (flags != 0 || this.node2flags.size() > 0) {
            ModelDelta root = new ModelDelta(input, flags);
            if ((flags & 0x400) != 0) {
                this.content_deltas.add(root);
            }
            for (TCFNode node2 : this.node2flags.keySet()) {
                this.makeDelta(root, node2, null);
            }
            this.node2delta.clear();
            this.content_deltas.clear();
            if (this.pending_update == null) {
                this.node2flags.clear();
                this.postDelta(root);
            }
        }
        if (this.pending_update == null) {
            while (!this.selection.isEmpty()) {
                node3 = this.selection.getFirst();
                if (!node3.isDisposed()) {
                    ModelDelta root = new ModelDelta(input, 0);
                    this.makeDelta(root, node3, node3);
                    this.node2delta.clear();
                    this.content_deltas.clear();
                    if (this.pending_update != null) break;
                    this.postDelta(root);
                }
                this.selection.remove(node3);
            }
        }
        if (this.pending_update == null && this.auto_expand_created_nodes != null) {
            for (TCFNode node3 : this.auto_expand_created_nodes) {
                this.auto_expand_set.remove(node3.id);
                this.addDelta(node3, 0x100000);
            }
            this.auto_expand_created_nodes = null;
        }
    }

    @Override
    public void run() {
        this.pending_update = null;
        this.node2children.clear();
        this.postDelta();
        this.node2children.clear();
        if (!this.posted && this.pending_update == null) {
            this.launch.removePendingClient((Object)this);
        }
    }

    public void treeCollapsed(TreeExpansionEvent event) {
        this.updateExpandStack(event, false);
    }

    public void treeExpanded(TreeExpansionEvent event) {
        this.updateExpandStack(event, true);
    }

    private void updateExpandStack(TreeExpansionEvent event, boolean expand) {
        Object element = event.getElement();
        TCFNode node = null;
        if (element instanceof TCFNode) {
            node = (TCFNode)element;
        }
        if (element instanceof TCFLaunch) {
            node = this.model.getRootNode();
        }
        if (node != null && this.model == node.getModel()) {
            this.expanded_nodes.put(node.id, expand);
        }
    }

    private class ChildrenCountUpdate
    extends ViewerUpdate
    implements IChildrenCountUpdate {
        int count;

        ChildrenCountUpdate(TCFNode node) {
            this.node = node;
        }

        public void setChildCount(int count) {
            this.count = count;
        }
    }

    private class ChildrenUpdate
    extends ViewerUpdate
    implements IChildrenUpdate {
        int length;
        TCFNode[] children;

        ChildrenUpdate(TCFNode node) {
            this.node = node;
        }

        void setLength(int length) {
            this.length = length;
            this.children = length == 0 ? EMPTY_NODE_ARRAY : new TCFNode[length];
        }

        public int getLength() {
            return this.length;
        }

        public int getOffset() {
            return 0;
        }

        public void setChild(Object child, int offset) {
            this.children[offset] = (TCFNode)child;
        }
    }

    private class ViewerUpdate
    implements IViewerUpdate {
        TCFNode node;
        IStatus status;
        boolean canceled;
        boolean done;

        private ViewerUpdate() {
        }

        public Object getElement() {
            return this.node;
        }

        public TreePath getElementPath() {
            return null;
        }

        public IPresentationContext getPresentationContext() {
            return TCFModelProxy.this.getPresentationContext();
        }

        public Object getViewerInput() {
            return TCFModelProxy.this.getInput();
        }

        public void cancel() {
            this.canceled = true;
        }

        public void done() {
            assert (!this.done);
            this.done = true;
            if (this == TCFModelProxy.this.pending_update) {
                Protocol.invokeLater((Runnable)TCFModelProxy.this);
            }
        }

        public IStatus getStatus() {
            return this.status;
        }

        public boolean isCanceled() {
            return this.canceled;
        }

        public void setStatus(IStatus status) {
            this.status = status;
        }
    }
}

