/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.debug.ui.model;

import java.math.BigInteger;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IExpressionManager;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IExpression;
import org.eclipse.debug.core.model.IWatchExpression;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenCountUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementEditor;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IHasChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ILabelUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.tcf.debug.ui.ITCFExpression;
import org.eclipse.tcf.debug.ui.ITCFPrettyExpressionProvider;
import org.eclipse.tcf.internal.debug.model.TCFContextState;
import org.eclipse.tcf.internal.debug.ui.Activator;
import org.eclipse.tcf.internal.debug.ui.ColorCache;
import org.eclipse.tcf.internal.debug.ui.ImageCache;
import org.eclipse.tcf.internal.debug.ui.model.ICastToType;
import org.eclipse.tcf.internal.debug.ui.model.IDetailsProvider;
import org.eclipse.tcf.internal.debug.ui.model.IWatchInExpressions;
import org.eclipse.tcf.internal.debug.ui.model.StyledStringBuffer;
import org.eclipse.tcf.internal.debug.ui.model.TCFChildrenStackTrace;
import org.eclipse.tcf.internal.debug.ui.model.TCFChildrenSubExpressions;
import org.eclipse.tcf.internal.debug.ui.model.TCFModel;
import org.eclipse.tcf.internal.debug.ui.model.TCFModelFonts;
import org.eclipse.tcf.internal.debug.ui.model.TCFModelProxy;
import org.eclipse.tcf.internal.debug.ui.model.TCFNode;
import org.eclipse.tcf.internal.debug.ui.model.TCFNodeArrayPartition;
import org.eclipse.tcf.internal.debug.ui.model.TCFNodeExecContext;
import org.eclipse.tcf.internal.debug.ui.model.TCFNodeRegister;
import org.eclipse.tcf.internal.debug.ui.model.TCFNodeStackFrame;
import org.eclipse.tcf.internal.debug.ui.model.TCFNumberFormat;
import org.eclipse.tcf.internal.debug.ui.model.TCFPrettyExpressionProvider;
import org.eclipse.tcf.protocol.IToken;
import org.eclipse.tcf.protocol.JSON;
import org.eclipse.tcf.services.IExpressions;
import org.eclipse.tcf.services.IMemory;
import org.eclipse.tcf.services.IRegisters;
import org.eclipse.tcf.services.ISymbols;
import org.eclipse.tcf.util.TCFDataCache;
import org.eclipse.tcf.util.TCFTask;

public class TCFNodeExpression
extends TCFNode
implements IElementEditor,
ICastToType,
IWatchInExpressions,
IDetailsProvider,
ITCFExpression {
    private final String script;
    private final int index;
    private final boolean deref;
    private final String field_id;
    private final String reg_id;
    private final TCFNode.TCFData<String> base_text;
    private final TCFNode.TCFData<IExpressions.Expression> var_expression;
    private final TCFNode.TCFData<IExpressions.Expression> rem_expression;
    private final TCFNode.TCFData<IExpressions.Value> value;
    private final TCFNode.TCFData<ISymbols.Symbol> type;
    private final TCFNode.TCFData<String> type_name;
    private final TCFNode.TCFData<StyledStringBuffer> string;
    private final TCFNode.TCFData<String> expression_text;
    private final TCFChildrenSubExpressions children;
    private final boolean is_empty;
    private int sort_pos;
    private boolean enabled = true;
    private IExpressions.Value prev_value;
    private IExpressions.Value next_value;
    private byte[] parent_value;
    private String remote_expression_id;
    private IExpression platform_expression;
    private static int expr_cnt;
    private final Runnable post_delta = new Runnable(){

        @Override
        public void run() {
            TCFNodeExpression.this.postAllChangedDelta();
        }
    };
    private static final ICellModifier cell_modifier;

    static {
        cell_modifier = new ICellModifier(){

            public boolean canModify(Object element, final String property) {
                final TCFNodeExpression node = (TCFNodeExpression)element;
                return (Boolean)new TCFTask<Boolean>(node.channel){

                    public void run() {
                        if ("Name".equals(property)) {
                            this.done(node.is_empty || node.script != null);
                            return;
                        }
                        if (!node.is_empty && node.enabled) {
                            if (!node.rem_expression.validate((Runnable)((Object)this))) {
                                return;
                            }
                            IExpressions.Expression exp = (IExpressions.Expression)node.rem_expression.getData();
                            if (exp != null && exp.canAssign()) {
                                if (!node.value.validate((Runnable)((Object)this))) {
                                    return;
                                }
                                if (!node.type.validate((Runnable)((Object)this))) {
                                    return;
                                }
                                if ("HexValue".equals(property)) {
                                    this.done(TCFNumberFormat.isValidHexNumber(node.toNumberString(16)) == null);
                                    return;
                                }
                                if ("DecValue".equals(property)) {
                                    this.done(TCFNumberFormat.isValidDecNumber(true, node.toNumberString(10)) == null);
                                    return;
                                }
                                if ("Value".equals(property)) {
                                    StyledStringBuffer bf = node.getPrettyExpression((Runnable)((Object)this));
                                    if (bf == null) {
                                        return;
                                    }
                                    String s = bf.toString();
                                    this.done(s.startsWith("0x") || TCFNumberFormat.isValidDecNumber(true, s) == null);
                                    return;
                                }
                            }
                        }
                        this.done(Boolean.FALSE);
                    }
                }.getE();
            }

            public Object getValue(Object element, final String property) {
                final TCFNodeExpression node = (TCFNodeExpression)element;
                return new TCFTask<String>(){

                    public void run() {
                        if (node.is_empty) {
                            this.done("");
                            return;
                        }
                        if ("Name".equals(property)) {
                            this.done(node.script);
                            return;
                        }
                        if (!node.value.validate((Runnable)((Object)this))) {
                            return;
                        }
                        if (node.value.getData() != null) {
                            if ("HexValue".equals(property)) {
                                this.done(node.toNumberString(16));
                                return;
                            }
                            if ("DecValue".equals(property)) {
                                this.done(node.toNumberString(10));
                                return;
                            }
                            if ("Value".equals(property)) {
                                StyledStringBuffer bf = node.getPrettyExpression((Runnable)((Object)this));
                                if (bf == null) {
                                    return;
                                }
                                this.done(bf.toString());
                                return;
                            }
                        }
                        this.done(null);
                    }
                }.getE();
            }

            public void modify(Object element, final String property, final Object value) {
                if (value == null) {
                    return;
                }
                final TCFNodeExpression node = (TCFNodeExpression)element;
                new TCFTask<Boolean>(){

                    public void run() {
                        try {
                            if ("Name".equals(property)) {
                                if (node.is_empty) {
                                    String s;
                                    if (value instanceof String && (s = ((String)value).trim()).length() > 0) {
                                        node.model.getDisplay().asyncExec(new Runnable(){

                                            @Override
                                            public void run() {
                                                IWatchExpression expression = DebugPlugin.getDefault().getExpressionManager().newWatchExpression(s);
                                                DebugPlugin.getDefault().getExpressionManager().addExpression((IExpression)expression);
                                                IAdaptable object = DebugUITools.getDebugContext();
                                                IDebugElement context = null;
                                                if (object instanceof IDebugElement) {
                                                    context = (IDebugElement)object;
                                                } else if (object instanceof ILaunch) {
                                                    context = ((ILaunch)object).getDebugTarget();
                                                }
                                                expression.setExpressionContext(context);
                                            }
                                        });
                                    }
                                } else if (!node.script.equals(value)) {
                                    IExpression e;
                                    IExpressionManager m = DebugPlugin.getDefault().getExpressionManager();
                                    IExpression[] iExpressionArray = m.getExpressions();
                                    int n = iExpressionArray.length;
                                    int n2 = 0;
                                    while (n2 < n) {
                                        e = iExpressionArray[n2];
                                        if (node.script.equals(e.getExpressionText())) {
                                            m.removeExpression(e);
                                        }
                                        ++n2;
                                    }
                                    e = m.newWatchExpression((String)value);
                                    m.addExpression(e);
                                }
                                this.done(Boolean.TRUE);
                                return;
                            }
                            if (!node.rem_expression.validate((Runnable)((Object)this))) {
                                return;
                            }
                            IExpressions.Expression exp = (IExpressions.Expression)node.rem_expression.getData();
                            if (exp != null && exp.canAssign()) {
                                byte[] bf = null;
                                int size = exp.getSize();
                                boolean is_float = false;
                                boolean big_endian = false;
                                boolean signed = false;
                                if (!node.value.validate((Runnable)((Object)this))) {
                                    return;
                                }
                                IExpressions.Value eval = (IExpressions.Value)node.value.getData();
                                if (eval != null) {
                                    switch (eval.getTypeClass()) {
                                        case real: {
                                            is_float = true;
                                            signed = true;
                                            break;
                                        }
                                        case integer: {
                                            signed = true;
                                        }
                                    }
                                    big_endian = eval.isBigEndian();
                                    size = eval.getValue().length;
                                }
                                String input = (String)value;
                                String error = null;
                                if ("HexValue".equals(property)) {
                                    if (input.startsWith("0x")) {
                                        input = input.substring(2);
                                    }
                                    if ((error = TCFNumberFormat.isValidHexNumber(input)) == null) {
                                        bf = TCFNumberFormat.toByteArray(input, 16, false, size, signed, big_endian);
                                    }
                                } else if ("DecValue".equals(property)) {
                                    error = TCFNumberFormat.isValidDecNumber(is_float, input);
                                    if (error == null) {
                                        bf = TCFNumberFormat.toByteArray(input, 10, is_float, size, signed, big_endian);
                                    }
                                } else if ("Value".equals(property)) {
                                    if (input.startsWith("0x")) {
                                        String s = input.substring(2);
                                        error = TCFNumberFormat.isValidHexNumber(s);
                                        if (error == null) {
                                            bf = TCFNumberFormat.toByteArray(s, 16, false, size, signed, big_endian);
                                        }
                                    } else {
                                        error = TCFNumberFormat.isValidDecNumber(is_float, input);
                                        if (error == null) {
                                            bf = TCFNumberFormat.toByteArray(input, 10, is_float, size, signed, big_endian);
                                        }
                                    }
                                }
                                if (error != null) {
                                    throw new Exception("Invalid value: " + value, new Exception(error));
                                }
                                if (bf != null) {
                                    IExpressions exps = (IExpressions)node.launch.getService(IExpressions.class);
                                    exps.assign(exp.getID(), bf, new IExpressions.DoneAssign(){

                                        public void doneAssign(IToken token, Exception error) {
                                            node.getRootExpression().onValueChanged();
                                            if (error != null) {
                                                node.model.showMessageBox("Cannot modify element value", error);
                                                this.done(Boolean.FALSE);
                                            } else {
                                                this.done(Boolean.TRUE);
                                            }
                                        }
                                    });
                                    return;
                                }
                            }
                            this.done(Boolean.FALSE);
                        }
                        catch (Throwable x) {
                            node.model.showMessageBox("Cannot modify element value", x);
                            this.done(Boolean.FALSE);
                        }
                    }
                }.getE();
            }
        };
    }

    TCFNodeExpression(final TCFNode parent, final String script, final String field_id, final String var_id, final String reg_id, final int index, final boolean deref) {
        super(parent, var_id != null ? var_id : "Expr" + expr_cnt++);
        this.script = script;
        this.field_id = field_id;
        this.reg_id = reg_id;
        this.index = index;
        this.deref = deref;
        this.is_empty = script == null && var_id == null && field_id == null && reg_id == null && index < 0;
        this.var_expression = new TCFNode.TCFData<IExpressions.Expression>((TCFNode)this, this.channel){

            protected boolean startDataRetrieval() {
                IExpressions exps = (IExpressions)TCFNodeExpression.this.launch.getService(IExpressions.class);
                if (exps == null || var_id == null) {
                    this.set(null, null, null);
                    return true;
                }
                this.command = exps.getContext(var_id, new IExpressions.DoneGetContext(){

                    public void doneGetContext(IToken token, Exception error, IExpressions.Expression context) {
                        this.set(token, error, context);
                    }
                });
                return false;
            }
        };
        this.base_text = new TCFNode.TCFData<String>((TCFNode)this, this.channel){

            protected boolean startDataRetrieval() {
                TCFNodeExpression.this.parent_value = null;
                if (TCFNodeExpression.this.is_empty) {
                    this.set(null, null, null);
                    return true;
                }
                if (script != null) {
                    this.set(null, null, script);
                    return true;
                }
                if (var_id != null) {
                    if (!TCFNodeExpression.this.var_expression.validate((Runnable)((Object)this))) {
                        return false;
                    }
                    Throwable err = null;
                    String exp = null;
                    if (TCFNodeExpression.this.var_expression.getData() == null) {
                        err = TCFNodeExpression.this.var_expression.getError();
                    } else {
                        exp = ((IExpressions.Expression)TCFNodeExpression.this.var_expression.getData()).getExpression();
                        if (exp == null) {
                            err = new Exception("Missing 'Expression' property");
                        }
                    }
                    this.set(null, err, exp);
                    return true;
                }
                if (reg_id != null) {
                    this.set(null, null, "${" + reg_id + "}");
                    return true;
                }
                String e = null;
                TCFNode n = parent;
                while (n instanceof TCFNodeArrayPartition) {
                    n = n.parent;
                }
                String cast = TCFNodeExpression.this.model.getCastToType(n.id);
                if (cast == null && deref) {
                    TCFNodeExpression exp = (TCFNodeExpression)n;
                    if (!exp.value.validate((Runnable)((Object)this))) {
                        return false;
                    }
                    IExpressions.Value v = (IExpressions.Value)exp.value.getData();
                    if (v != null && v.getTypeID() != null) {
                        TCFNodeExpression.this.parent_value = v.getValue();
                        if (TCFNodeExpression.this.parent_value != null) {
                            e = "(${" + v.getTypeID() + "})0x" + TCFNumberFormat.toBigInteger(TCFNodeExpression.this.parent_value, v.isBigEndian(), false).toString(16);
                        }
                    }
                }
                if (e == null) {
                    TCFNode.TCFData t = ((TCFNodeExpression)n).base_text;
                    if (!t.validate((Runnable)((Object)this))) {
                        return false;
                    }
                    e = (String)t.getData();
                    if (e == null) {
                        this.set(null, t.getError(), null);
                        return true;
                    }
                }
                if (cast != null) {
                    e = "(" + cast + ")(" + e + ")";
                }
                if (field_id != null) {
                    e = "(" + e + ")" + (deref ? "->" : ".") + "${" + field_id + "}";
                } else if (index == 0) {
                    e = "*(" + e + ")";
                } else if (index > 0) {
                    e = "(" + e + ")[" + index + "]";
                }
                this.set(null, null, e);
                return true;
            }
        };
        this.expression_text = new TCFNode.TCFData<String>((TCFNode)this, this.channel){

            protected boolean startDataRetrieval() {
                String cast;
                String expr_text = null;
                if (script != null) {
                    expr_text = script;
                } else if (var_id != null) {
                    TCFDataCache<ISymbols.Symbol> var;
                    if (!TCFNodeExpression.this.var_expression.validate((Runnable)((Object)this))) {
                        return false;
                    }
                    IExpressions.Expression e = (IExpressions.Expression)TCFNodeExpression.this.var_expression.getData();
                    if (e != null && (var = TCFNodeExpression.this.model.getSymbolInfoCache(e.getSymbolID())) != null) {
                        if (!var.validate((Runnable)((Object)this))) {
                            return false;
                        }
                        if (var.getData() != null) {
                            expr_text = ((ISymbols.Symbol)var.getData()).getName();
                        }
                    }
                } else if (reg_id != null) {
                    if (!TCFNodeExpression.this.model.createNode(reg_id, (Runnable)((Object)this))) {
                        return false;
                    }
                    if (this.isValid()) {
                        return true;
                    }
                    TCFNodeRegister reg_node = (TCFNodeRegister)TCFNodeExpression.this.model.getNode(reg_id);
                    while (true) {
                        TCFDataCache<IRegisters.RegistersContext> ctx_cache;
                        if (!(ctx_cache = reg_node.getContext()).validate((Runnable)((Object)this))) {
                            return false;
                        }
                        IRegisters.RegistersContext ctx_data = (IRegisters.RegistersContext)ctx_cache.getData();
                        if (ctx_data == null) {
                            this.set(null, ctx_cache.getError(), null);
                            return true;
                        }
                        String string = expr_text = expr_text == null ? ctx_data.getName() : String.valueOf(ctx_data.getName()) + "." + expr_text;
                        if (!(reg_node.parent instanceof TCFNodeRegister)) break;
                        reg_node = (TCFNodeRegister)reg_node.parent;
                    }
                    expr_text = "$" + expr_text;
                } else {
                    ISymbols.Symbol field_data;
                    TCFNode.TCFData pending = null;
                    TCFNode.TCFData field = TCFNodeExpression.this.model.getSymbolInfoCache(field_id);
                    if (field != null && !field.validate()) {
                        pending = field;
                    }
                    if (!TCFNodeExpression.this.base_text.validate()) {
                        pending = TCFNodeExpression.this.base_text;
                    }
                    if (pending != null) {
                        pending.wait((Runnable)((Object)this));
                        return false;
                    }
                    String parent_text = "";
                    TCFNode n = parent;
                    while (n instanceof TCFNodeArrayPartition) {
                        n = n.parent;
                    }
                    TCFNode.TCFData parent_text_cache = ((TCFNodeExpression)n).expression_text;
                    if (!parent_text_cache.validate((Runnable)((Object)this))) {
                        return false;
                    }
                    if (parent_text_cache.getData() != null && !(parent_text = (String)parent_text_cache.getData()).matches("\\w*")) {
                        parent_text = String.valueOf('(') + parent_text + ')';
                    }
                    if (index >= 0) {
                        expr_text = index == 0 && deref ? "*" + parent_text : String.valueOf(parent_text) + "[" + index + "]";
                    }
                    if (expr_text == null && field != null && (field_data = (ISymbols.Symbol)field.getData()) != null) {
                        TCFDataCache<ISymbols.Symbol> type;
                        if (field_data.getName() != null) {
                            expr_text = String.valueOf(parent_text) + (deref ? "->" : ".") + field_data.getName();
                        } else if (field_data.getFlag(0x2000000) && (type = TCFNodeExpression.this.model.getSymbolInfoCache(field_data.getTypeID())) != null) {
                            if (!type.validate((Runnable)((Object)this))) {
                                return false;
                            }
                            ISymbols.Symbol type_data = (ISymbols.Symbol)type.getData();
                            if (type_data != null) {
                                String type_name = type_data.getName();
                                expr_text = "*(" + type_name + "*)" + (deref ? "" : "&") + parent_text;
                            }
                        }
                    }
                    if (expr_text == null && TCFNodeExpression.this.base_text.getData() != null) {
                        expr_text = (String)TCFNodeExpression.this.base_text.getData();
                    }
                }
                if (expr_text != null && (cast = TCFNodeExpression.this.model.getCastToType(TCFNodeExpression.this.id)) != null) {
                    expr_text = "(" + cast + ")(" + expr_text + ")";
                }
                this.set(null, null, expr_text);
                return true;
            }
        };
        this.rem_expression = new TCFNode.TCFData<IExpressions.Expression>((TCFNode)this, this.channel){

            protected boolean startDataRetrieval() {
                TCFNode n;
                IExpressions exps = (IExpressions)TCFNodeExpression.this.launch.getService(IExpressions.class);
                if (exps == null) {
                    this.set(null, null, null);
                    return true;
                }
                String cast = TCFNodeExpression.this.model.getCastToType(TCFNodeExpression.this.id);
                if (var_id != null && cast == null) {
                    if (!TCFNodeExpression.this.var_expression.validate((Runnable)((Object)this))) {
                        return false;
                    }
                    this.set(null, TCFNodeExpression.this.var_expression.getError(), (IExpressions.Expression)TCFNodeExpression.this.var_expression.getData());
                    return true;
                }
                if (!TCFNodeExpression.this.base_text.validate((Runnable)((Object)this))) {
                    return false;
                }
                String e = (String)TCFNodeExpression.this.base_text.getData();
                if (e == null) {
                    this.set(null, TCFNodeExpression.this.base_text.getError(), null);
                    return true;
                }
                if (cast != null) {
                    e = "(" + cast + ")(" + e + ")";
                }
                if ((n = ((TCFNodeExpression)TCFNodeExpression.this).getRootExpression().parent) instanceof TCFNodeStackFrame && ((TCFNodeStackFrame)n).isEmulated()) {
                    n = n.parent;
                }
                this.command = exps.create(n.id, null, e, new IExpressions.DoneCreate(){

                    public void doneCreate(IToken token, Exception error, IExpressions.Expression context) {
                        TCFNodeExpression.this.disposeRemoteExpression();
                        if (context != null) {
                            TCFNodeExpression.this.remote_expression_id = context.getID();
                        }
                        if (!this.isDisposed()) {
                            this.set(token, error, context);
                        } else {
                            TCFNodeExpression.this.disposeRemoteExpression();
                        }
                    }
                });
                return false;
            }
        };
        this.value = new TCFNode.TCFData<IExpressions.Value>((TCFNode)this, this.channel){

            protected boolean startDataRetrieval() {
                Boolean b = TCFNodeExpression.this.usePrevValue((Runnable)((Object)this));
                if (b == null) {
                    return false;
                }
                if (b.booleanValue()) {
                    this.set(null, null, TCFNodeExpression.this.prev_value);
                    return true;
                }
                if (!TCFNodeExpression.this.rem_expression.validate((Runnable)((Object)this))) {
                    return false;
                }
                IExpressions.Expression exp = (IExpressions.Expression)TCFNodeExpression.this.rem_expression.getData();
                if (exp == null) {
                    this.set(null, TCFNodeExpression.this.rem_expression.getError(), null);
                    return true;
                }
                final 7 cache = this;
                IExpressions exps = (IExpressions)TCFNodeExpression.this.launch.getService(IExpressions.class);
                this.command = exps.evaluate(exp.getID(), new IExpressions.DoneEvaluate(){

                    public void doneEvaluate(IToken token, Exception error, IExpressions.Value value) {
                        if (command != token) {
                            return;
                        }
                        command = null;
                        if (error != null) {
                            Boolean b = TCFNodeExpression.this.usePrevValue((Runnable)cache);
                            if (b == null) {
                                return;
                            }
                            if (b.booleanValue()) {
                                this.set(null, null, TCFNodeExpression.this.prev_value);
                                return;
                            }
                        }
                        this.set(null, error, value);
                    }
                });
                return false;
            }
        };
        this.type = new TCFNode.TCFData<ISymbols.Symbol>((TCFNode)this, this.channel){

            protected boolean startDataRetrieval() {
                TCFDataCache<ISymbols.Symbol> sym_cache;
                String type_id = null;
                if (TCFNodeExpression.this.model.getCastToType(TCFNodeExpression.this.id) == null && field_id != null && (sym_cache = TCFNodeExpression.this.model.getSymbolInfoCache(field_id)) != null) {
                    if (!sym_cache.validate((Runnable)((Object)this))) {
                        return false;
                    }
                    ISymbols.Symbol sym_data = (ISymbols.Symbol)sym_cache.getData();
                    if (sym_data != null) {
                        type_id = sym_data.getTypeID();
                    }
                }
                if (type_id == null) {
                    if (!TCFNodeExpression.this.value.validate((Runnable)((Object)this))) {
                        return false;
                    }
                    IExpressions.Value val = (IExpressions.Value)TCFNodeExpression.this.value.getData();
                    if (val != null) {
                        type_id = val.getTypeID();
                    }
                }
                if (type_id == null) {
                    if (!TCFNodeExpression.this.rem_expression.validate((Runnable)((Object)this))) {
                        return false;
                    }
                    IExpressions.Expression exp = (IExpressions.Expression)TCFNodeExpression.this.rem_expression.getData();
                    if (exp != null) {
                        type_id = exp.getTypeID();
                    }
                }
                if (type_id == null) {
                    this.set(null, TCFNodeExpression.this.value.getError(), null);
                    return true;
                }
                TCFDataCache<ISymbols.Symbol> type_cache = TCFNodeExpression.this.model.getSymbolInfoCache(type_id);
                if (type_cache == null) {
                    this.set(null, null, null);
                    return true;
                }
                if (!type_cache.validate((Runnable)((Object)this))) {
                    return false;
                }
                this.set(null, type_cache.getError(), (ISymbols.Symbol)type_cache.getData());
                return true;
            }
        };
        this.string = new TCFNode.TCFData<StyledStringBuffer>((TCFNode)this, this.channel){
            ISymbols.Symbol base_type_data;
            BigInteger addr;
            byte[] buf;
            int size;
            int offs;

            protected boolean startDataRetrieval() {
                if (this.addr != null) {
                    return this.continueMemRead();
                }
                if (!TCFNodeExpression.this.value.validate((Runnable)((Object)this))) {
                    return false;
                }
                if (!TCFNodeExpression.this.type.validate((Runnable)((Object)this))) {
                    return false;
                }
                IExpressions.Value value_data = (IExpressions.Value)TCFNodeExpression.this.value.getData();
                ISymbols.Symbol type_data = (ISymbols.Symbol)TCFNodeExpression.this.type.getData();
                if (value_data != null && value_data.getValue() != null && type_data != null) {
                    block0 : switch (type_data.getTypeClass()) {
                        case pointer: 
                        case array: {
                            TCFDataCache<ISymbols.Symbol> base_type_cache = TCFNodeExpression.this.model.getSymbolInfoCache(type_data.getBaseTypeID());
                            if (base_type_cache == null) break;
                            if (!base_type_cache.validate((Runnable)((Object)this))) {
                                return false;
                            }
                            this.base_type_data = (ISymbols.Symbol)base_type_cache.getData();
                            if (this.base_type_data == null) break;
                            this.size = this.base_type_data.getSize();
                            if (this.size == 0) break;
                            switch (this.base_type_data.getTypeClass()) {
                                case cardinal: 
                                case integer: {
                                    if (this.base_type_data.getSize() != 1) break block0;
                                    if (type_data.getTypeClass() == ISymbols.TypeClass.array) {
                                        byte[] data = value_data.getValue();
                                        StyledStringBuffer bf = new StyledStringBuffer();
                                        bf.append(TCFNodeExpression.this.toASCIIString(data, 0, data.length, '\"'), 4);
                                        this.set(null, null, bf);
                                        return true;
                                    }
                                    this.size = 0;
                                    return this.startMemRead(value_data);
                                }
                                case composite: {
                                    if (type_data.getTypeClass() == ISymbols.TypeClass.array) break block0;
                                    return this.startMemRead(value_data);
                                }
                            }
                            break;
                        }
                        case cardinal: 
                        case integer: {
                            if (type_data.getSize() != 1) break;
                            byte[] data = value_data.getValue();
                            StyledStringBuffer bf = new StyledStringBuffer();
                            bf.append(TCFNodeExpression.this.toASCIIString(data, 0, data.length, '\''), 4);
                            this.set(null, null, bf);
                            return true;
                        }
                        case enumeration: {
                            TCFDataCache<String[]> type_children_cache = TCFNodeExpression.this.model.getSymbolChildrenCache(type_data.getID());
                            if (!type_children_cache.validate((Runnable)((Object)this))) {
                                return false;
                            }
                            String[] type_children_data = (String[])type_children_cache.getData();
                            if (type_children_data == null) break;
                            String[] stringArray = type_children_data;
                            int n = type_children_data.length;
                            int n2 = 0;
                            while (n2 < n) {
                                byte[] const_bytes;
                                String const_id = stringArray[n2];
                                TCFDataCache<ISymbols.Symbol> const_cache = TCFNodeExpression.this.model.getSymbolInfoCache(const_id);
                                if (!const_cache.validate((Runnable)((Object)this))) {
                                    return false;
                                }
                                ISymbols.Symbol const_data = (ISymbols.Symbol)const_cache.getData();
                                if (const_data != null && const_data.getName() != null && (const_bytes = const_data.getValue()) != null) {
                                    boolean ok = true;
                                    byte[] data = value_data.getValue();
                                    int i = 0;
                                    while (ok && i < data.length) {
                                        ok = i < const_bytes.length ? const_bytes[i] == data[i] : data[i] == 0;
                                        ++i;
                                    }
                                    if (ok && const_data.getName() != null) {
                                        StyledStringBuffer bf = new StyledStringBuffer();
                                        bf.append(const_data.getName());
                                        this.set(null, null, bf);
                                        return true;
                                    }
                                }
                                ++n2;
                            }
                            break;
                        }
                    }
                }
                this.set(null, null, null);
                return true;
            }

            public void reset() {
                super.reset();
                this.addr = null;
            }

            private boolean startMemRead(IExpressions.Value value_data) {
                byte[] data = value_data.getValue();
                BigInteger a = TCFNumberFormat.toBigInteger(data, value_data.isBigEndian(), false);
                if (!a.equals(BigInteger.valueOf(0L))) {
                    this.addr = a;
                    this.offs = 0;
                    return this.continueMemRead();
                }
                this.set(null, null, null);
                return true;
            }

            private boolean continueMemRead() {
                TCFDataCache<TCFNodeExecContext> mem_node_cache = TCFNodeExpression.this.model.searchMemoryContext(parent);
                if (mem_node_cache == null) {
                    this.set(null, new Exception("Context does not provide memory access"), null);
                    return true;
                }
                if (!mem_node_cache.validate((Runnable)((Object)this))) {
                    return false;
                }
                if (mem_node_cache.getError() != null) {
                    this.set(null, mem_node_cache.getError(), null);
                    return true;
                }
                TCFNodeExecContext mem_node = (TCFNodeExecContext)mem_node_cache.getData();
                if (mem_node == null) {
                    this.set(null, new Exception("Context does not provide memory access"), null);
                    return true;
                }
                TCFDataCache<IMemory.MemoryContext> mem_ctx_cache = mem_node.getMemoryContext();
                if (!mem_ctx_cache.validate((Runnable)((Object)this))) {
                    return false;
                }
                if (mem_ctx_cache.getError() != null) {
                    this.set(null, mem_ctx_cache.getError(), null);
                    return true;
                }
                IMemory.MemoryContext mem_space_data = (IMemory.MemoryContext)mem_ctx_cache.getData();
                if (mem_space_data == null) {
                    this.set(null, new Exception("Context does not provide memory access"), null);
                    return true;
                }
                if (this.size == 0) {
                    BigInteger get_addr = this.addr.add(BigInteger.valueOf(this.offs));
                    final int get_size = 16 - (get_addr.intValue() & 0xF);
                    if (this.buf == null) {
                        this.buf = new byte[256];
                    }
                    if (this.offs + get_size > this.buf.length) {
                        byte[] tmp = new byte[this.buf.length * 2];
                        System.arraycopy(this.buf, 0, tmp, 0, this.buf.length);
                        this.buf = tmp;
                    }
                    this.command = mem_space_data.get((Number)get_addr, 1, this.buf, this.offs, get_size, 0, new IMemory.DoneMemory(){

                        public void doneMemory(IToken token, IMemory.MemoryError error) {
                            if (command != token) {
                                return;
                            }
                            IMemory.ErrorOffset err_offs = null;
                            if (error instanceof IMemory.ErrorOffset) {
                                err_offs = (IMemory.ErrorOffset)error;
                            }
                            int i = 0;
                            while (i < get_size) {
                                IMemory.MemoryError byte_error = null;
                                if (error != null && (err_offs == null || err_offs.getStatus(i) != 0)) {
                                    byte_error = error;
                                    if (offs == 0) {
                                        this.set(command, (Throwable)byte_error, null);
                                        return;
                                    }
                                }
                                if (buf[offs] == 0 || offs >= 2048 || byte_error != null) {
                                    StyledStringBuffer bf = new StyledStringBuffer();
                                    bf.append(TCFNodeExpression.this.toASCIIString(buf, 0, offs, '\"'), 4);
                                    this.set(command, null, bf);
                                    return;
                                }
                                ++offs;
                                ++i;
                            }
                            command = null;
                            this.run();
                        }
                    });
                    return false;
                }
                if (this.offs == 0) {
                    this.buf = new byte[this.size];
                    this.command = mem_space_data.get((Number)this.addr, 1, this.buf, 0, this.size, 0, new IMemory.DoneMemory(){

                        public void doneMemory(IToken token, IMemory.MemoryError error) {
                            if (error != null) {
                                this.set(command, (Throwable)error, null);
                            } else if (command == token) {
                                command = null;
                                ++offs;
                                this.run();
                            }
                        }
                    });
                    return false;
                }
                StyledStringBuffer bf = new StyledStringBuffer();
                bf.append('{');
                if (!TCFNodeExpression.this.appendCompositeValueText(bf, 1, this.base_type_data, TCFNodeExpression.this, true, this.buf, 0, this.size, this.base_type_data.isBigEndian(), (Runnable)((Object)this))) {
                    return false;
                }
                bf.append('}');
                this.set(null, null, bf);
                return true;
            }
        };
        this.type_name = new TCFNode.TCFData<String>((TCFNode)this, this.channel){

            protected boolean startDataRetrieval() {
                StringBuffer bf;
                if (!TCFNodeExpression.this.type.validate((Runnable)((Object)this))) {
                    return false;
                }
                if (TCFNodeExpression.this.type.getData() == null) {
                    String s;
                    if (!TCFNodeExpression.this.value.validate((Runnable)((Object)this))) {
                        return false;
                    }
                    IExpressions.Value val = (IExpressions.Value)TCFNodeExpression.this.value.getData();
                    if (val != null && val.getValue() != null && (s = TCFNodeExpression.this.getTypeName(val.getTypeClass(), val.getValue().length)) != null) {
                        this.set(null, null, s);
                        return true;
                    }
                }
                if (!TCFNodeExpression.this.getTypeName(bf = new StringBuffer(), (TCFDataCache<ISymbols.Symbol>)TCFNodeExpression.this.type, TCFNodeExpression.this.model.isShowQualifiedTypeNamesEnabled(), (Runnable)((Object)this))) {
                    return false;
                }
                this.set(null, null, bf.toString());
                return true;
            }
        };
        this.children = new TCFChildrenSubExpressions(this, 0, 0, 0);
    }

    void onPreferencesChanged() {
        this.type_name.reset();
        this.postAllChangedDelta();
    }

    private void disposeRemoteExpression() {
        if (this.remote_expression_id != null && this.channel.getState() == 1) {
            IExpressions exps = (IExpressions)this.channel.getRemoteService(IExpressions.class);
            exps.dispose(this.remote_expression_id, new IExpressions.DoneDispose(){

                public void doneDispose(IToken token, Exception error) {
                    if (error == null) {
                        return;
                    }
                    if (TCFNodeExpression.this.channel.getState() != 1) {
                        return;
                    }
                    Activator.log("Error disposing remote expression evaluator", error);
                }
            });
            this.remote_expression_id = null;
        }
    }

    @Override
    public void dispose() {
        for (ITCFPrettyExpressionProvider p : TCFPrettyExpressionProvider.getProviders()) {
            p.dispose(this);
        }
        this.disposeRemoteExpression();
        super.dispose();
    }

    private TCFNodeExpression getRootExpression() {
        TCFNode n = this;
        while (n.parent instanceof TCFNodeExpression || n.parent instanceof TCFNodeArrayPartition) {
            n = n.parent;
        }
        return n;
    }

    private void postAllChangedDelta() {
        TCFNodeExpression n = this.getRootExpression();
        for (TCFModelProxy p : this.model.getModelProxies()) {
            String id = p.getPresentationContext().getId();
            if (!("org.eclipse.debug.ui.ExpressionView".equals(id) && n.script != null || "org.eclipse.tcf.debug.ui.expression_hover".equals(id) && n.script != null) && (!"org.eclipse.debug.ui.VariableView".equals(id) || n.script != null)) continue;
            p.addDelta(this, 3072);
        }
    }

    private void resetBaseText() {
        if (this.parent_value != null && this.base_text.isValid()) {
            this.base_text.reset();
            this.rem_expression.cancel();
            for (ITCFPrettyExpressionProvider p : TCFPrettyExpressionProvider.getProviders()) {
                p.cancel(this);
            }
            this.string.cancel();
            this.value.cancel();
        }
    }

    void onSuspended(boolean func_call) {
        if (!func_call) {
            this.prev_value = this.next_value;
            this.type.reset();
            this.type_name.reset();
        }
        if (this.rem_expression.isValid() && this.rem_expression.getError() != null) {
            this.rem_expression.reset();
        }
        if (!func_call || this.value.isValid() && this.value.getError() != null) {
            this.value.reset();
        }
        if (!func_call || this.string.isValid() && this.string.getError() != null) {
            this.string.reset();
        }
        for (ITCFPrettyExpressionProvider p : TCFPrettyExpressionProvider.getProviders()) {
            p.cancel(this);
        }
        this.children.onSuspended(func_call);
        if (!func_call) {
            this.resetBaseText();
        }
    }

    void onRegisterValueChanged() {
        this.value.reset();
        this.type.reset();
        this.type_name.reset();
        this.string.reset();
        for (ITCFPrettyExpressionProvider p : TCFPrettyExpressionProvider.getProviders()) {
            p.cancel(this);
        }
        this.children.onRegisterValueChanged();
        this.resetBaseText();
        this.postAllChangedDelta();
    }

    void onMemoryChanged() {
        this.value.reset();
        this.type.reset();
        this.type_name.reset();
        this.string.reset();
        for (ITCFPrettyExpressionProvider p : TCFPrettyExpressionProvider.getProviders()) {
            p.cancel(this);
        }
        this.children.onMemoryChanged();
        this.resetBaseText();
        if (this.parent instanceof TCFNodeExpression) {
            return;
        }
        if (this.parent instanceof TCFNodeArrayPartition) {
            return;
        }
        this.postAllChangedDelta();
    }

    void onMemoryMapChanged() {
        this.value.reset();
        this.type.reset();
        this.type_name.reset();
        this.string.reset();
        for (ITCFPrettyExpressionProvider p : TCFPrettyExpressionProvider.getProviders()) {
            p.cancel(this);
        }
        this.children.onMemoryMapChanged();
        this.resetBaseText();
        if (this.parent instanceof TCFNodeExpression) {
            return;
        }
        if (this.parent instanceof TCFNodeArrayPartition) {
            return;
        }
        this.postAllChangedDelta();
    }

    void onValueChanged() {
        this.value.reset();
        this.type.reset();
        this.type_name.reset();
        this.string.reset();
        for (ITCFPrettyExpressionProvider p : TCFPrettyExpressionProvider.getProviders()) {
            p.cancel(this);
        }
        this.children.onValueChanged();
        this.resetBaseText();
        this.postAllChangedDelta();
    }

    @Override
    public void onCastToTypeChanged() {
        this.rem_expression.cancel();
        this.value.cancel();
        this.type.cancel();
        this.type_name.cancel();
        this.string.cancel();
        for (ITCFPrettyExpressionProvider p : TCFPrettyExpressionProvider.getProviders()) {
            p.cancel(this);
        }
        this.expression_text.cancel();
        this.children.onCastToTypeChanged();
        this.resetBaseText();
        this.postAllChangedDelta();
    }

    public boolean isEmpty() {
        return this.is_empty;
    }

    public String getScript() {
        return this.script;
    }

    public IExpression getPlatformExpression() {
        return this.platform_expression;
    }

    void setPlatformExpression(IExpression expression) {
        this.platform_expression = expression;
    }

    String getFieldID() {
        return this.field_id;
    }

    String getRegisterID() {
        return this.reg_id;
    }

    int getIndex() {
        return this.index;
    }

    boolean isDeref() {
        return this.deref;
    }

    void setSortPosition(int sort_pos) {
        this.sort_pos = sort_pos;
    }

    void setEnabled(boolean enabled) {
        if (this.enabled == enabled) {
            return;
        }
        this.enabled = enabled;
        this.postAllChangedDelta();
    }

    public TCFDataCache<IExpressions.Expression> getVariable() {
        return this.var_expression;
    }

    @Override
    public TCFDataCache<IExpressions.Expression> getExpression() {
        return this.rem_expression;
    }

    @Override
    public TCFDataCache<IExpressions.Value> getValue() {
        return this.value;
    }

    @Override
    public TCFDataCache<ISymbols.Symbol> getType() {
        return this.type;
    }

    @Override
    public TCFDataCache<String> getExpressionText() {
        return this.expression_text;
    }

    private Boolean usePrevValue(Runnable done) {
        if (this.prev_value == null) {
            return false;
        }
        if (this.parent instanceof TCFNodeStackFrame) {
            TCFNodeExecContext exe = (TCFNodeExecContext)this.parent.parent;
            TCFDataCache<TCFContextState> state_cache = exe.getState();
            if (!state_cache.validate(done)) {
                return null;
            }
            TCFContextState state = (TCFContextState)state_cache.getData();
            if (state == null || !state.is_suspended) {
                return true;
            }
            TCFChildrenStackTrace stack_trace_cache = exe.getStackTrace();
            if (!stack_trace_cache.validate(done)) {
                return null;
            }
            if (((Map)stack_trace_cache.getData()).get(this.parent.id) == null) {
                return true;
            }
        } else if (this.parent instanceof TCFNodeExecContext) {
            TCFNodeExecContext exe = (TCFNodeExecContext)this.parent;
            TCFDataCache<TCFContextState> state_cache = exe.getState();
            if (!state_cache.validate(done)) {
                return null;
            }
            TCFContextState state = (TCFContextState)state_cache.getData();
            if (state == null || !state.is_suspended) {
                return true;
            }
        }
        return false;
    }

    @Override
    void flushAllCaches() {
        this.prev_value = null;
        super.flushAllCaches();
    }

    private String getTypeName(ISymbols.TypeClass type_class, int size) {
        switch (type_class) {
            case integer: {
                if (size == 0) {
                    return "<Void>";
                }
                return "<Integer-" + size * 8 + ">";
            }
            case cardinal: {
                if (size == 0) {
                    return "<Void>";
                }
                return "<Unsigned-" + size * 8 + ">";
            }
            case real: {
                if (size == 0) {
                    return null;
                }
                return "<Float-" + size * 8 + ">";
            }
        }
        return null;
    }

    private boolean getTypeName(StringBuffer bf, TCFDataCache<ISymbols.Symbol> type_cache, boolean qualified, Runnable done) {
        String name;
        block44: {
            ISymbols.Symbol type_symbol;
            name = null;
            do {
                String s = null;
                boolean get_base_type = false;
                if (!type_cache.validate(done)) {
                    return false;
                }
                type_symbol = (ISymbols.Symbol)type_cache.getData();
                if (type_symbol != null) {
                    TCFDataCache<ISymbols.Symbol> base_type_cache;
                    int flags = type_symbol.getFlags();
                    s = type_symbol.getName();
                    if (s != null) {
                        if (qualified && (flags & 0xC00180) != 0) {
                            String prefix = this.getQualifiedTypeNamePrefix(type_symbol, done);
                            if (prefix == null) {
                                return false;
                            }
                            s = String.valueOf(prefix) + s;
                        }
                        if ((flags & 0x80) != 0) {
                            s = "union " + s;
                        } else if ((flags & 0x100) != 0) {
                            s = "class " + s;
                        } else if ((flags & 0x200) != 0) {
                            s = "interface " + s;
                        } else if ((flags & 0x800000) != 0) {
                            s = "struct " + s;
                        } else if ((flags & 0x400000) != 0) {
                            s = "enum " + s;
                        }
                    } else if (!type_symbol.getID().equals(type_symbol.getTypeID()) && (base_type_cache = this.model.getSymbolInfoCache(type_symbol.getTypeID())) != null) {
                        StringBuffer sb = new StringBuffer();
                        if (!this.getTypeName(sb, base_type_cache, qualified, done)) {
                            return false;
                        }
                        s = sb.toString();
                    }
                    if (s == null) {
                        s = this.getTypeName(type_symbol.getTypeClass(), type_symbol.getSize());
                    }
                    if (s == null) {
                        switch (type_symbol.getTypeClass()) {
                            case pointer: {
                                s = "*";
                                if ((flags & 0x800) != 0) {
                                    s = "&";
                                }
                                get_base_type = true;
                                break;
                            }
                            case member_pointer: {
                                String id = type_symbol.getContainerID();
                                if (id != null) {
                                    String cls_name;
                                    TCFDataCache<ISymbols.Symbol> cls_cache = this.model.getSymbolInfoCache(id);
                                    if (!cls_cache.validate(done)) {
                                        return false;
                                    }
                                    ISymbols.Symbol cls_data = (ISymbols.Symbol)cls_cache.getData();
                                    if (cls_data != null && (cls_name = cls_data.getName()) != null) {
                                        s = String.valueOf(cls_name) + "::*";
                                        if (qualified) {
                                            String prefix = this.getQualifiedTypeNamePrefix(cls_data, done);
                                            if (prefix == null) {
                                                return false;
                                            }
                                            s = String.valueOf(prefix) + s;
                                        }
                                    }
                                }
                                if (s == null) {
                                    s = "::*";
                                }
                                get_base_type = true;
                                break;
                            }
                            case array: {
                                s = "[" + type_symbol.getLength() + "]";
                                get_base_type = true;
                                break;
                            }
                            case composite: {
                                s = "<Structure>";
                                break;
                            }
                            case function: {
                                TCFDataCache<String[]> children_cache = this.model.getSymbolChildrenCache(type_symbol.getID());
                                if (!children_cache.validate(done)) {
                                    return false;
                                }
                                String[] children = (String[])children_cache.getData();
                                if (children != null) {
                                    StringBuffer args = new StringBuffer();
                                    if (name != null) {
                                        args.append('(');
                                        args.append(name);
                                        args.append(')');
                                        name = null;
                                    }
                                    args.append('(');
                                    String[] stringArray = children;
                                    int n = children.length;
                                    int n2 = 0;
                                    while (n2 < n) {
                                        String id = stringArray[n2];
                                        if (id != children[0]) {
                                            args.append(',');
                                        }
                                        if (!this.getTypeName(args, this.model.getSymbolInfoCache(id), qualified, done)) {
                                            return false;
                                        }
                                        ++n2;
                                    }
                                    args.append(')');
                                    s = args.toString();
                                    get_base_type = true;
                                    break;
                                }
                                s = "<Function>";
                            }
                        }
                    }
                    if (s != null) {
                        if ((flags & 0x20) != 0) {
                            s = "volatile " + s;
                        }
                        if ((flags & 4) != 0) {
                            s = "const " + s;
                        }
                    }
                }
                if (s == null) {
                    name = "N/A";
                    break block44;
                }
                name = name == null ? s : (!get_base_type ? String.valueOf(s) + " " + name : String.valueOf(s) + name);
                if (!get_base_type) break block44;
                if (name.length() <= 4096) continue;
                name = "<Unknown>";
                break block44;
            } while ((type_cache = this.model.getSymbolInfoCache(type_symbol.getBaseTypeID())) != null);
            name = "<Unknown> " + name;
        }
        bf.append(name);
        return true;
    }

    private String getQualifiedTypeNamePrefix(ISymbols.Symbol type_symbol, Runnable done) {
        String prefix = "";
        String containerId = type_symbol.getContainerID();
        while (containerId != null) {
            String ns_name;
            TCFDataCache<ISymbols.Symbol> ns_cache = this.model.getSymbolInfoCache(containerId);
            if (!ns_cache.validate(done)) {
                return null;
            }
            containerId = null;
            ISymbols.Symbol ns_data = (ISymbols.Symbol)ns_cache.getData();
            if ((ns_data == null || ns_data.getSymbolClass() != ISymbols.SymbolClass.namespace) && ns_data.getSymbolClass() != ISymbols.SymbolClass.type || (ns_name = ns_data.getName()) == null) continue;
            prefix = String.valueOf(ns_name) + "::" + prefix;
            containerId = ns_data.getContainerID();
        }
        return prefix;
    }

    private String toASCIIString(byte[] data, int offs, int size, char quote_char) {
        StringBuffer bf = new StringBuffer();
        bf.append(quote_char);
        int i = 0;
        while (i < size) {
            int ch = data[offs + i] & 0xFF;
            if (ch >= 32 && ch < 127) {
                bf.append((char)ch);
            } else {
                switch (ch) {
                    case 13: {
                        bf.append("\\r");
                        break;
                    }
                    case 10: {
                        bf.append("\\n");
                        break;
                    }
                    case 8: {
                        bf.append("\\b");
                        break;
                    }
                    case 9: {
                        bf.append("\\t");
                        break;
                    }
                    case 12: {
                        bf.append("\\f");
                        break;
                    }
                    default: {
                        bf.append('\\');
                        bf.append((char)(48 + ch / 64));
                        bf.append((char)(48 + ch / 8 % 8));
                        bf.append((char)(48 + ch % 8));
                    }
                }
            }
            ++i;
        }
        if (data.length <= offs + size || data[offs + size] == 0) {
            bf.append(quote_char);
        } else {
            bf.append("...");
        }
        return bf.toString();
    }

    private String toNumberString(int radix, ISymbols.TypeClass t, byte[] data, int offs, int size, boolean big_endian) {
        if (size <= 0 || size > 16) {
            return "";
        }
        if (radix != 16) {
            switch (t) {
                case array: 
                case composite: {
                    return "";
                }
            }
        }
        if (data == null) {
            return "N/A";
        }
        if (radix == 2) {
            StringBuffer bf = new StringBuffer();
            int i = size * 8;
            while (i > 0) {
                if (i % 4 == 0 && bf.length() > 0) {
                    bf.append(',');
                }
                int j = --i / 8;
                if (big_endian) {
                    j = size - j - 1;
                }
                if ((data[offs + j] & 1 << i % 8) != 0) {
                    bf.append('1');
                    continue;
                }
                bf.append('0');
            }
            return bf.toString();
        }
        if (radix == 10) {
            switch (t) {
                case integer: {
                    return TCFNumberFormat.toBigInteger(data, offs, size, big_endian, true).toString();
                }
                case real: {
                    return TCFNumberFormat.toFPString(data, offs, size, big_endian);
                }
            }
        }
        String s = TCFNumberFormat.toBigInteger(data, offs, size, big_endian, false).toString(radix);
        switch (radix) {
            case 8: {
                if (s.startsWith("0")) break;
                s = "0" + s;
                break;
            }
            case 16: {
                if (s.length() >= size * 2) break;
                StringBuffer bf = new StringBuffer();
                while (bf.length() + s.length() < size * 2) {
                    bf.append('0');
                }
                bf.append(s);
                s = bf.toString();
            }
        }
        assert (s != null);
        return s;
    }

    private String toNumberString(int radix) {
        byte[] data;
        String s = null;
        IExpressions.Value val = (IExpressions.Value)this.value.getData();
        if (val != null && (data = val.getValue()) != null) {
            ISymbols.TypeClass t = val.getTypeClass();
            if (t == ISymbols.TypeClass.unknown && this.type.getData() != null) {
                t = ((ISymbols.Symbol)this.type.getData()).getTypeClass();
            }
            s = this.toNumberString(radix, t, data, 0, data.length, val.isBigEndian());
        }
        if (s == null) {
            s = "N/A";
        }
        return s;
    }

    private void setLabel(ILabelUpdate result, String name, int col, int radix) {
        String s = this.toNumberString(radix);
        if (name == null) {
            result.setLabel(s, col);
        } else {
            result.setLabel(String.valueOf(name) + " = " + s, col);
        }
    }

    private boolean isValueChanged(IExpressions.Value x, IExpressions.Value y) {
        if (x == null || y == null) {
            return false;
        }
        byte[] xb = x.getValue();
        byte[] yb = y.getValue();
        if (xb == null || yb == null) {
            return false;
        }
        if (xb.length != yb.length) {
            return true;
        }
        int i = 0;
        while (i < xb.length) {
            if (xb[i] != yb[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean isShowTypeNamesEnabled(IPresentationContext context) {
        Boolean attribute = (Boolean)context.getProperty("org.eclipse.debug.ui.displayVariableTypeNames");
        return attribute != null && attribute != false;
    }

    @Override
    protected boolean getData(ILabelUpdate result, Runnable done) {
        if (this.is_empty) {
            result.setLabel("Add new expression", 0);
            result.setImageDescriptor(ImageCache.getImageDescriptor("icons/full/elcl16/monitorexpression_tsk.gif"), 0);
        } else if (this.enabled || this.script == null) {
            String c;
            Throwable error;
            String cast;
            TCFDataCache<ISymbols.Symbol> var;
            TCFDataCache<ISymbols.Symbol> type;
            ISymbols.Symbol field_data;
            TCFDataCache<ISymbols.Symbol> field = this.model.getSymbolInfoCache(this.field_id);
            TCFDataCache<ISymbols.Symbol> pending = null;
            if (field != null && !field.validate()) {
                pending = field;
            }
            if (this.reg_id != null && !this.expression_text.validate(done)) {
                pending = this.expression_text;
            }
            if (!this.var_expression.validate()) {
                pending = this.var_expression;
            }
            if (!this.base_text.validate()) {
                pending = this.base_text;
            }
            if (!this.value.validate()) {
                pending = this.value;
            }
            if (!this.type.validate()) {
                pending = this.type;
            }
            if (pending != null) {
                if (this.script != null) {
                    if (!this.rem_expression.validate(done)) {
                        return false;
                    }
                    IExpressions.Expression exp_data = (IExpressions.Expression)this.rem_expression.getData();
                    if (exp_data != null && exp_data.hasFuncCall()) {
                        pending.wait(this.post_delta);
                        result.setForeground(ColorCache.rgb_disabled, 0);
                        result.setLabel(String.valueOf(this.script) + " (Running)", 0);
                        return true;
                    }
                }
                pending.wait(done);
                return false;
            }
            String name = null;
            if (this.index >= 0) {
                name = this.index == 0 && this.deref ? "*" : "[" + this.index + "]";
            }
            if (name == null && field != null && (name = (field_data = (ISymbols.Symbol)field.getData()).getName()) == null && field_data.getFlag(0x2000000) && (type = this.model.getSymbolInfoCache(field_data.getTypeID())) != null) {
                if (!type.validate(done)) {
                    return false;
                }
                ISymbols.Symbol type_data = (ISymbols.Symbol)type.getData();
                if (type_data != null) {
                    name = type_data.getName();
                }
            }
            if (name == null && this.reg_id != null && this.expression_text.getData() != null) {
                name = (String)this.expression_text.getData();
            }
            if (name == null && this.var_expression.getData() != null && (var = this.model.getSymbolInfoCache(((IExpressions.Expression)this.var_expression.getData()).getSymbolID())) != null) {
                if (!var.validate(done)) {
                    return false;
                }
                ISymbols.Symbol var_data = (ISymbols.Symbol)var.getData();
                if (var_data != null) {
                    name = var_data.getName();
                    if (name == null && var_data.getFlag(65536)) {
                        name = "<VarArg>";
                    }
                    if (name == null) {
                        name = "<" + var_data.getID() + ">";
                    }
                }
            }
            if (name == null && this.base_text.getData() != null) {
                name = (String)this.base_text.getData();
            }
            if (name != null && (cast = this.model.getCastToType(this.id)) != null) {
                name = "(" + cast + ")(" + name + ")";
            }
            if ((error = this.base_text.getError()) == null) {
                error = this.value.getError();
            }
            String[] cols = result.getColumnIds();
            if (error != null) {
                if (cols == null || cols.length <= 1) {
                    result.setForeground(ColorCache.rgb_error, 0);
                    if (this.isShowTypeNamesEnabled(result.getPresentationContext())) {
                        if (!this.type_name.validate(done)) {
                            return false;
                        }
                        result.setLabel(String.valueOf(name) + ": N/A" + " , Type = " + (String)this.type_name.getData(), 0);
                    } else {
                        result.setLabel(String.valueOf(name) + ": N/A", 0);
                    }
                } else {
                    int i = 0;
                    while (i < cols.length) {
                        c = cols[i];
                        if (c.equals("Name")) {
                            result.setLabel(name, i);
                        } else if (c.equals("Type")) {
                            if (!this.type_name.validate(done)) {
                                return false;
                            }
                            result.setLabel((String)this.type_name.getData(), i);
                        } else {
                            result.setForeground(ColorCache.rgb_error, i);
                            result.setLabel("N/A", i);
                        }
                        ++i;
                    }
                }
            } else if (cols == null) {
                StyledStringBuffer s = this.getPrettyExpression(done);
                if (s == null) {
                    return false;
                }
                if (this.isShowTypeNamesEnabled(result.getPresentationContext())) {
                    if (!this.type_name.validate(done)) {
                        return false;
                    }
                    result.setLabel(String.valueOf(name) + " = " + s + " , Type = " + (String)this.type_name.getData(), 0);
                } else {
                    result.setLabel(String.valueOf(name) + " = " + s, 0);
                }
            } else {
                int i = 0;
                while (i < cols.length) {
                    c = cols[i];
                    if (c.equals("Name")) {
                        result.setLabel(name, i);
                    } else if (c.equals("Type")) {
                        if (!this.type_name.validate(done)) {
                            return false;
                        }
                        result.setLabel((String)this.type_name.getData(), i);
                    } else if (c.equals("HexValue")) {
                        this.setLabel(result, null, i, 16);
                    } else if (c.equals("DecValue")) {
                        this.setLabel(result, null, i, 10);
                    } else if (c.equals("Value")) {
                        StyledStringBuffer s = this.getPrettyExpression(done);
                        if (s == null) {
                            return false;
                        }
                        result.setLabel(s.toString(), i);
                    }
                    ++i;
                }
            }
            this.next_value = (IExpressions.Value)this.value.getData();
            if (this.isValueChanged(this.prev_value, this.next_value)) {
                if (cols != null) {
                    int i = 1;
                    while (i < cols.length) {
                        result.setBackground(ColorCache.rgb_highlight, i);
                        ++i;
                    }
                } else {
                    result.setForeground(ColorCache.rgb_no_columns_color_change, 0);
                }
            }
            ISymbols.TypeClass type_class = ISymbols.TypeClass.unknown;
            ISymbols.Symbol type_symbol = (ISymbols.Symbol)this.type.getData();
            if (type_symbol != null) {
                type_class = type_symbol.getTypeClass();
            }
            switch (type_class) {
                case pointer: {
                    result.setImageDescriptor(ImageCache.getImageDescriptor("icons/var_pointer.gif"), 0);
                    break;
                }
                case array: 
                case composite: {
                    result.setImageDescriptor(ImageCache.getImageDescriptor("icons/var_aggr.gif"), 0);
                    break;
                }
                default: {
                    result.setImageDescriptor(ImageCache.getImageDescriptor("icons/var_simple.gif"), 0);
                    break;
                }
            }
        } else {
            String[] cols = result.getColumnIds();
            if (cols == null || cols.length <= 1) {
                result.setForeground(ColorCache.rgb_disabled, 0);
                result.setLabel(this.script, 0);
            } else {
                int i = 0;
                while (i < cols.length) {
                    String c = cols[i];
                    if (c.equals("Name")) {
                        result.setForeground(ColorCache.rgb_disabled, i);
                        result.setLabel(this.script, i);
                    }
                    ++i;
                }
            }
        }
        return true;
    }

    @Override
    protected void getFontData(ILabelUpdate update, String view_id) {
        if (this.is_empty) {
            update.setFontData(TCFModelFonts.getItalicFontData(view_id), 0);
        } else {
            FontData fn = TCFModelFonts.getNormalFontData(view_id);
            String[] cols = update.getColumnIds();
            if (cols == null || cols.length == 0) {
                update.setFontData(fn, 0);
            } else {
                String[] ids = update.getColumnIds();
                int i = 0;
                while (i < cols.length) {
                    if ("HexValue".equals(ids[i]) || "DecValue".equals(ids[i]) || "Value".equals(ids[i])) {
                        update.setFontData(TCFModelFonts.getMonospacedFontData(view_id), i);
                    } else {
                        update.setFontData(fn, i);
                    }
                    ++i;
                }
            }
        }
    }

    private StyledStringBuffer getPrettyExpression(Runnable done) {
        for (ITCFPrettyExpressionProvider p : TCFPrettyExpressionProvider.getProviders()) {
            TCFDataCache<String> c = p.getText(this);
            if (c == null) continue;
            if (!c.validate(done)) {
                return null;
            }
            if (c.getError() != null || c.getData() == null) continue;
            StyledStringBuffer bf = new StyledStringBuffer();
            bf.append((String)c.getData(), 4);
            return bf;
        }
        if (!this.value.validate(done)) {
            return null;
        }
        if (!this.string.validate(done)) {
            return null;
        }
        StyledStringBuffer bf = new StyledStringBuffer();
        if (this.string.getData() != null) {
            bf.append((StyledStringBuffer)this.string.getData());
        } else {
            byte[] data;
            IExpressions.Value v = (IExpressions.Value)this.value.getData();
            if (v != null && (data = v.getValue()) != null && !this.appendValueText(bf, 1, v.getTypeID(), this, data, 0, data.length, v.isBigEndian(), done)) {
                return null;
            }
        }
        return bf;
    }

    private boolean appendArrayValueText(StyledStringBuffer bf, int level, ISymbols.Symbol type, byte[] data, int offs, int size, boolean big_endian, Runnable done) {
        assert (offs + size <= data.length);
        int length = type.getLength();
        bf.append('[');
        if (length > 0) {
            int elem_size = size / length;
            int n = 0;
            while (n < length) {
                if (n >= 100) {
                    bf.append("...");
                    break;
                }
                if (n > 0) {
                    bf.append(", ");
                }
                if (!this.appendValueText(bf, level + 1, type.getBaseTypeID(), null, data, offs + n * elem_size, elem_size, big_endian, done)) {
                    return false;
                }
                ++n;
            }
        }
        bf.append(']');
        return true;
    }

    private boolean appendCompositeValueText(StyledStringBuffer bf, int level, ISymbols.Symbol type, TCFNodeExpression data_node, boolean data_deref, byte[] data, int offs, int size, boolean big_endian, Runnable done) {
        TCFDataCache<String[]> children_cache = this.model.getSymbolChildrenCache(type.getID());
        if (children_cache == null) {
            bf.append("...");
            return true;
        }
        if (!children_cache.validate(done)) {
            return false;
        }
        String[] children_data = (String[])children_cache.getData();
        if (children_data == null) {
            bf.append("...");
            return true;
        }
        int cnt = 0;
        TCFDataCache<ISymbols.Symbol> pending = null;
        String[] stringArray = children_data;
        int n = children_data.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            TCFDataCache<ISymbols.Symbol> field_cache = this.model.getSymbolInfoCache(id);
            if (!field_cache.validate()) {
                pending = field_cache;
            } else {
                ISymbols.Symbol field_props = (ISymbols.Symbol)field_cache.getData();
                if (field_props != null && field_props.getSymbolClass() == ISymbols.SymbolClass.reference && !field_props.getFlag(131072)) {
                    String name = field_props.getName();
                    if (name == null && field_props.getFlag(0x2000000)) {
                        name = type.getName();
                    }
                    TCFNodeExpression field_node = null;
                    if (data_node != null) {
                        if (!data_node.children.validate(done)) {
                            return false;
                        }
                        field_node = data_node.children.getField(id, data_deref);
                    }
                    if (field_props.getProperties().get("Offset") == null) {
                        if (name != null && field_node != null) {
                            byte[] field_data;
                            if (cnt > 0) {
                                bf.append(", ");
                            }
                            bf.append(name);
                            bf.append('=');
                            if (!field_node.value.validate(done)) {
                                return false;
                            }
                            IExpressions.Value field_value = (IExpressions.Value)field_node.value.getData();
                            byte[] byArray = field_data = field_value != null ? field_value.getValue() : null;
                            if (field_data == null) {
                                bf.append('?');
                            } else if (!field_node.appendValueText(bf, level + 1, field_props.getTypeID(), field_node, field_data, 0, field_data.length, big_endian, done)) {
                                return false;
                            }
                            ++cnt;
                        }
                    } else {
                        int f_offs = field_props.getOffset();
                        int f_size = field_props.getSize();
                        if (cnt > 0) {
                            bf.append(", ");
                        }
                        if (name != null) {
                            bf.append(name);
                            bf.append('=');
                        }
                        if (offs + f_offs + f_size > data.length) {
                            bf.append('?');
                        } else if (!this.appendValueText(bf, level + 1, field_props.getTypeID(), field_node, data, offs + f_offs, f_size, big_endian, done)) {
                            return false;
                        }
                        ++cnt;
                    }
                }
            }
            ++n2;
        }
        if (pending == null) {
            return true;
        }
        pending.wait(done);
        return false;
    }

    private boolean appendNumericValueText(StyledStringBuffer bf, ISymbols.TypeClass type_class, byte[] data, boolean big_endian, Runnable done) {
        assert (data != null);
        bf.append("Hex: ", 1);
        bf.append(this.toNumberString(16, type_class, data, 0, data.length, big_endian), 4);
        bf.append(", ");
        bf.append("Dec: ", 1);
        bf.append(this.toNumberString(10, type_class, data, 0, data.length, big_endian), 4);
        bf.append(", ");
        bf.append("Oct: ", 1);
        bf.append(this.toNumberString(8, type_class, data, 0, data.length, big_endian), 4);
        IExpressions.Value v = (IExpressions.Value)this.value.getData();
        assert (data == v.getValue());
        if (v.getTypeClass() == ISymbols.TypeClass.pointer) {
            TCFNode p = this.parent;
            while (p != null) {
                if (p instanceof TCFNodeExecContext) {
                    TCFNodeExecContext exe = (TCFNodeExecContext)p;
                    BigInteger addr = TCFNumberFormat.toBigInteger(data, 0, data.length, big_endian, false);
                    if (exe.appendPointedObject(bf, addr, done)) break;
                    return false;
                }
                p = p.parent;
            }
        }
        bf.append('\n');
        bf.append("Bin: ", 1);
        bf.append(this.toNumberString(2), 4);
        bf.append('\n');
        return true;
    }

    private boolean appendValueText(StyledStringBuffer bf, int level, String type_id, TCFNodeExpression data_node, byte[] data, int offs, int size, boolean big_endian, Runnable done) {
        ISymbols.TypeClass type_class;
        if (data == null) {
            return true;
        }
        ISymbols.Symbol type_data = null;
        if (type_id != null) {
            TCFDataCache<ISymbols.Symbol> type_cache = this.model.getSymbolInfoCache(type_id);
            if (!type_cache.validate(done)) {
                return false;
            }
            type_data = (ISymbols.Symbol)type_cache.getData();
        }
        if (type_data == null) {
            type_class = ISymbols.TypeClass.unknown;
            if (!this.value.validate(done)) {
                return false;
            }
            if (this.value.getData() != null) {
                type_class = ((IExpressions.Value)this.value.getData()).getTypeClass();
            }
            if (level == 0) {
                assert (offs == 0 && size == data.length && data_node == this);
                if (size > 0 && !this.appendNumericValueText(bf, type_class, data, big_endian, done)) {
                    return false;
                }
                String s = this.getTypeName(type_class, size);
                if (s == null) {
                    s = "not available";
                }
                bf.append("Size: ", 1);
                bf.append(Integer.toString(size), 4);
                bf.append(size == 1 ? " byte" : " bytes");
                bf.append(", ");
                bf.append("Type: ", 1);
                bf.append(s);
                bf.append('\n');
            } else if (type_class == ISymbols.TypeClass.integer || type_class == ISymbols.TypeClass.real) {
                bf.append(this.toNumberString(10, type_class, data, offs, size, big_endian), 4);
            } else {
                bf.append(this.toNumberString(16, type_class, data, offs, size, big_endian), 4);
            }
            return true;
        }
        if (level == 0) {
            StyledStringBuffer s = this.getPrettyExpression(done);
            if (s == null) {
                return false;
            }
            if (s.length() > 0) {
                bf.append(s);
                bf.append('\n');
            } else if (this.string.getError() != null) {
                bf.append("Cannot read pointed value: ", 1, null, ColorCache.rgb_error);
                bf.append(TCFModel.getErrorMessage(this.string.getError(), false), 2, null, ColorCache.rgb_error);
                bf.append('\n');
            }
        }
        if (type_data.getSize() > 0) {
            type_class = type_data.getTypeClass();
            switch (type_class) {
                case cardinal: 
                case integer: 
                case real: 
                case enumeration: {
                    if (level == 0) {
                        assert (offs == 0 && size == data.length && data_node == this);
                        if (this.appendNumericValueText(bf, type_class, data, big_endian, done)) break;
                        return false;
                    }
                    if (type_data.getTypeClass() == ISymbols.TypeClass.cardinal) {
                        bf.append("0x", 4);
                        bf.append(this.toNumberString(16, type_class, data, offs, size, big_endian), 4);
                        break;
                    }
                    bf.append(this.toNumberString(10, type_class, data, offs, size, big_endian), 4);
                    break;
                }
                case pointer: 
                case function: 
                case member_pointer: {
                    if (level == 0) {
                        assert (offs == 0 && size == data.length && data_node == this);
                        if (this.appendNumericValueText(bf, type_class, data, big_endian, done)) break;
                        return false;
                    }
                    bf.append("0x", 4);
                    bf.append(this.toNumberString(16, type_class, data, offs, size, big_endian), 4);
                    break;
                }
                case array: {
                    if (level <= 0 || this.appendArrayValueText(bf, level, type_data, data, offs, size, big_endian, done)) break;
                    return false;
                }
                case composite: {
                    if (level <= 0) break;
                    bf.append('{');
                    if (!this.appendCompositeValueText(bf, level, type_data, data_node, false, data, offs, size, big_endian, done)) {
                        return false;
                    }
                    bf.append('}');
                }
            }
        }
        if (level == 0) {
            if (!this.type_name.validate(done)) {
                return false;
            }
            bf.append("Size: ", 1);
            bf.append(Integer.toString(type_data.getSize()), 4);
            bf.append(type_data.getSize() == 1 ? " byte" : " bytes");
            String nm = (String)this.type_name.getData();
            if (nm != null) {
                bf.append(", ");
                bf.append("Type: ", 1);
                bf.append(nm);
            }
            bf.append('\n');
        }
        return true;
    }

    private String getRegisterName(String reg_id, Runnable done) {
        String name = reg_id;
        if (!this.model.createNode(reg_id, done)) {
            return null;
        }
        TCFNodeRegister reg_node = (TCFNodeRegister)this.model.getNode(reg_id);
        if (reg_node != null) {
            TCFDataCache<IRegisters.RegistersContext> reg_ctx_cache = reg_node.getContext();
            if (!reg_ctx_cache.validate(done)) {
                return null;
            }
            IRegisters.RegistersContext reg_ctx_data = (IRegisters.RegistersContext)reg_ctx_cache.getData();
            if (reg_ctx_data != null && reg_ctx_data.getName() != null) {
                name = reg_ctx_data.getName();
            }
        }
        return name;
    }

    @Override
    public boolean getDetailText(StyledStringBuffer bf, Runnable done) {
        if (this.is_empty) {
            return true;
        }
        if (!this.enabled) {
            bf.append("Disabled");
            return true;
        }
        if (!this.rem_expression.validate(done)) {
            return false;
        }
        if (this.rem_expression.getError() == null) {
            if (!this.value.validate(done)) {
                return false;
            }
            IExpressions.Value v = (IExpressions.Value)this.value.getData();
            if (v != null) {
                Number addr;
                TCFDataCache<ISymbols.Symbol> field_cache;
                byte[] data;
                if (this.value.getError() == null && (data = v.getValue()) != null) {
                    boolean big_endian = v.isBigEndian();
                    if (!this.appendValueText(bf, 0, v.getTypeID(), this, data, 0, data.length, big_endian, done)) {
                        return false;
                    }
                }
                int cnt = 0;
                String reg_id = v.getRegisterID();
                if (reg_id != null) {
                    String nm = this.getRegisterName(reg_id, done);
                    if (nm == null) {
                        return false;
                    }
                    bf.append("Register: ", 1);
                    bf.append(nm);
                    ++cnt;
                }
                if ((field_cache = this.model.getSymbolInfoCache(this.field_id)) != null) {
                    if (!field_cache.validate(done)) {
                        return false;
                    }
                    ISymbols.Symbol field_props = (ISymbols.Symbol)field_cache.getData();
                    if (field_props != null && field_props.getProperties().get("Offset") != null) {
                        if (cnt > 0) {
                            bf.append(", ");
                        }
                        bf.append("Offset: ", 1);
                        bf.append(Integer.toString(field_props.getOffset()), 4);
                        ++cnt;
                    }
                }
                if ((addr = v.getAddress()) != null) {
                    BigInteger i = JSON.toBigInteger((Number)addr);
                    if (cnt > 0) {
                        bf.append(", ");
                    }
                    bf.append("Address: ", 1);
                    bf.append("0x", 4);
                    bf.append(i.toString(16), 4);
                    ++cnt;
                }
                if (cnt > 0) {
                    bf.append('\n');
                }
            }
            if (this.value.getError() != null) {
                bf.append(this.value.getError(), ColorCache.rgb_error);
            }
        } else {
            bf.append(this.rem_expression.getError(), ColorCache.rgb_error);
        }
        return true;
    }

    public String getValueText(boolean add_error_text, Runnable done) {
        byte[] data;
        if (!this.rem_expression.validate(done)) {
            return null;
        }
        if (!this.value.validate(done)) {
            return null;
        }
        StyledStringBuffer bf = new StyledStringBuffer();
        IExpressions.Value v = (IExpressions.Value)this.value.getData();
        if (v != null && (data = v.getValue()) != null) {
            boolean big_endian = v.isBigEndian();
            if (!this.appendValueText(bf, 1, v.getTypeID(), this, data, 0, data.length, big_endian, done)) {
                return null;
            }
        }
        if (add_error_text) {
            if (bf.length() == 0 && this.rem_expression.getError() != null) {
                bf.append(TCFModel.getErrorMessage(this.rem_expression.getError(), false));
            }
            if (bf.length() == 0 && this.value.getError() != null) {
                bf.append(TCFModel.getErrorMessage(this.value.getError(), false));
            }
        }
        return bf.toString();
    }

    @Override
    protected boolean getData(IChildrenCountUpdate result, Runnable done) {
        if (!this.is_empty && this.enabled) {
            if (!this.children.validate(done)) {
                return false;
            }
            result.setChildCount(this.children.size());
        } else {
            result.setChildCount(0);
        }
        return true;
    }

    @Override
    protected boolean getData(IChildrenUpdate result, Runnable done) {
        if (this.is_empty || !this.enabled) {
            return true;
        }
        return this.children.getData(result, done);
    }

    @Override
    protected boolean getData(IHasChildrenUpdate result, Runnable done) {
        if (!this.is_empty && this.enabled) {
            if (!this.children.validate(done)) {
                return false;
            }
            result.setHasChilren(this.children.size() > 0);
        } else {
            result.setHasChilren(false);
        }
        return true;
    }

    @Override
    public int compareTo(TCFNode n) {
        TCFNodeExpression e = (TCFNodeExpression)n;
        if (this.sort_pos < e.sort_pos) {
            return -1;
        }
        if (this.sort_pos > e.sort_pos) {
            return 1;
        }
        return 0;
    }

    public CellEditor getCellEditor(IPresentationContext context, String column_id, Object element, Composite parent) {
        assert (element == this);
        if ("Name".equals(column_id)) {
            return new TextCellEditor(parent);
        }
        if ("HexValue".equals(column_id)) {
            return new TextCellEditor(parent);
        }
        if ("DecValue".equals(column_id)) {
            return new TextCellEditor(parent);
        }
        if ("Value".equals(column_id)) {
            return new TextCellEditor(parent);
        }
        return null;
    }

    public ICellModifier getCellModifier(IPresentationContext context, Object element) {
        assert (element == this);
        return cell_modifier;
    }

    @Override
    public Object getAdapter(Class adapter) {
        if (this.script != null) {
            if (adapter == IExpression.class) {
                return this.platform_expression;
            }
            if (adapter == IWatchExpression.class && this.platform_expression instanceof IWatchExpression) {
                return this.platform_expression;
            }
        }
        return super.getAdapter(adapter);
    }
}

