/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.launch.ui.tabs.filetransfers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.tcf.te.launch.core.persistence.filetransfer.FileTransfersPersistenceDelegate;
import org.eclipse.tcf.te.launch.core.persistence.launchcontext.LaunchContextsPersistenceDelegate;
import org.eclipse.tcf.te.launch.ui.interfaces.ILaunchConfigurationTabFormPart;
import org.eclipse.tcf.te.launch.ui.nls.Messages;
import org.eclipse.tcf.te.launch.ui.tabs.filetransfers.FileTransferCheckStateProvider;
import org.eclipse.tcf.te.launch.ui.tabs.filetransfers.FileTransferContentProvider;
import org.eclipse.tcf.te.runtime.model.interfaces.IModelNode;
import org.eclipse.tcf.te.runtime.services.interfaces.filetransfer.IFileTransferItem;
import org.eclipse.tcf.te.ui.forms.parts.AbstractTableSection;
import org.eclipse.tcf.te.ui.swt.listener.AbstractDecorationCellPaintListener;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public abstract class AbstractFileTransferSection
extends AbstractTableSection
implements ILaunchConfigurationTabFormPart {
    protected ControlDecoration controlDecoration;
    protected IModelNode launchContext;
    protected static final String PROPERTY_VALIDATION_RESULT = "validation_result.transient";

    public AbstractFileTransferSection(IManagedForm form, Composite parent) {
        String[] stringArray = new String[6];
        stringArray[0] = Messages.FileTransferSection_add_button;
        stringArray[1] = Messages.FileTransferSection_edit_button;
        stringArray[2] = Messages.FileTransferSection_delete_button;
        stringArray[4] = Messages.FileTransferSection_up_button;
        stringArray[5] = Messages.FileTransferSection_down_button;
        super(form, parent, 0, stringArray);
        this.launchContext = null;
    }

    @Override
    public void initializeFrom(ILaunchConfiguration configuration) {
        IFileTransferItem[] items = FileTransfersPersistenceDelegate.getFileTransfers((ILaunchConfiguration)configuration);
        this.getTablePart().getViewer().setInput((Object)items);
        if (items != null && items.length > 0) {
            ((TableViewer)this.getTablePart().getViewer()).setSelection((ISelection)new StructuredSelection((Object)items[0]), true);
        }
        this.launchContext = LaunchContextsPersistenceDelegate.getFirstLaunchContext((ILaunchConfiguration)configuration);
    }

    @Override
    public void performApply(ILaunchConfigurationWorkingCopy wc) {
        FileTransfersPersistenceDelegate.setFileTransfers((ILaunchConfigurationWorkingCopy)wc, (IFileTransferItem[])((IFileTransferItem[])this.getTablePart().getViewer().getInput()));
    }

    @Override
    public boolean isValid(ILaunchConfiguration configuration) {
        return this.validateInputList();
    }

    protected abstract boolean validateInputList();

    protected void createClient(Section section, FormToolkit toolkit) {
        Assert.isNotNull((Object)section);
        Assert.isNotNull((Object)toolkit);
        section.setText(Messages.FileTransferSection_title);
        section.setDescription(Messages.FileTransferSection_description);
        if (section.getParent().getLayout() instanceof GridLayout) {
            section.setLayoutData((Object)new GridData(272, 0x1000000, true, true));
        }
        Composite client = this.createClientContainer((Composite)section, 2, toolkit);
        client.setBackground(section.getBackground());
        section.setClient((Control)client);
        this.createPartControl((Composite)section.getClient(), 68356, 2, toolkit);
        this.setIsUpdating(false);
    }

    protected TableViewer createTableViewer(Composite parent, int style) {
        return new CheckboxTableViewer(new Table(parent, style | 0x20));
    }

    protected void configureTableViewer(TableViewer viewer) {
        super.configureTableViewer(viewer);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)viewer);
        final Table table = viewer.getTable();
        if (viewer instanceof CheckboxTableViewer) {
            ((CheckboxTableViewer)viewer).setCheckStateProvider((ICheckStateProvider)new FileTransferCheckStateProvider());
            ((CheckboxTableViewer)viewer).addCheckStateListener(new ICheckStateListener(){

                public void checkStateChanged(CheckStateChangedEvent event) {
                    if (event.getElement() instanceof IFileTransferItem) {
                        IFileTransferItem item = (IFileTransferItem)event.getElement();
                        item.setProperty("enabled", event.getChecked());
                        AbstractFileTransferSection.this.getManagedForm().dirtyStateChanged();
                    }
                }
            });
        }
        TableViewerColumn tvEnableCol = new TableViewerColumn(viewer, 0);
        final TableColumn colEnable = tvEnableCol.getColumn();
        colEnable.setResizable(false);
        tvEnableCol.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return null;
            }
        });
        TableViewerColumn tvHostCol = new TableViewerColumn(viewer, 0);
        final TableColumn colHost = tvHostCol.getColumn();
        colHost.setText(Messages.FileTransferSection_host_column);
        colHost.setResizable(true);
        tvHostCol.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getToolTipText(Object element) {
                if (element instanceof IFileTransferItem) {
                    IFileTransferItem item = (IFileTransferItem)element;
                    Map invalid = (Map)item.getProperty(AbstractFileTransferSection.PROPERTY_VALIDATION_RESULT);
                    if (invalid != null && invalid.containsKey("host")) {
                        return (String)invalid.get("host");
                    }
                    String host = item.getStringProperty("host");
                    return host != null ? new Path(host).toOSString() : host;
                }
                return super.getText(element);
            }

            public String getText(Object element) {
                if (element instanceof IFileTransferItem) {
                    IFileTransferItem item = (IFileTransferItem)element;
                    String host = item.getStringProperty("host");
                    return host != null ? new Path(host).toOSString() : host;
                }
                return super.getText(element);
            }
        });
        TableViewerColumn tvDirCol = new TableViewerColumn(viewer, 0);
        final TableColumn colDir = tvDirCol.getColumn();
        colDir.setResizable(false);
        colDir.setAlignment(0x1000000);
        tvDirCol.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getToolTipText(Object element) {
                if (element instanceof IFileTransferItem) {
                    IFileTransferItem item = (IFileTransferItem)element;
                    switch (item.getIntProperty("direction")) {
                        case 2: {
                            return Messages.FileTransferSection_toHost_tooltip;
                        }
                    }
                    return Messages.FileTransferSection_toTarget_tooltip;
                }
                return super.getToolTipText(element);
            }

            public String getText(Object element) {
                if (element instanceof IFileTransferItem) {
                    IFileTransferItem item = (IFileTransferItem)element;
                    switch (item.getIntProperty("direction")) {
                        case 2: {
                            return Messages.FileTransferSection_toHost_text;
                        }
                    }
                    return Messages.FileTransferSection_toTarget_text;
                }
                return super.getText(element);
            }
        });
        tvDirCol.setEditingSupport(new EditingSupport(tvDirCol.getViewer()){

            protected void setValue(Object element, Object value) {
                if (element instanceof IFileTransferItem) {
                    IFileTransferItem item = (IFileTransferItem)element;
                    item.setProperty("direction", Boolean.parseBoolean(value.toString()) ? 1 : 2);
                    AbstractFileTransferSection.this.getManagedForm().dirtyStateChanged();
                    this.getViewer().refresh();
                }
            }

            protected Object getValue(Object element) {
                if (element instanceof IFileTransferItem) {
                    IFileTransferItem item = (IFileTransferItem)element;
                    return item.getIntProperty("direction") != 2;
                }
                return null;
            }

            protected CellEditor getCellEditor(Object element) {
                return new CheckboxCellEditor();
            }

            protected boolean canEdit(Object element) {
                return true;
            }
        });
        TableViewerColumn tvTargetCol = new TableViewerColumn(viewer, 0);
        final TableColumn colTarget = tvTargetCol.getColumn();
        colTarget.setText(Messages.FileTransferSection_target_column);
        colTarget.setResizable(true);
        tvTargetCol.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getToolTipText(Object element) {
                if (element instanceof IFileTransferItem) {
                    IFileTransferItem item = (IFileTransferItem)element;
                    Map invalid = (Map)item.getProperty(AbstractFileTransferSection.PROPERTY_VALIDATION_RESULT);
                    if (invalid != null && invalid.containsKey("target")) {
                        return (String)invalid.get("target");
                    }
                    String target = item.getStringProperty("target");
                    return target != null ? new Path(target).toPortableString() : target;
                }
                return super.getText(element);
            }

            public String getText(Object element) {
                if (element instanceof IFileTransferItem) {
                    IFileTransferItem item = (IFileTransferItem)element;
                    String target = item.getStringProperty("target");
                    return target != null ? new Path(target).toPortableString() : target;
                }
                return super.getText(element);
            }
        });
        TableViewerColumn tvOptionCol = new TableViewerColumn(viewer, 0);
        final TableColumn colOption = tvOptionCol.getColumn();
        colOption.setText(Messages.FileTransferSection_options_column);
        colOption.setResizable(true);
        tvOptionCol.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getToolTipText(Object element) {
                if (element instanceof IFileTransferItem) {
                    IFileTransferItem item = (IFileTransferItem)element;
                    return item.getStringProperty("options");
                }
                return super.getText(element);
            }

            public String getText(Object element) {
                if (element instanceof IFileTransferItem) {
                    IFileTransferItem item = (IFileTransferItem)element;
                    return item.getStringProperty("options");
                }
                return super.getText(element);
            }
        });
        TableLayout tableLayout = new TableLayout();
        tableLayout.addColumnData((ColumnLayoutData)new ColumnPixelData(30, true));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnPixelData(200, true));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnPixelData(30, true));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnPixelData(200, true));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnPixelData(100, true));
        table.setLayout((Layout)tableLayout);
        GridData data = new GridData(1810);
        table.setLayoutData((Object)data);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        table.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                int width = table.getSize().x - 4 - colEnable.getWidth() - colHost.getWidth() - colDir.getWidth() - colTarget.getWidth();
                colOption.setWidth(Math.max(width, 100));
            }
        });
        colHost.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                int colWidth = colHost.getWidth();
                if (colWidth < 100) {
                    event.doit = false;
                    colHost.setWidth(100);
                    colWidth = 100;
                }
                int width = table.getSize().x - 4 - colWidth - colEnable.getWidth() - colDir.getWidth() - colTarget.getWidth();
                colOption.setWidth(Math.max(width, 100));
            }
        });
        colTarget.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                int colWidth = colTarget.getWidth();
                if (colWidth < 100) {
                    event.doit = false;
                    colTarget.setWidth(100);
                    colWidth = 100;
                }
                int width = table.getSize().x - 4 - colWidth - colEnable.getWidth() - colHost.getWidth() - colDir.getWidth();
                colOption.setWidth(Math.max(width, 100));
            }
        });
        new AbstractDecorationCellPaintListener((Widget)table, new int[]{1, 3}){

            protected int getDecorationState(Object data, int columnIndex) {
                Map invalid;
                IFileTransferItem item;
                if (data instanceof IFileTransferItem && (item = (IFileTransferItem)data).getBooleanProperty("enabled") && (invalid = (Map)item.getProperty(AbstractFileTransferSection.PROPERTY_VALIDATION_RESULT)) != null) {
                    switch (columnIndex) {
                        case 1: {
                            if (!invalid.containsKey("host")) break;
                            return 3;
                        }
                        case 3: {
                            if (!invalid.containsKey("target")) break;
                            return 3;
                        }
                    }
                }
                return 0;
            }
        };
        viewer.setContentProvider((IContentProvider)new FileTransferContentProvider());
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                AbstractFileTransferSection.this.initializeButtonsEnablement();
            }
        });
        this.doCreateControlDecoration((Control)table);
        this.configureControlDecoration(this.getControlDecoration());
    }

    public ControlDecoration doCreateControlDecoration(Control control) {
        Assert.isNotNull((Object)control);
        this.controlDecoration = new ControlDecoration(control, 16512);
        return this.controlDecoration;
    }

    public final ControlDecoration getControlDecoration() {
        return this.controlDecoration;
    }

    protected void configureControlDecoration(ControlDecoration decoration) {
        Assert.isNotNull((Object)decoration);
        decoration.setShowOnlyOnFocus(false);
    }

    public void updateControlDecoration(String message, int messageType) {
        if (this.getControlDecoration() != null) {
            this.getControlDecoration().setDescriptionText(message);
            FieldDecorationRegistry registry = FieldDecorationRegistry.getDefault();
            String decorationId = "DEC_INFORMATION";
            if (messageType == 3) {
                decorationId = "DEC_ERROR";
            } else if (messageType == 2) {
                decorationId = "DEC_WARNING";
            }
            FieldDecoration fieldDeco = registry.getFieldDecoration(decorationId);
            if (fieldDeco != null) {
                this.getControlDecoration().setImage(fieldDeco.getImage());
            }
            if (message == null || messageType == 0) {
                this.getControlDecoration().hide();
            } else {
                this.getControlDecoration().show();
            }
        }
    }

    protected List<IFileTransferItem> getInputList() {
        return new ArrayList<IFileTransferItem>(Arrays.asList((IFileTransferItem[])this.getTablePart().getViewer().getInput()));
    }

    protected void setInputList(List<IFileTransferItem> list) {
        this.getTablePart().getViewer().setInput((Object)list.toArray(new IFileTransferItem[list.size()]));
    }

    public void doubleClick(DoubleClickEvent event) {
        this.onButtonEditClick();
    }

    protected void onButtonSelected(Button button) {
        int selIndex = ((TableViewer)this.getTablePart().getViewer()).getTable().getSelectionIndex();
        List<IFileTransferItem> list = this.getInputList();
        switch ((Integer)button.getData()) {
            case 0: {
                this.onButtonAddClick();
                break;
            }
            case 1: {
                this.onButtonEditClick();
                break;
            }
            case 2: {
                list.remove(selIndex);
                this.setInputList(list);
                if (list.isEmpty()) break;
                ((TableViewer)this.getTablePart().getViewer()).setSelection((ISelection)new StructuredSelection((Object)list.get(selIndex < list.size() ? selIndex : list.size() - 1)), true);
                break;
            }
            case 4: {
                list.add(selIndex - 1, list.remove(selIndex));
                this.setInputList(list);
                ((TableViewer)this.getTablePart().getViewer()).setSelection((ISelection)new StructuredSelection((Object)list.get(selIndex - 1)), true);
                break;
            }
            case 5: {
                list.add(selIndex + 1, list.remove(selIndex));
                this.setInputList(list);
                ((TableViewer)this.getTablePart().getViewer()).setSelection((ISelection)new StructuredSelection((Object)list.get(selIndex + 1)), true);
            }
        }
        this.validateInputList();
        this.getManagedForm().dirtyStateChanged();
    }

    protected abstract void onButtonAddClick();

    protected abstract void onButtonEditClick();

    protected void initializeButtonsEnablement() {
        ISelection selection = ((TableViewer)this.getTablePart().getViewer()).getSelection();
        boolean singleSelection = selection instanceof IStructuredSelection && ((IStructuredSelection)selection).size() == 1;
        int selIndex = ((TableViewer)this.getTablePart().getViewer()).getTable().getSelectionIndex();
        int count = ((TableViewer)this.getTablePart().getViewer()).getTable().getItemCount();
        this.getTablePart().getButton(0).setEnabled(this.getTablePart().isEnabled());
        this.getTablePart().getButton(1).setEnabled(this.getTablePart().isEnabled() && singleSelection);
        this.getTablePart().getButton(2).setEnabled(this.getTablePart().isEnabled() && singleSelection);
        this.getTablePart().getButton(4).setEnabled(this.getTablePart().isEnabled() && singleSelection && selIndex > 0);
        this.getTablePart().getButton(5).setEnabled(this.getTablePart().isEnabled() && singleSelection && selIndex < count - 1);
    }
}

