/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.runtime.stepper.steps;

import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.tcf.te.runtime.callback.AsyncCallbackCollector;
import org.eclipse.tcf.te.runtime.callback.Callback;
import org.eclipse.tcf.te.runtime.concurrent.util.ExecutorsUtil;
import org.eclipse.tcf.te.runtime.interfaces.IConditionTester;
import org.eclipse.tcf.te.runtime.interfaces.callback.ICallback;
import org.eclipse.tcf.te.runtime.interfaces.properties.IPropertiesContainer;
import org.eclipse.tcf.te.runtime.stepper.StepperAttributeUtil;
import org.eclipse.tcf.te.runtime.stepper.interfaces.IFullQualifiedId;
import org.eclipse.tcf.te.runtime.stepper.interfaces.IStepContext;
import org.eclipse.tcf.te.runtime.stepper.job.StepperJob;
import org.eclipse.tcf.te.runtime.stepper.steps.AbstractStep;
import org.eclipse.tcf.te.runtime.utils.ProgressHelper;

public class CancelJobsStep
extends AbstractStep {
    @Override
    public void validateExecute(IStepContext context, IPropertiesContainer data, IFullQualifiedId fullQualifiedId, IProgressMonitor monitor) throws CoreException {
    }

    @Override
    public void execute(final IStepContext context, final IPropertiesContainer data, IFullQualifiedId fullQualifiedId, final IProgressMonitor monitor, ICallback callback) {
        StepperJob thisJob = (StepperJob)((Object)StepperAttributeUtil.getProperty("org.eclipse.tcf.te.runtime.stepper.stepper_job", fullQualifiedId, data));
        final AsyncCallbackCollector collector = new AsyncCallbackCollector();
        Map<String, List<Job>> jobs = StepperJob.getJobs(context.getContextObject());
        final AtomicInteger numJobsToCancel = new AtomicInteger(0);
        final AtomicInteger canceledJobs = new AtomicInteger(0);
        for (String op : jobs.keySet()) {
            for (Job job : jobs.get(op)) {
                if (job == thisJob || job instanceof StepperJob && !((StepperJob)job).isCancelable()) continue;
                numJobsToCancel.set(numJobsToCancel.get() + 1);
            }
        }
        for (String op : jobs.keySet()) {
            for (Job job : jobs.get(op)) {
                if (job == thisJob) continue;
                if (job instanceof StepperJob && ((StepperJob)job).isCancelable()) {
                    Callback jobCb = new Callback(((StepperJob)job).getJobCallback()){

                        protected void internalDone(Object caller, IStatus status) {
                            canceledJobs.set(canceledJobs.get() + 1);
                            ProgressHelper.worked((IProgressMonitor)monitor, (int)(CancelJobsStep.this.getTotalWork(context, data) / numJobsToCancel.get()));
                            ProgressHelper.setSubTaskName((IProgressMonitor)monitor, (String)(String.valueOf(canceledJobs.get()) + " of " + numJobsToCancel.get() + " Jobs canceled."));
                            collector.removeCallback((ICallback)this);
                        }
                    };
                    if (job.getState() == 4) {
                        collector.addCallback((ICallback)jobCb);
                        ((StepperJob)job).setJobCallback((ICallback)jobCb);
                    } else {
                        canceledJobs.set(canceledJobs.get() + 1);
                    }
                } else {
                    canceledJobs.set(canceledJobs.get() + 1);
                }
                job.cancel();
            }
        }
        collector.initDone();
        ExecutorsUtil.waitAndExecute((long)0L, (IConditionTester)collector.getConditionTester());
        callback.done((Object)this, Status.OK_STATUS);
    }
}

