/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.filesystem.core.internal.callbacks;

import java.io.File;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.tcf.protocol.IChannel;
import org.eclipse.tcf.protocol.IToken;
import org.eclipse.tcf.services.IFileSystem;
import org.eclipse.tcf.te.runtime.interfaces.callback.ICallback;
import org.eclipse.tcf.te.tcf.core.Tcf;
import org.eclipse.tcf.te.tcf.filesystem.core.activator.CorePlugin;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.callbacks.CallbackBase;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.operations.JobExecutor;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.operations.OpTargetFileDigest;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.utils.CacheManager;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.utils.FileState;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.utils.PersistenceManager;
import org.eclipse.tcf.te.tcf.filesystem.core.model.FSTreeNode;

public class RefreshStateDoneStat
extends CallbackBase
implements IFileSystem.DoneStat {
    IChannel channel;
    FSTreeNode node;
    ICallback callback;

    public RefreshStateDoneStat(FSTreeNode node, IChannel channel, ICallback callback) {
        this.node = node;
        this.channel = channel;
        this.callback = callback;
    }

    public void doneStat(IToken token, IFileSystem.FileSystemException error, IFileSystem.FileAttrs attrs) {
        Tcf.getChannelManager().closeChannel(this.channel);
        if (error == null) {
            IFileSystem.FileAttrs oldAttrs = this.node.attr;
            this.node.setAttributes(attrs);
            if (this.node.isFile()) {
                File file = CacheManager.getCacheFile(this.node);
                if (file.exists()) {
                    FileState fileDigest = PersistenceManager.getInstance().getFileDigest(this.node);
                    if (fileDigest.getTargetDigest() == null || oldAttrs == null && attrs != null || oldAttrs != null && attrs == null || oldAttrs != null && attrs != null && oldAttrs.mtime != attrs.mtime) {
                        this.updateTargetDigest();
                    } else {
                        this.invokeCallback(Status.OK_STATUS);
                    }
                } else {
                    this.invokeCallback(Status.OK_STATUS);
                }
            } else {
                this.invokeCallback(Status.OK_STATUS);
            }
        } else {
            String message = this.getErrorMessage((Throwable)error);
            Status status = new Status(4, CorePlugin.getUniqueIdentifier(), message, (Throwable)error);
            this.invokeCallback((IStatus)status);
        }
    }

    protected void invokeCallback(IStatus status) {
        if (this.callback != null) {
            this.callback.done((Object)this, status);
        }
    }

    private void updateTargetDigest() {
        JobExecutor executor = new JobExecutor(this.callback);
        executor.execute(new OpTargetFileDigest(this.node));
    }
}

