/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.filesystem.core.internal.operations;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.tcf.protocol.IChannel;
import org.eclipse.tcf.protocol.IToken;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.services.IFileSystem;
import org.eclipse.tcf.te.tcf.core.Tcf;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.exceptions.TCFException;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.exceptions.TCFFileSystemException;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.operations.Operation;
import org.eclipse.tcf.te.tcf.filesystem.core.model.FSTreeNode;
import org.eclipse.tcf.te.tcf.filesystem.core.nls.Messages;

public abstract class OpCreate
extends Operation {
    protected final FSTreeNode folder;
    protected FSTreeNode node;
    protected final String name;

    public OpCreate(FSTreeNode folder, String name) {
        Assert.isNotNull((Object)folder);
        this.folder = folder;
        Assert.isNotNull((Object)name);
        this.name = name;
    }

    @Override
    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        block8: {
            super.run(monitor);
            IChannel channel = null;
            try {
                try {
                    channel = OpCreate.openChannel(this.folder.peerNode.getPeer());
                    monitor.worked(1);
                    IFileSystem service = OpCreate.getBlockingFileSystem(channel);
                    if (service != null) {
                        if (!this.folder.childrenQueried) {
                            this.loadChildren(this.folder, service);
                            monitor.worked(1);
                        }
                        monitor.worked(1);
                        this.create(service);
                        monitor.worked(1);
                        this.addNode(service);
                        monitor.worked(1);
                        this.refresh(service);
                        monitor.worked(1);
                        break block8;
                    }
                    String message = NLS.bind((String)Messages.Operation_NoFileSystemError, (Object)this.folder.peerNode.getPeerId());
                    throw new TCFFileSystemException(4, message);
                }
                catch (TCFException e) {
                    throw new InvocationTargetException(e, e.getMessage());
                }
            }
            finally {
                if (channel != null) {
                    Tcf.getChannelManager().closeChannel(channel);
                }
                monitor.done();
            }
        }
    }

    void refresh(IFileSystem service) throws TCFFileSystemException {
        if (this.node != null) {
            final TCFFileSystemException[] errors = new TCFFileSystemException[1];
            String path = this.node.getLocation(true);
            service.stat(path, new IFileSystem.DoneStat(){

                public void doneStat(IToken token, IFileSystem.FileSystemException error, IFileSystem.FileAttrs attrs) {
                    if (error == null) {
                        if (OpCreate.this.node != null) {
                            OpCreate.this.node.setAttributes(attrs);
                        }
                    } else {
                        errors[0] = OpCreate.this.newTCFException(2, error);
                    }
                }
            });
            if (errors[0] != null) {
                throw errors[0];
            }
        }
    }

    void addNode(final IFileSystem service) throws TCFFileSystemException {
        if (Protocol.isDispatchThread()) {
            this.node = this.newTreeNode();
            this.folder.addChild(this.node);
        } else {
            final TCFFileSystemException[] errors = new TCFFileSystemException[1];
            Protocol.invokeAndWait((Runnable)new Runnable(){

                @Override
                public void run() {
                    try {
                        OpCreate.this.addNode(service);
                    }
                    catch (TCFFileSystemException e) {
                        errors[0] = e;
                    }
                }
            });
            if (errors[0] != null) {
                throw errors[0];
            }
        }
    }

    protected abstract FSTreeNode newTreeNode();

    protected abstract void create(IFileSystem var1) throws TCFFileSystemException;

    public FSTreeNode getNode() {
        return this.node;
    }

    @Override
    public String getName() {
        return NLS.bind((String)Messages.OpCreate_TaskName, (Object)this.name);
    }

    @Override
    public int getTotalWork() {
        return this.folder.childrenQueried ? 5 : 6;
    }
}

