/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.filesystem.core.internal.operations;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.tcf.protocol.IChannel;
import org.eclipse.tcf.protocol.IToken;
import org.eclipse.tcf.services.IFileSystem;
import org.eclipse.tcf.te.tcf.core.Tcf;
import org.eclipse.tcf.te.tcf.filesystem.core.interfaces.IConfirmCallback;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.exceptions.TCFException;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.exceptions.TCFFileSystemException;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.operations.Operation;
import org.eclipse.tcf.te.tcf.filesystem.core.model.FSTreeNode;
import org.eclipse.tcf.te.tcf.filesystem.core.nls.Messages;

public class OpMove
extends Operation {
    List<FSTreeNode> nodes;
    FSTreeNode dest;
    IConfirmCallback confirmCallback;

    public OpMove(List<FSTreeNode> nodes, FSTreeNode dest) {
        this(nodes, dest, null);
    }

    public OpMove(List<FSTreeNode> nodes, FSTreeNode dest, IConfirmCallback confirmCallback) {
        this.nodes = this.getAncestors(nodes);
        this.dest = dest;
        this.confirmCallback = confirmCallback;
    }

    @Override
    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        block8: {
            super.run(monitor);
            this.nodes.remove(this.dest);
            IChannel channel = null;
            try {
                try {
                    if (this.nodes.isEmpty()) break block8;
                    FSTreeNode head = this.nodes.get(0);
                    channel = OpMove.openChannel(head.peerNode.getPeer());
                    if (channel == null) break block8;
                    IFileSystem service = OpMove.getBlockingFileSystem(channel);
                    if (service != null) {
                        for (FSTreeNode node : this.nodes) {
                            this.moveNode(service, node, this.dest);
                        }
                        break block8;
                    }
                    String message = NLS.bind((String)Messages.Operation_NoFileSystemError, (Object)head.peerNode.getPeerId());
                    throw new TCFFileSystemException(4, message);
                }
                catch (TCFException e) {
                    throw new InvocationTargetException(e, e.getMessage());
                }
            }
            finally {
                if (channel != null) {
                    Tcf.getChannelManager().closeChannel(channel);
                }
                monitor.done();
            }
        }
    }

    void moveNode(IFileSystem service, final FSTreeNode node, FSTreeNode dest) throws TCFFileSystemException, InterruptedException {
        if (this.monitor.isCanceled()) {
            throw new InterruptedException();
        }
        this.monitor.subTask(NLS.bind((String)Messages.OpMove_Moving, (Object)node.name));
        FSTreeNode copy = this.findChild(service, dest, node.name);
        if (copy == null || !copy.equals(node) && this.confirmReplace(node, this.confirmCallback)) {
            if (copy != null && copy.isDirectory() && node.isDirectory()) {
                List<FSTreeNode> children = this.getChildren(node, service);
                for (FSTreeNode child : children) {
                    this.moveNode(service, child, copy);
                }
                this.removeFolder(node, service);
                this.monitor.worked(1);
            } else {
                if (copy != null && copy.isFile() && node.isDirectory()) {
                    String error = NLS.bind((String)Messages.OpMove_FileExistsError, (Object)copy.name);
                    throw new TCFFileSystemException(4, error);
                }
                if (copy != null && copy.isDirectory() && node.isFile()) {
                    String error = NLS.bind((String)Messages.OpMove_FolderExistsError, (Object)copy.name);
                    throw new TCFFileSystemException(4, error);
                }
                if (copy != null && copy.isFile() && node.isFile()) {
                    this.removeFile(copy, service);
                } else if (copy == null) {
                    copy = (FSTreeNode)node.clone();
                }
                this.addChild(service, dest, copy);
                String dst_path = copy.getLocation(true);
                String src_path = node.getLocation(true);
                final FSTreeNode copyNode = copy;
                final TCFFileSystemException[] errors = new TCFFileSystemException[1];
                service.rename(src_path, dst_path, new IFileSystem.DoneRename(){

                    public void doneRename(IToken token, IFileSystem.FileSystemException error) {
                        if (error != null) {
                            String message = NLS.bind((String)Messages.OpMove_CannotMove, (Object)node.name, (Object)error);
                            errors[0] = new TCFFileSystemException(4, message, (Throwable)error);
                        } else {
                            OpMove.this.cleanUpNode(node, copyNode);
                        }
                    }
                });
                if (errors[0] != null) {
                    this.removeChild(service, dest, copy);
                    throw errors[0];
                }
                this.monitor.worked(1);
            }
        }
    }

    void cleanUpNode(FSTreeNode node, FSTreeNode copyNode) {
        if (node.isFile()) {
            super.cleanUpFile(node);
        } else if (node.isDirectory()) {
            super.cleanUpFolder(node);
            List<FSTreeNode> children = node.getChildren();
            copyNode.addChidren(children);
            for (FSTreeNode child : children) {
                child.setParent(copyNode);
            }
        }
    }

    @Override
    public String getName() {
        return Messages.OpMove_MovingFile;
    }

    @Override
    public int getTotalWork() {
        return this.nodes == null ? -1 : this.nodes.size();
    }
}

