/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.filesystem.core.internal.url;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.runtime.Assert;
import org.eclipse.osgi.util.NLS;
import org.eclipse.tcf.protocol.IChannel;
import org.eclipse.tcf.protocol.IPeer;
import org.eclipse.tcf.protocol.IToken;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.services.IFileSystem;
import org.eclipse.tcf.te.tcf.core.Tcf;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.exceptions.TCFChannelException;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.operations.Operation;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.url.TcfInputStream;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.url.TcfOutputStream;
import org.eclipse.tcf.te.tcf.filesystem.core.nls.Messages;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerNode;
import org.eclipse.tcf.te.tcf.locator.interfaces.services.IPeerModelLookupService;
import org.eclipse.tcf.te.tcf.locator.model.ModelManager;

public class TcfURLConnection
extends URLConnection {
    private static final int DEFAULT_CONNECT_TIMEOUT = 5000;
    private static final int DEFAULT_OPEN_TIMEOUT = 5000;
    private static final int DEFAULT_READ_TIMEOUT = 5000;
    private static final int DEFAULT_CLOSE_TIMEOUT = 5000;
    public static final String PROTOCOL_SCHEMA = "tcf";
    private TcfInputStream inputStream;
    private TcfOutputStream outputStream;
    private IPeer peer;
    String path;
    private int openTimeout;
    private int closeTimeout;
    IChannel channel;
    IFileSystem.IFileHandle handle;
    IFileSystem service;

    public TcfURLConnection(URL url) {
        super(url);
        String peerId = url.getHost();
        Assert.isNotNull((Object)peerId);
        this.peer = this.findPeer(peerId);
        if (this.peer == null) {
            throw new IllegalArgumentException(NLS.bind((String)Messages.TcfURLConnection_NoPeerFound, (Object)peerId));
        }
        this.path = url.getPath();
        this.setConnectTimeout(5000);
        this.setOpenTimeout(5000);
        this.setReadTimeout(5000);
        this.setCloseTimeout(5000);
    }

    private IPeer findPeer(final String peerId) {
        Assert.isNotNull((Object)peerId);
        final AtomicReference peer = new AtomicReference();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                IPeerNode peerNode;
                IPeer p = (IPeer)Protocol.getLocator().getPeers().get(peerId);
                if (p == null && (peerNode = ((IPeerModelLookupService)ModelManager.getPeerModel().getService(IPeerModelLookupService.class)).lkupPeerModelById(peerId)) != null) {
                    p = peerNode.getPeer();
                }
                peer.set(p);
            }
        };
        if (Protocol.isDispatchThread()) {
            runnable.run();
        } else {
            Protocol.invokeAndWait((Runnable)runnable);
        }
        return (IPeer)peer.get();
    }

    public long getCloseTimeout() {
        return this.closeTimeout;
    }

    public void setCloseTimeout(int closeTimeout) {
        this.closeTimeout = closeTimeout;
    }

    public long getOpenTimeout() {
        return this.openTimeout;
    }

    public void setOpenTimeout(int openTimeout) {
        this.openTimeout = openTimeout;
    }

    private void openFile() throws IOException {
        if (this.peer == null) {
            throw new IOException(Messages.TcfURLConnection_NoSuchTcfAgent);
        }
        try {
            this.channel = Operation.openChannel(this.peer);
        }
        catch (TCFChannelException e) {
            throw new IOException(e.getMessage());
        }
        if (this.channel != null) {
            this.service = Operation.getBlockingFileSystem(this.channel);
            if (this.service != null) {
                final IFileSystem.FileSystemException[] errors = new IFileSystem.FileSystemException[1];
                int open_flag = 0;
                if (this.doInput) {
                    open_flag |= 1;
                }
                if (this.doOutput) {
                    open_flag |= 0x1A;
                }
                this.service.open(this.path, open_flag, null, new IFileSystem.DoneOpen(){

                    public void doneOpen(IToken token, IFileSystem.FileSystemException error, IFileSystem.IFileHandle hdl) {
                        errors[0] = error;
                        TcfURLConnection.this.handle = hdl;
                    }
                });
                if (errors[0] != null) {
                    IOException exception = new IOException(errors[0].toString());
                    exception.initCause((Throwable)errors[0]);
                    throw exception;
                }
                if (this.handle == null) {
                    throw new IOException(Messages.TcfURLConnection_NoFileHandleReturned);
                }
            } else {
                throw new IOException(Messages.Operation_NoFileSystemError);
            }
        }
    }

    @Override
    public void connect() throws IOException {
        if (!this.connected) {
            this.openFile();
            if (this.doInput) {
                this.inputStream = new TcfInputStream(this);
            }
            if (this.doOutput) {
                this.outputStream = new TcfOutputStream(this);
            }
            this.connected = true;
        }
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (!this.connected) {
            this.connect();
        }
        return this.inputStream;
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        if (!this.connected) {
            this.connect();
        }
        return this.outputStream;
    }

    public synchronized void closeStream(Closeable stream) throws IOException {
        boolean shouldClose = this.shouldCloseFileHandle(stream);
        if (shouldClose) {
            this.service.close(this.handle, new IFileSystem.DoneClose(){

                public void doneClose(IToken token, IFileSystem.FileSystemException error) {
                    Tcf.getChannelManager().closeChannel(TcfURLConnection.this.channel);
                }
            });
        }
    }

    private boolean shouldCloseFileHandle(Closeable stream) {
        boolean shouldClose = false;
        if (stream == this.inputStream) {
            if (this.doOutput) {
                if (this.outputStream.closed) {
                    shouldClose = true;
                }
            } else {
                shouldClose = true;
            }
        } else if (stream == this.outputStream) {
            if (this.doInput) {
                if (this.inputStream.closed) {
                    shouldClose = true;
                }
            } else {
                shouldClose = true;
            }
        }
        return shouldClose;
    }
}

