/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.filesystem.core.model;

import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.runtime.Assert;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.te.core.interfaces.IConnectable;
import org.eclipse.tcf.te.runtime.model.ContainerModelNode;
import org.eclipse.tcf.te.runtime.model.factory.Factory;
import org.eclipse.tcf.te.runtime.model.interfaces.factory.IFactory;
import org.eclipse.tcf.te.tcf.core.model.interfaces.services.IModelService;
import org.eclipse.tcf.te.tcf.filesystem.core.interfaces.runtime.IRuntimeModel;
import org.eclipse.tcf.te.tcf.filesystem.core.model.FSTreeNode;
import org.eclipse.tcf.te.tcf.filesystem.core.nls.Messages;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerNode;

public final class RuntimeModel
extends ContainerModelNode
implements IRuntimeModel {
    private boolean disposed = false;
    private IFactory factory = null;
    private FSTreeNode root;
    private IPeerNode peerNode;

    public RuntimeModel(IPeerNode peerNode) {
        this.peerNode = peerNode;
    }

    protected boolean checkThreadAccess() {
        return Protocol.isDispatchThread();
    }

    public void dispose() {
        Assert.isTrue((boolean)this.checkThreadAccess(), (String)"Illegal Thread Access");
        this.disposed = true;
    }

    public boolean isDisposed() {
        Assert.isTrue((boolean)this.checkThreadAccess(), (String)"Illegal Thread Access");
        return this.disposed;
    }

    public <V extends IModelService> V getService(Class<V> serviceInterface) {
        Assert.isNotNull(serviceInterface);
        return (V)((IModelService)this.getAdapter(serviceInterface));
    }

    public Object getAdapter(Class adapter) {
        if (IPeerNode.class.isAssignableFrom(adapter) || IConnectable.class.isAssignableFrom(adapter)) {
            final AtomicReference peerNode = new AtomicReference();
            Protocol.invokeAndWait((Runnable)new Runnable(){

                @Override
                public void run() {
                    peerNode.set(RuntimeModel.this.getPeerNode());
                }
            });
            return peerNode.get();
        }
        return super.getAdapter(adapter);
    }

    public void setFactory(IFactory factory) {
        Assert.isTrue((boolean)this.checkThreadAccess(), (String)"Illegal Thread Access");
        this.factory = factory;
    }

    public IFactory getFactory() {
        Assert.isTrue((boolean)this.checkThreadAccess(), (String)"Illegal Thread Access");
        return this.factory != null ? this.factory : Factory.getInstance();
    }

    public IPeerNode getPeerNode() {
        Assert.isTrue((boolean)this.checkThreadAccess(), (String)"Illegal Thread Access");
        return this.peerNode;
    }

    public String toString() {
        if (this.disposed) {
            return "*DISPOSED* : " + super.toString();
        }
        return super.toString();
    }

    @Override
    public FSTreeNode getRoot() {
        if (this.root == null) {
            this.root = this.createRoot();
        }
        return this.root;
    }

    FSTreeNode createRoot() {
        if (Protocol.isDispatchThread()) {
            return RuntimeModel.createRootNode(this.peerNode);
        }
        final AtomicReference ref = new AtomicReference();
        Protocol.invokeAndWait((Runnable)new Runnable(){

            @Override
            public void run() {
                ref.set(RuntimeModel.this.createRoot());
            }
        });
        return (FSTreeNode)ref.get();
    }

    public static FSTreeNode createRootNode(IPeerNode peerNode) {
        FSTreeNode node = new FSTreeNode();
        node.type = "FSRootNode";
        node.peerNode = peerNode;
        node.name = Messages.FSTreeNodeContentProvider_rootNode_label;
        return node;
    }

    public static FSTreeNode createFileNode(String name, FSTreeNode folder) {
        return RuntimeModel.createTreeNode(name, "FSFileNode", folder);
    }

    public static FSTreeNode createFolderNode(String name, FSTreeNode folder) {
        return RuntimeModel.createTreeNode(name, "FSDirNode", folder);
    }

    private static FSTreeNode createTreeNode(String name, String type, FSTreeNode folder) {
        FSTreeNode node = new FSTreeNode();
        node.name = name;
        node.parent = folder;
        node.peerNode = folder.peerNode;
        node.type = type;
        return node;
    }
}

