/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.filesystem.ui.controls;

import java.util.ArrayList;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.tcf.te.tcf.filesystem.core.interfaces.runtime.IRuntimeModel;
import org.eclipse.tcf.te.tcf.filesystem.core.model.AbstractTreeNode;
import org.eclipse.tcf.te.tcf.filesystem.core.model.FSTreeNode;
import org.eclipse.tcf.te.tcf.filesystem.core.model.ModelManager;
import org.eclipse.tcf.te.tcf.filesystem.ui.controls.TreeContentProvider;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerNode;
import org.eclipse.tcf.te.ui.trees.Pending;

public abstract class NavigatorContentProvider
extends TreeContentProvider
implements ITreeViewerListener {
    public Object getParent(Object element) {
        if (element instanceof AbstractTreeNode) {
            AbstractTreeNode node = (AbstractTreeNode)element;
            AbstractTreeNode parent = node.getParent();
            if (parent != null) {
                if (parent.isSystemRoot()) {
                    if (this.isRootNodeVisible()) {
                        return parent;
                    }
                    return null;
                }
                return parent;
            }
            if (this.isRootNodeVisible()) {
                return node.peerNode;
            }
        }
        return null;
    }

    public void treeCollapsed(TreeExpansionEvent event) {
    }

    public void treeExpanded(TreeExpansionEvent event) {
        Object object = event.getElement();
        if (object instanceof AbstractTreeNode) {
            AbstractTreeNode parent = (AbstractTreeNode)object;
            if (parent.childrenQueried && !parent.childrenQueryRunning) {
                parent.refreshChildren();
            }
        }
    }

    @Override
    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        super.inputChanged(viewer, oldInput, newInput);
        this.viewer.addTreeListener((ITreeViewerListener)this);
    }

    @Override
    public void dispose() {
        this.viewer.removeTreeListener((ITreeViewerListener)this);
        super.dispose();
    }

    @Override
    public Object[] getChildren(Object parentElement) {
        super.getChildren(parentElement);
        if (parentElement instanceof IPeerNode) {
            IPeerNode peerNode = (IPeerNode)parentElement;
            IRuntimeModel model = ModelManager.getRuntimeModel((IPeerNode)peerNode);
            if (this.isRootNodeVisible()) {
                FSTreeNode root = model.getRoot();
                if (!root.childrenQueried && !root.childrenQueryRunning) {
                    root.queryChildren();
                }
                return new Object[]{root};
            }
            return this.getChildren(model.getRoot());
        }
        if (parentElement instanceof AbstractTreeNode) {
            AbstractTreeNode node = (AbstractTreeNode)parentElement;
            ArrayList<Pending> current = new ArrayList<Pending>(node.getChildren());
            if (!node.childrenQueried) {
                current.add(this.getPending(node));
                if (!node.childrenQueryRunning) {
                    node.queryChildren();
                }
            }
            return current.toArray();
        }
        return NO_ELEMENTS;
    }

    @Override
    public boolean hasChildren(Object element) {
        Assert.isNotNull((Object)element);
        boolean hasChildren = false;
        if (element instanceof AbstractTreeNode) {
            AbstractTreeNode node = (AbstractTreeNode)element;
            hasChildren = node.isSystemRoot() ? true : !node.childrenQueried || super.hasChildren(element);
        } else if (element instanceof IPeerNode) {
            IPeerNode peerNode = (IPeerNode)element;
            IRuntimeModel model = ModelManager.getRuntimeModel((IPeerNode)peerNode);
            FSTreeNode root = model.getRoot();
            hasChildren = root != null ? this.hasChildren(root) : true;
        }
        return hasChildren;
    }

    protected boolean isRootNodeVisible() {
        return true;
    }
}

