/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.filesystem.ui.controls;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.tcf.te.core.interfaces.IPropertyChangeProvider;
import org.eclipse.tcf.te.ui.trees.CommonViewerListener;
import org.eclipse.tcf.te.ui.trees.Pending;

public abstract class TreeContentProvider
implements ITreeContentProvider,
PropertyChangeListener {
    protected static final Object[] NO_ELEMENTS = new Object[0];
    protected CommonViewerListener commonViewerListener;
    private Set<IPropertyChangeProvider> providers = Collections.synchronizedSet(new HashSet());
    protected TreeViewer viewer;
    private Map<Object, Pending> pendings = new HashMap<Object, Pending>();

    protected Pending getPending(Object parent) {
        Pending pending = this.pendings.get(parent);
        if (pending == null && this.viewer != null) {
            pending = new Pending(this.viewer);
            this.pendings.put(parent, pending);
        }
        return pending;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
    }

    public void dispose() {
        for (IPropertyChangeProvider provider : this.providers) {
            provider.removePropertyChangeListener((PropertyChangeListener)this.commonViewerListener);
            provider.removePropertyChangeListener((PropertyChangeListener)this);
        }
        this.commonViewerListener.cancel();
        this.providers.clear();
        this.pendings.clear();
    }

    private Object[] getFilteredChildren(Object parent) {
        ViewerFilter[] filters;
        Object[] result = this.getChildren(parent);
        if (this.viewer != null && (filters = this.viewer.getFilters()) != null) {
            ViewerFilter[] viewerFilterArray = filters;
            int n = filters.length;
            int n2 = 0;
            while (n2 < n) {
                ViewerFilter filter = viewerFilterArray[n2];
                Object[] filteredResult = filter.filter((Viewer)this.viewer, parent, result);
                result = filteredResult;
                ++n2;
            }
        }
        return result;
    }

    public Object[] getChildren(Object parentElement) {
        IAdaptable adaptable;
        IPropertyChangeProvider provider;
        Assert.isNotNull((Object)parentElement);
        if (parentElement instanceof IAdaptable && (provider = (IPropertyChangeProvider)(adaptable = (IAdaptable)parentElement).getAdapter(IPropertyChangeProvider.class)) != null) {
            this.installPropertyChangeListener(provider);
        }
        return NO_ELEMENTS;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        Assert.isTrue((boolean)(viewer instanceof TreeViewer));
        this.viewer = (TreeViewer)viewer;
        this.commonViewerListener = new CommonViewerListener(this.viewer, (ITreeContentProvider)this);
    }

    private void installPropertyChangeListener(IPropertyChangeProvider provider) {
        if (provider != null && !this.providers.contains(provider) && this.commonViewerListener != null) {
            provider.addPropertyChangeListener((PropertyChangeListener)this.commonViewerListener);
            provider.addPropertyChangeListener((PropertyChangeListener)this);
            this.providers.add(provider);
        }
    }

    public boolean hasChildren(Object element) {
        Object[] children = this.getFilteredChildren(element);
        return children != null && children.length > 0;
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }
}

