/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.filesystem.ui.dialogs;

import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tcf.te.runtime.callback.Callback;
import org.eclipse.tcf.te.runtime.interfaces.callback.ICallback;
import org.eclipse.tcf.te.tcf.filesystem.core.model.AbstractTreeNode;
import org.eclipse.tcf.te.tcf.filesystem.core.model.FSTreeNode;
import org.eclipse.tcf.te.tcf.filesystem.core.model.ModelManager;
import org.eclipse.tcf.te.tcf.filesystem.ui.activator.UIPlugin;
import org.eclipse.tcf.te.tcf.filesystem.ui.controls.FSTreeContentProvider;
import org.eclipse.tcf.te.tcf.filesystem.ui.controls.FSTreeViewerSorter;
import org.eclipse.tcf.te.tcf.filesystem.ui.interfaces.IFSConstants;
import org.eclipse.tcf.te.tcf.filesystem.ui.internal.columns.FSTreeElementLabelProvider;
import org.eclipse.tcf.te.tcf.filesystem.ui.nls.Messages;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerNode;
import org.eclipse.tcf.te.ui.trees.FilterDescriptor;
import org.eclipse.tcf.te.ui.trees.ViewerStateManager;
import org.eclipse.ui.IDecoratorManager;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;

public class FSFolderSelectionDialog
extends ElementTreeSelectionDialog {
    private List<FSTreeNode> movedNodes;
    private final int mode;
    public static final int MODE_ALL = 0;
    public static final int MODE_ALL_WARNING_NOT_WRITABLE = 1;
    public static final int MODE_ONLY_WRITABLE = 2;
    private static final IStatus ok = new Status(0, UIPlugin.getUniqueIdentifier(), null);
    private static final IStatus error = new Status(4, UIPlugin.getUniqueIdentifier(), null);
    private static final IStatus errorNotWritable = new Status(4, UIPlugin.getUniqueIdentifier(), Messages.FSFolderSelectionDialog_notWritable_error);
    private static final IStatus warningNotWritable = new Status(2, UIPlugin.getUniqueIdentifier(), Messages.FSFolderSelectionDialog_notWritable_warning);

    public FSFolderSelectionDialog(Shell parentShell) {
        this(parentShell, 2);
    }

    public FSFolderSelectionDialog(Shell parentShell, int mode) {
        this(parentShell, (ILabelProvider)new FSTreeElementLabelProvider(), new FSTreeContentProvider(), mode);
    }

    private FSFolderSelectionDialog(Shell parentShell, ILabelProvider labelProvider, ITreeContentProvider contentProvider, int mode) {
        super(parentShell, FSFolderSelectionDialog.createDecoratingLabelProvider(labelProvider), contentProvider);
        this.mode = mode;
        this.setTitle(Messages.FSFolderSelectionDialog_MoveDialogTitle);
        this.setMessage(Messages.FSFolderSelectionDialog_MoveDialogMessage);
        this.setAllowMultiple(false);
        this.setComparator((ViewerComparator)new FSTreeViewerSorter());
        this.addFilter(new DirectoryFilter());
        this.setStatusLineAboveButtons(true);
        this.setValidator(new ISelectionStatusValidator(){

            public IStatus validate(Object[] selection) {
                return FSFolderSelectionDialog.this.isValidFolder(selection);
            }
        });
    }

    public void setInput(Object input) {
        super.setInput(input);
        FilterDescriptor[] filterDescriptors = ViewerStateManager.getInstance().getFilterDescriptors(IFSConstants.ID_TREE_VIEWER_FS, input);
        Assert.isNotNull((Object)filterDescriptors);
        FilterDescriptor[] filterDescriptorArray = filterDescriptors;
        int n = filterDescriptors.length;
        int n2 = 0;
        while (n2 < n) {
            FilterDescriptor descriptor = filterDescriptorArray[n2];
            if (descriptor.isEnabled()) {
                this.addFilter(descriptor.getFilter());
            }
            ++n2;
        }
    }

    private static ILabelProvider createDecoratingLabelProvider(ILabelProvider labelProvider) {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IDecoratorManager manager = workbench.getDecoratorManager();
        ILabelDecorator decorator = manager.getLabelDecorator();
        return new DecoratingLabelProvider(labelProvider, decorator);
    }

    public void setMovedNodes(List<FSTreeNode> movedNodes) {
        this.movedNodes = movedNodes;
    }

    public TreeViewer getTreeViewer() {
        return super.getTreeViewer();
    }

    protected TreeViewer doCreateTreeViewer(Composite parent, int style) {
        TreeViewer viewer = super.doCreateTreeViewer(parent, style);
        Button refreshAll = new Button(parent, 8);
        refreshAll.setText(Messages.FSFolderSelectionDialog_RefreshAll_menu);
        refreshAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FSFolderSelectionDialog.this.refreshModel();
            }
        });
        viewer.getTree().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 0x100000E) {
                    FSFolderSelectionDialog.this.refresh();
                }
            }
        });
        viewer.getTree().setLinesVisible(false);
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                Action action = new Action(Messages.FSFolderSelectionDialog_Refresh_menu, UIPlugin.getImageDescriptor("RefreshImage")){

                    public void run() {
                        FSFolderSelectionDialog.this.refresh();
                    }
                };
                action.setAccelerator(0x100000E);
                manager.add((IAction)action);
            }
        });
        Menu menu = menuMgr.createContextMenu(viewer.getControl());
        viewer.getControl().setMenu(menu);
        return viewer;
    }

    public void refresh() {
        ISelection sel = this.getTreeViewer().getSelection();
        if (sel instanceof IStructuredSelection && !sel.isEmpty()) {
            for (Object node : (IStructuredSelection)sel) {
                if (node instanceof FSTreeNode) {
                    this.refreshNode((FSTreeNode)node);
                    continue;
                }
                this.refreshModel();
                return;
            }
        } else {
            this.refreshModel();
        }
    }

    protected void refreshNode(final FSTreeNode treeNode) {
        if (!treeNode.childrenQueryRunning) {
            treeNode.childrenQueried = false;
            treeNode.clearChildren();
            treeNode.refresh((ICallback)new Callback(){

                protected void internalDone(Object caller, IStatus status) {
                    FSFolderSelectionDialog.this.getShell().getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            FSFolderSelectionDialog.this.getTreeViewer().refresh((Object)treeNode, true);
                            FSFolderSelectionDialog.this.getTreeViewer().setSelection(FSFolderSelectionDialog.this.getTreeViewer().getSelection());
                        }
                    });
                }
            });
        }
    }

    protected void refreshModel() {
        Object input = this.getTreeViewer().getInput();
        if (input instanceof IPeerNode) {
            this.refreshNode(ModelManager.getRuntimeModel((IPeerNode)((IPeerNode)input)).getRoot());
        }
    }

    IStatus isValidFolder(Object[] selection) {
        if (selection == null || selection.length == 0) {
            return error;
        }
        if (!(selection[0] instanceof FSTreeNode)) {
            return error;
        }
        FSTreeNode target = (FSTreeNode)selection[0];
        if (this.movedNodes != null) {
            for (FSTreeNode node : this.movedNodes) {
                if (node != target && !node.isAncestorOf((AbstractTreeNode)target)) continue;
                return error;
            }
        }
        if (this.mode != 0 && !target.isWritable()) {
            if (target.attr == null) {
                this.refreshNode(target);
            }
            return this.mode == 2 ? errorNotWritable : warningNotWritable;
        }
        return ok;
    }

    static class DirectoryFilter
    extends ViewerFilter {
        DirectoryFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            FSTreeNode node;
            return !(element instanceof FSTreeNode) || !(node = (FSTreeNode)element).isFile();
        }
    }
}

