/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.filesystem.ui.internal.dnd;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tcf.te.runtime.callback.Callback;
import org.eclipse.tcf.te.runtime.interfaces.callback.ICallback;
import org.eclipse.tcf.te.tcf.filesystem.core.interfaces.IConfirmCallback;
import org.eclipse.tcf.te.tcf.filesystem.core.interfaces.IOperation;
import org.eclipse.tcf.te.tcf.filesystem.core.interfaces.runtime.IRuntimeModel;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.operations.JobExecutor;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.operations.OpCopy;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.operations.OpMove;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.operations.OpRefresh;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.operations.OpUpload;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.utils.CacheManager;
import org.eclipse.tcf.te.tcf.filesystem.core.model.AbstractTreeNode;
import org.eclipse.tcf.te.tcf.filesystem.core.model.FSTreeNode;
import org.eclipse.tcf.te.tcf.filesystem.core.model.ModelManager;
import org.eclipse.tcf.te.tcf.filesystem.ui.activator.UIPlugin;
import org.eclipse.tcf.te.tcf.filesystem.ui.internal.handlers.MoveCopyCallback;
import org.eclipse.tcf.te.tcf.filesystem.ui.internal.operations.UiExecutor;
import org.eclipse.tcf.te.tcf.filesystem.ui.nls.Messages;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerNode;
import org.eclipse.ui.PlatformUI;

public class CommonDnD
implements IConfirmCallback {
    public boolean isDraggable(IStructuredSelection selection) {
        Object[] objects;
        if (selection.isEmpty()) {
            return false;
        }
        Object[] objectArray = objects = selection.toArray();
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            if (!this.isDraggableObject(object)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private boolean isDraggableObject(Object object) {
        if (object instanceof FSTreeNode) {
            FSTreeNode node = (FSTreeNode)object;
            return !node.isRoot() && (node.isWindowsNode() && !node.isReadOnly() || !node.isWindowsNode() && node.isWritable());
        }
        return false;
    }

    public boolean dropFiles(TreeViewer viewer, String[] files, int operations, FSTreeNode target) {
        UiExecutor executor = null;
        if ((operations & 2) != 0) {
            String question = files.length == 1 ? NLS.bind((String)Messages.FSDropTargetListener_MovingWarningSingle, (Object)files[0]) : NLS.bind((String)Messages.FSDropTargetListener_MovingWarningMultiple, (Object)files.length);
            Shell parent = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            if (MessageDialog.openQuestion((Shell)parent, (String)Messages.FSDropTargetListener_ConfirmMoveTitle, (String)question)) {
                ICallback callback = this.getMoveCallback(viewer, files, target);
                executor = new UiExecutor(callback);
            }
        } else if ((operations & 1) != 0) {
            ICallback callback = this.getCopyCallback(viewer, files, target);
            executor = new UiExecutor(callback);
        }
        if (executor != null) {
            IStatus status = executor.execute((IOperation)new OpUpload(files, target, (IConfirmCallback)this));
            return status != null && status.isOK();
        }
        return false;
    }

    private ICallback getCopyCallback(final TreeViewer viewer, final String[] files, final FSTreeNode target) {
        return new Callback(){

            protected void internalDone(Object caller, IStatus status) {
                if (status.isOK()) {
                    JobExecutor executor = new JobExecutor(CommonDnD.this.getSelectionCallback(viewer, files, target));
                    executor.execute((IOperation)new OpRefresh(target));
                }
            }
        };
    }

    private ICallback getMoveCallback(final TreeViewer viewer, final String[] files, final FSTreeNode target) {
        return new Callback(){

            protected void internalDone(Object caller, IStatus status) {
                if (status.isOK()) {
                    boolean successful = true;
                    String[] stringArray = files;
                    int n = files.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String path = stringArray[n2];
                        File file = new File(path);
                        successful &= file.delete();
                        ++n2;
                    }
                    if (successful) {
                        IRuntimeModel model = ModelManager.getRuntimeModel((IPeerNode)target.peerNode);
                        JobExecutor executor = new JobExecutor(CommonDnD.this.getSelectionCallback(viewer, files, target));
                        executor.execute((IOperation)new OpRefresh(model.getRoot()));
                    }
                }
            }
        };
    }

    ICallback getSelectionCallback(final TreeViewer viewer, final String[] paths, final FSTreeNode target) {
        return new Callback(){

            protected void internalDone(Object caller, IStatus status) {
                if (status.isOK()) {
                    ArrayList<FSTreeNode> nodes = new ArrayList<FSTreeNode>();
                    List children = target.getChildren();
                    String[] stringArray = paths;
                    int n = paths.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String path = stringArray[n2];
                        File file = new File(path);
                        String name = file.getName();
                        for (FSTreeNode child : children) {
                            if (!name.equals(child.name)) continue;
                            nodes.add(child);
                            break;
                        }
                        ++n2;
                    }
                    if (viewer != null) {
                        CommonDnD.this.updateViewer(viewer, target, nodes);
                    }
                }
            }
        };
    }

    protected void updateViewer(final TreeViewer viewer, final FSTreeNode target, final List<FSTreeNode> nodes) {
        if (Display.getCurrent() != null) {
            viewer.refresh((Object)target);
            StructuredSelection selection = new StructuredSelection(nodes.toArray());
            viewer.setSelection((ISelection)selection, true);
        } else {
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    CommonDnD.this.updateViewer(viewer, target, nodes);
                }
            });
        }
    }

    public boolean dropLocalSelection(FSTreeNode target, int operations, IStructuredSelection selection) {
        List nodes = selection.toList();
        UiExecutor executor = null;
        OpMove operation = null;
        if ((operations & 2) != 0) {
            operation = new OpMove(nodes, target, (IConfirmCallback)new MoveCopyCallback());
            executor = new UiExecutor((ICallback)new Callback(){

                protected void internalDone(Object caller, IStatus status) {
                    UIPlugin.getClipboard().clear();
                }
            });
        } else if ((operations & 1) != 0) {
            FSTreeNode dest = this.getCopyDestination(target, nodes);
            boolean cpPerm = UIPlugin.isCopyPermission();
            boolean cpOwn = UIPlugin.isCopyOwnership();
            operation = new OpCopy(nodes, dest, cpPerm, cpOwn, (IConfirmCallback)new MoveCopyCallback());
            executor = new UiExecutor();
        }
        if (operation != null && executor != null) {
            IStatus status = executor.execute((IOperation)operation);
            return status != null && status.isOK();
        }
        return false;
    }

    private FSTreeNode getCopyDestination(FSTreeNode hovered, List<FSTreeNode> nodes) {
        if (hovered.isFile()) {
            return hovered.getParent();
        }
        if (hovered.isDirectory()) {
            for (FSTreeNode node : nodes) {
                if (node != hovered) continue;
                return hovered.getParent();
            }
        }
        return hovered;
    }

    public boolean validateFilesDrop(Object target, int operation, TransferData transferType) {
        FileTransfer transfer = FileTransfer.getInstance();
        String[] elements = (String[])transfer.nativeToJava(transferType);
        if (elements.length > 0) {
            boolean moving = (operation & 2) != 0;
            boolean copying = (operation & 1) != 0;
            FSTreeNode hovered = (FSTreeNode)target;
            if (hovered.isFile() && copying) {
                hovered = hovered.getParent();
            }
            return hovered.isDirectory() && hovered.isWritable() && (moving || copying);
        }
        return false;
    }

    public boolean validateLocalSelectionDrop(Object target, int operation, TransferData transferType) {
        boolean copying;
        FSTreeNode hovered = (FSTreeNode)target;
        LocalSelectionTransfer transfer = LocalSelectionTransfer.getTransfer();
        IStructuredSelection selection = (IStructuredSelection)transfer.getSelection();
        List nodes = selection.toList();
        boolean moving = (operation & 2) != 0;
        boolean bl = copying = (operation & 1) != 0;
        if (hovered.isDirectory() && hovered.isWritable() && (moving || copying)) {
            String tid;
            FSTreeNode head = (FSTreeNode)nodes.get(0);
            String hid = head.peerNode.getPeerId();
            if (hid.equals(tid = hovered.peerNode.getPeerId())) {
                for (FSTreeNode node : nodes) {
                    if ((!moving || node != hovered) && !node.isAncestorOf((AbstractTreeNode)hovered)) continue;
                    return false;
                }
                return true;
            }
        } else if (hovered.isFile() && copying) {
            hovered = hovered.getParent();
            return this.validateLocalSelectionDrop(hovered, operation, transferType);
        }
        return false;
    }

    public boolean requires(Object object) {
        return true;
    }

    public int confirms(Object object) {
        final int[] results = new int[1];
        final File file = (File)object;
        Display display = PlatformUI.getWorkbench().getDisplay();
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                Shell parent = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                String title = Messages.FSUpload_OverwriteTitle;
                String message = NLS.bind((String)Messages.FSUpload_OverwriteConfirmation, (Object)file.getName());
                final Image titleImage = UIPlugin.getImage("ConfirmReadOnlyDelete");
                MessageDialog qDialog = new MessageDialog(parent, title, null, message, 3, new String[]{Messages.FSUpload_Yes, Messages.FSUpload_YesToAll, Messages.FSUpload_No, Messages.FSUpload_Cancel}, 0){

                    public Image getQuestionImage() {
                        return titleImage;
                    }
                };
                results[0] = qDialog.open();
            }
        });
        return results[0];
    }

    public boolean setDragData(DragSourceEvent anEvent) {
        if (LocalSelectionTransfer.getTransfer().isSupportedType(anEvent.dataType)) {
            anEvent.data = LocalSelectionTransfer.getTransfer().getSelection();
            return true;
        }
        if (FileTransfer.getInstance().isSupportedType(anEvent.dataType)) {
            IStructuredSelection selection = (IStructuredSelection)LocalSelectionTransfer.getTransfer().getSelection();
            List nodes = selection.toList();
            ArrayList<String> paths = new ArrayList<String>();
            for (FSTreeNode node : nodes) {
                File file = CacheManager.getCacheFile((FSTreeNode)node);
                if (!file.exists()) continue;
                paths.add(file.getAbsolutePath());
            }
            if (!paths.isEmpty()) {
                anEvent.data = paths.toArray(new String[paths.size()]);
            }
            return !paths.isEmpty();
        }
        return false;
    }
}

