/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.filesystem.ui.internal.handlers;

import java.io.File;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tcf.te.runtime.callback.Callback;
import org.eclipse.tcf.te.runtime.interfaces.callback.ICallback;
import org.eclipse.tcf.te.tcf.filesystem.core.interfaces.IOperation;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.operations.OpCacheUpdate;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.utils.CacheManager;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.utils.ContentTypeHelper;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.utils.PersistenceManager;
import org.eclipse.tcf.te.tcf.filesystem.core.model.CacheState;
import org.eclipse.tcf.te.tcf.filesystem.core.model.FSTreeNode;
import org.eclipse.tcf.te.tcf.filesystem.ui.activator.UIPlugin;
import org.eclipse.tcf.te.tcf.filesystem.ui.internal.operations.UiExecutor;
import org.eclipse.tcf.te.tcf.filesystem.ui.nls.Messages;
import org.eclipse.tcf.te.ui.swt.DisplayUtil;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.ide.IDE;

public class OpenFileHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IStructuredSelection selection = (IStructuredSelection)HandlerUtil.getCurrentSelectionChecked((ExecutionEvent)event);
        final FSTreeNode node = (FSTreeNode)selection.getFirstElement();
        final IWorkbenchPage page = HandlerUtil.getActiveSite((ExecutionEvent)event).getPage();
        if (ContentTypeHelper.isBinaryFile((FSTreeNode)node)) {
            Shell parent = HandlerUtil.getActiveShell((ExecutionEvent)event);
            MessageDialog.openWarning((Shell)parent, (String)Messages.OpenFileHandler_Warning, (String)Messages.OpenFileHandler_OpeningBinaryNotSupported);
        } else if (UIPlugin.isAutoSaving()) {
            node.refresh((ICallback)new Callback(){

                protected void internalDone(Object caller, IStatus status) {
                    File file = CacheManager.getCacheFile((FSTreeNode)node);
                    if (node.getCacheState() == CacheState.outdated) {
                        file.delete();
                    }
                    DisplayUtil.safeAsyncExec((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            OpenFileHandler.this.openFile(node, page);
                        }
                    });
                }
            });
        } else {
            this.openFile(node, page);
        }
        return null;
    }

    void openFile(FSTreeNode node, IWorkbenchPage page) {
        File file = CacheManager.getCacheFile((FSTreeNode)node);
        if (!file.exists()) {
            UiExecutor executor = new UiExecutor();
            IStatus status = executor.execute((IOperation)new OpCacheUpdate(new FSTreeNode[]{node}));
            if (!status.isOK()) {
                return;
            }
        }
        this.openEditor(page, node);
    }

    private void openEditor(final IWorkbenchPage page, final FSTreeNode node) {
        Display display = page.getWorkbenchWindow().getWorkbench().getDisplay();
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                IPath path = CacheManager.getCachePath((FSTreeNode)node);
                IFileStore fileStore = EFS.getLocalFileSystem().getStore(path);
                String editorID = (String)PersistenceManager.getInstance().getPersistentProperties(node).get(IDE.EDITOR_KEY);
                try {
                    if (editorID != null) {
                        FileStoreEditorInput input = new FileStoreEditorInput(fileStore);
                        page.openEditor((IEditorInput)input, editorID, true, 3);
                    } else {
                        IDE.openEditorOnFileStore((IWorkbenchPage)page, (IFileStore)fileStore);
                    }
                }
                catch (PartInitException partInitException) {}
            }
        });
    }
}

