/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.launch.cdt.controls;

import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.tcf.te.tcf.launch.cdt.activator.Activator;
import org.eclipse.tcf.te.tcf.launch.cdt.nls.Messages;
import org.eclipse.tcf.te.tcf.launch.cdt.utils.TEHelper;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerNode;
import org.eclipse.tcf.te.tcf.locator.model.ModelManager;

public class TCFPeerSelector {
    protected Combo combo;
    protected Label label;
    protected IPeerNode[] peers = null;
    private Composite composite;

    public TCFPeerSelector(Composite parent, int style, int numberOfColumns) {
        this.composite = new Composite(parent, style);
        GridLayout layout = new GridLayout(numberOfColumns, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.composite.setLayout((Layout)layout);
        this.label = new Label(this.composite, 0);
        this.label.setText(Messages.TCFPeerSelector_0);
        this.label.setLayoutData((Object)new GridData(1));
        this.combo = new Combo(this.composite, 12);
        this.combo.setLayoutData((Object)new GridData(768));
        this.refreshCombo();
    }

    public void setEnabled(boolean enabled) {
        this.composite.setEnabled(enabled);
        this.label.setEnabled(enabled);
        this.combo.setEnabled(enabled);
    }

    public boolean isDisposed() {
        return this.composite == null || this.composite.isDisposed();
    }

    public void setLayoutData(Object layoutData) {
        if (this.composite != null) {
            this.composite.setLayoutData(layoutData);
        }
    }

    public void addSelectionListener(SelectionListener listener) {
        this.combo.addSelectionListener(listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.combo.removeSelectionListener(listener);
    }

    public void addModifyListener(ModifyListener listener) {
        this.combo.addModifyListener(listener);
    }

    public void removeModifyListener(ModifyListener listener) {
        this.combo.removeModifyListener(listener);
    }

    public IPeerNode getPeerNode() {
        String peerId = this.getPeerId();
        return TEHelper.getPeerNode(peerId);
    }

    public String getPeerId() {
        int selectionIndex;
        if (this.peers != null && !this.combo.isDisposed() && (selectionIndex = this.combo.getSelectionIndex()) >= 0 && selectionIndex < this.peers.length) {
            return this.combo.getItem(selectionIndex);
        }
        return null;
    }

    public void updateSelectionFrom(IPeerNode peerNode) {
        int newSelectedIndex = -1;
        String[] peerIds = this.combo.getItems();
        int i = 0;
        while (i < peerIds.length) {
            if (peerIds[i].equals(peerNode.getPeerId())) {
                newSelectedIndex = i;
                break;
            }
            ++i;
        }
        if (newSelectedIndex >= 0) {
            this.combo.select(newSelectedIndex);
        }
    }

    public void updateSelectionFrom(String peerId) {
        int newSelectedIndex = -1;
        String[] peerIds = this.combo.getItems();
        int i = 0;
        while (i < peerIds.length) {
            if (peerIds[i].equals(peerId)) {
                newSelectedIndex = i;
                break;
            }
            ++i;
        }
        if (newSelectedIndex >= 0) {
            this.combo.select(newSelectedIndex);
        }
    }

    protected void refreshCombo() {
        Activator.getDefault().initializeTE();
        this.peers = ModelManager.getPeerModel().getPeerNodes();
        int newSelectedIndex = 0;
        int i = 0;
        while (i < this.peers.length) {
            this.combo.add(this.peers[i].getPeerId());
            ++i;
        }
        this.combo.select(newSelectedIndex);
    }
}

