/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.launch.cdt.launching;

import java.util.concurrent.RejectedExecutionException;
import org.eclipse.cdt.dsf.concurrent.DsfRunnable;
import org.eclipse.cdt.dsf.concurrent.ImmediateRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.gdb.launching.GdbLaunch;
import org.eclipse.cdt.dsf.gdb.launching.GdbLaunchDelegate;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.tcf.protocol.IPeer;
import org.eclipse.tcf.te.runtime.callback.Callback;
import org.eclipse.tcf.te.runtime.interfaces.callback.ICallback;
import org.eclipse.tcf.te.tcf.core.streams.StreamsDataReceiver;
import org.eclipse.tcf.te.tcf.launch.cdt.activator.Activator;
import org.eclipse.tcf.te.tcf.launch.cdt.interfaces.IRemoteTEConfigurationConstants;
import org.eclipse.tcf.te.tcf.launch.cdt.nls.Messages;
import org.eclipse.tcf.te.tcf.launch.cdt.utils.TEHelper;

public class TEGdbLaunchDelegate
extends GdbLaunchDelegate {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void launch(ILaunchConfiguration config, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        IPath exePath = this.checkBinaryDetails(config);
        if (exePath == null) return;
        if (!(launch instanceof GdbLaunch)) return;
        Activator.getDefault().initializeTE();
        IPeer peer = TEHelper.getCurrentConnection(config).getPeer();
        String remoteExePath = config.getAttribute(IRemoteTEConfigurationConstants.ATTR_REMOTE_PATH, "");
        monitor.setTaskName(Messages.RemoteRunLaunchDelegate_2);
        boolean skipDownload = config.getAttribute(IRemoteTEConfigurationConstants.ATTR_SKIP_DOWNLOAD_TO_TARGET, false);
        if (!skipDownload) {
            TEHelper.remoteFileTransfer(peer, exePath.toString(), remoteExePath, new SubProgressMonitor(monitor, 80));
        }
        String gdbserverPortNumber = config.getAttribute(IRemoteTEConfigurationConstants.ATTR_GDBSERVER_PORT, "2345");
        String gdbserverCommand = config.getAttribute(IRemoteTEConfigurationConstants.ATTR_GDBSERVER_COMMAND, "gdbserver");
        String commandArguments = ":" + gdbserverPortNumber + " " + TEHelper.spaceEscapify(remoteExePath);
        String arguments = this.getProgramArguments(config);
        String prelaunchCmd = config.getAttribute(IRemoteTEConfigurationConstants.ATTR_PRERUN_COMMANDS, "");
        TEHelper.launchCmd(peer, prelaunchCmd, null, new SubProgressMonitor(monitor, 2), (ICallback)new Callback());
        if (arguments != null && !arguments.equals("")) {
            commandArguments = String.valueOf(commandArguments) + " " + arguments;
        }
        monitor.setTaskName(Messages.RemoteRunLaunchDelegate_9);
        final GdbLaunch l = (GdbLaunch)launch;
        Callback callback = new Callback(){

            protected void internalDone(Object caller, IStatus status) {
                if (!status.isOK()) {
                    try {
                        l.getSession().getExecutor().execute((Runnable)new DsfRunnable(){

                            public void run() {
                                l.shutdownSession((RequestMonitor)new ImmediateRequestMonitor());
                            }
                        });
                    }
                    catch (RejectedExecutionException rejectedExecutionException) {}
                }
                super.internalDone(caller, status);
            }
        };
        final boolean[] gdbServerReady = new boolean[]{false};
        final Object lock = new Object();
        StreamsDataReceiver.Listener listener = new StreamsDataReceiver.Listener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void dataReceived(String data) {
                if (data.contains("Listening on port")) {
                    Object object = lock;
                    synchronized (object) {
                        gdbServerReady[0] = true;
                        lock.notifyAll();
                    }
                }
            }
        };
        TEHelper.launchCmd(peer, gdbserverCommand, commandArguments, listener, new SubProgressMonitor(monitor, 3), (ICallback)callback);
        Object object = lock;
        synchronized (object) {
            while (!gdbServerReady[0]) {
                if (monitor.isCanceled()) {
                    try {
                        l.getSession().getExecutor().execute((Runnable)new DsfRunnable(){

                            public void run() {
                                l.shutdownSession((RequestMonitor)new ImmediateRequestMonitor());
                            }
                        });
                    }
                    catch (RejectedExecutionException rejectedExecutionException) {}
                    this.abort(Messages.RemoteGdbLaunchDelegate_gdbserverFailedToStartErrorMessage, null, 106);
                }
                try {
                    lock.wait(300L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        ILaunchConfigurationWorkingCopy wc = config.getWorkingCopy();
        wc.setAttribute("org.eclipse.cdt.dsf.gdb.REMOTE_TCP", true);
        wc.setAttribute("org.eclipse.cdt.dsf.gdb.HOST", (String)TEHelper.getCurrentConnection(config).getPeer().getAttributes().get("Host"));
        wc.setAttribute("org.eclipse.cdt.dsf.gdb.PORT", gdbserverPortNumber);
        wc.doSave();
        try {
            super.launch(config, mode, launch, monitor);
            return;
        }
        finally {
            monitor.done();
        }
    }

    protected String getProgramArguments(ILaunchConfiguration config) throws CoreException {
        String args = config.getAttribute("org.eclipse.cdt.launch.PROGRAM_ARGUMENTS", null);
        if (args != null) {
            args = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(args);
        }
        return args;
    }

    protected String getPluginID() {
        return "org.eclipse.tcf.te.tcf.launch.cdt";
    }
}

