/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.locator.services;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.Status;
import org.eclipse.tcf.protocol.IPeer;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.te.runtime.interfaces.callback.ICallback;
import org.eclipse.tcf.te.tcf.core.Tcf;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.ILocatorModel;
import org.eclipse.tcf.te.tcf.locator.interfaces.services.ILocatorModelLookupService;
import org.eclipse.tcf.te.tcf.locator.interfaces.services.ILocatorModelRefreshService;
import org.eclipse.tcf.te.tcf.locator.interfaces.services.ILocatorModelUpdateService;
import org.eclipse.tcf.te.tcf.locator.services.AbstractLocatorModelService;

public class LocatorModelRefreshService
extends AbstractLocatorModelService
implements ILocatorModelRefreshService {
    public LocatorModelRefreshService(ILocatorModel parentModel) {
        super(parentModel);
    }

    protected final void invokeCallback(final ICallback callback) {
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        if (callback != null) {
            Protocol.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    callback.done((Object)LocatorModelRefreshService.this, Status.OK_STATUS);
                }
            });
        }
    }

    @Override
    public void refresh(ICallback callback) {
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        ILocatorModel model = this.getLocatorModel();
        if (model.isDisposed()) {
            this.invokeCallback(callback);
            return;
        }
        if (!Tcf.isRunning()) {
            this.invokeCallback(callback);
            return;
        }
        ArrayList<IPeer> oldChildren = new ArrayList<IPeer>(Arrays.asList(model.getPeers()));
        this.processPeers(Protocol.getLocator().getPeers(), oldChildren, model);
        for (IPeer oldChild : oldChildren) {
            model.getService(ILocatorModelUpdateService.class).remove(oldChild);
        }
        this.invokeCallback(callback);
    }

    protected void processPeers(Map<String, IPeer> peers, List<IPeer> oldChildren, ILocatorModel model) {
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        Assert.isNotNull(peers);
        Assert.isNotNull(oldChildren);
        Assert.isNotNull((Object)model);
        for (Map.Entry<String, IPeer> entry : peers.entrySet()) {
            IPeer peer = entry.getValue();
            if (this.isFiltered(peer)) continue;
            IPeer lkupPeer = model.getService(ILocatorModelLookupService.class).lkupPeerById(entry.getKey());
            if (lkupPeer == null) {
                lkupPeer = model.validatePeer(peer);
                if (lkupPeer == null) continue;
                model.getService(ILocatorModelUpdateService.class).add(lkupPeer);
                continue;
            }
            oldChildren.remove(peer);
        }
    }

    private boolean isFiltered(IPeer peer) {
        boolean filtered;
        boolean bl = filtered = peer == null;
        if (!filtered) {
            String value = (String)peer.getAttributes().get("ValueAdd");
            boolean isValueAdd = value != null && ("1".equals(value.trim()) || Boolean.parseBoolean(value.trim()));
            filtered |= isValueAdd;
            filtered |= peer.getName() != null && (peer.getName().endsWith("Command Server") || peer.getName().endsWith("CLI Server"));
        }
        return filtered;
    }
}

