/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.locator.steps;

import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.tcf.protocol.IChannel;
import org.eclipse.tcf.protocol.IToken;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.services.IDiagnostics;
import org.eclipse.tcf.te.runtime.interfaces.callback.ICallback;
import org.eclipse.tcf.te.runtime.interfaces.properties.IPropertiesContainer;
import org.eclipse.tcf.te.runtime.stepper.StepperAttributeUtil;
import org.eclipse.tcf.te.runtime.stepper.interfaces.IFullQualifiedId;
import org.eclipse.tcf.te.runtime.stepper.interfaces.IStepContext;
import org.eclipse.tcf.te.tcf.locator.activator.CoreBundleActivator;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerNode;
import org.eclipse.tcf.te.tcf.locator.nls.Messages;
import org.eclipse.tcf.te.tcf.locator.steps.AbstractPeerNodeStep;
import org.eclipse.tcf.te.tcf.locator.utils.SimulatorUtils;
import org.osgi.framework.Bundle;

public class StartPingTimerStep
extends AbstractPeerNodeStep {
    public void validateExecute(IStepContext context, IPropertiesContainer data, IFullQualifiedId fullQualifiedId, IProgressMonitor monitor) throws CoreException {
        IChannel channel = (IChannel)StepperAttributeUtil.getProperty((String)"org.eclipse.tcf.te.tcf.locator.channel", (IFullQualifiedId)fullQualifiedId, (IPropertiesContainer)data);
        if (channel == null || channel.getState() != 1) {
            throw new CoreException((IStatus)new Status(4, CoreBundleActivator.getUniqueIdentifier(), "missing or closed channel"));
        }
    }

    public void execute(final IStepContext context, final IPropertiesContainer data, final IFullQualifiedId fullQualifiedId, IProgressMonitor monitor, ICallback callback) {
        SimulatorUtils.Result result = SimulatorUtils.getSimulatorService(this.getActivePeerModelContext(context, data, fullQualifiedId));
        if (result == null) {
            final IChannel channel = (IChannel)StepperAttributeUtil.getProperty((String)"org.eclipse.tcf.te.tcf.locator.channel", (IFullQualifiedId)fullQualifiedId, (IPropertiesContainer)data);
            Protocol.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    final IPeerNode peerNode = StartPingTimerStep.this.getActivePeerModelContext(context, data, fullQualifiedId);
                    String name = peerNode.getName();
                    final IDiagnostics diagnostics = (IDiagnostics)channel.getRemoteService(IDiagnostics.class);
                    if (diagnostics != null) {
                        Timer pingTimer = new Timer(String.valueOf(name) + " ping");
                        TimerTask pingTask = new TimerTask(pingTimer){
                            final Timer thisTimer;
                            final AtomicBoolean running;
                            {
                                this.thisTimer = timer;
                                this.running = new AtomicBoolean(false);
                            }

                            @Override
                            public void run() {
                                try {
                                    if (!this.running.get()) {
                                        this.running.set(true);
                                        Protocol.invokeLater((Runnable)new Runnable(){

                                            @Override
                                            public void run() {
                                                try {
                                                    if (peerNode.getConnectState() == 11) {
                                                        diagnostics.echo("ping", new IDiagnostics.DoneEcho(){

                                                            public void doneEcho(IToken token, Throwable error, String s) {
                                                                running.set(false);
                                                                if (error != null) {
                                                                    thisTimer.cancel();
                                                                }
                                                            }
                                                        });
                                                    } else {
                                                        thisTimer.cancel();
                                                    }
                                                }
                                                catch (Throwable throwable) {}
                                            }
                                        });
                                    }
                                }
                                catch (Throwable throwable) {}
                            }
                        };
                        pingTimer.schedule(pingTask, 10000L, 10000L);
                    } else if (Platform.inDebugMode()) {
                        Platform.getLog((Bundle)CoreBundleActivator.getDefault().getBundle()).log((IStatus)new Status(2, CoreBundleActivator.getUniqueIdentifier(), NLS.bind((String)Messages.StartPingTimerStep_warning_noDiagnosticsService, (Object)name)));
                    }
                }
            });
        }
        this.callback(data, fullQualifiedId, callback, Status.OK_STATUS, null);
    }
}

