/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.locator.utils;

import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.tcf.protocol.IPeer;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.te.runtime.callback.Callback;
import org.eclipse.tcf.te.runtime.interfaces.callback.ICallback;
import org.eclipse.tcf.te.runtime.services.ServiceManager;
import org.eclipse.tcf.te.runtime.services.interfaces.IService;
import org.eclipse.tcf.te.runtime.services.interfaces.ISimulatorService;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerNode;

public final class SimulatorUtils {
    public static boolean isSimulatorEnabled(final IPeerNode peerNode) {
        Assert.isNotNull((Object)peerNode);
        final AtomicBoolean isEnabled = new AtomicBoolean(false);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                String value = (String)peerNode.getPeer().getAttributes().get("SimulatorEnabled");
                if (value != null) {
                    isEnabled.set(Boolean.parseBoolean(value));
                }
            }
        };
        if (Protocol.isDispatchThread()) {
            runnable.run();
        } else {
            Protocol.invokeAndWait((Runnable)runnable);
        }
        return isEnabled.get();
    }

    public static Result getSimulatorService(IPeerNode peerNode) {
        Assert.isNotNull((Object)peerNode);
        Result result = null;
        IPeer peer = peerNode.getPeer();
        if (peer != null) {
            boolean isEnabled = false;
            String value = (String)peer.getAttributes().get("SimulatorEnabled");
            if (value != null) {
                isEnabled = Boolean.parseBoolean(value);
            }
            String type = (String)peer.getAttributes().get("SimulatorType");
            String properties = (String)peer.getAttributes().get("SimulatorProperties");
            if (isEnabled) {
                IService[] services;
                IService[] iServiceArray = services = ServiceManager.getInstance().getServices((Object)peerNode, ISimulatorService.class, false);
                int n = services.length;
                int n2 = 0;
                while (n2 < n) {
                    IService service = iServiceArray[n2];
                    Assert.isTrue((boolean)(service instanceof ISimulatorService));
                    String id = service.getId();
                    if (id != null && id.equals(type)) {
                        result = new Result();
                        result.service = (ISimulatorService)service;
                        result.id = id;
                        result.settings = properties;
                        break;
                    }
                    ++n2;
                }
            }
        }
        return result;
    }

    public static void start(final IPeerNode peerNode, final IProgressMonitor monitor, final ICallback callback) {
        Assert.isNotNull((Object)peerNode);
        Assert.isNotNull((Object)callback);
        final Result result = SimulatorUtils.getSimulatorService(peerNode);
        if (result != null && result.service != null) {
            result.service.isRunning((Object)peerNode, result.settings, (ICallback)new Callback(){

                protected void internalDone(Object caller, IStatus status) {
                    Object cbResult = this.getResult();
                    if (cbResult instanceof Boolean && !((Boolean)cbResult).booleanValue()) {
                        result.service.start((Object)peerNode, result.settings, (ICallback)new Callback(){

                            protected void internalDone(Object caller, IStatus status) {
                                callback.setResult((Object)new Boolean(status.isOK()));
                                callback.done(caller, status);
                            }
                        }, monitor);
                    } else {
                        callback.setResult((Object)Boolean.FALSE);
                        callback.done((Object)this, Status.OK_STATUS);
                    }
                }
            }, monitor);
        } else {
            callback.setResult((Object)Boolean.FALSE);
            callback.done(null, Status.OK_STATUS);
        }
    }

    public static void stop(final IPeerNode peerNode, final IProgressMonitor monitor, final ICallback callback) {
        Assert.isNotNull((Object)peerNode);
        Assert.isNotNull((Object)callback);
        final Result result = SimulatorUtils.getSimulatorService(peerNode);
        if (result != null && result.service != null) {
            result.service.isRunning((Object)peerNode, result.settings, (ICallback)new Callback(){

                protected void internalDone(Object caller, IStatus status) {
                    Object cbResult = this.getResult();
                    if (cbResult instanceof Boolean && ((Boolean)cbResult).booleanValue()) {
                        result.service.stop((Object)peerNode, result.settings, (ICallback)new Callback(callback){

                            protected void internalDone(Object caller, IStatus status) {
                                callback.done(caller, status);
                            }
                        }, monitor);
                    } else {
                        callback.done(null, Status.OK_STATUS);
                    }
                }
            }, monitor);
        } else {
            callback.done(null, Status.OK_STATUS);
        }
    }

    public static class Result {
        public ISimulatorService service;
        public String id;
        public String settings;
    }
}

