/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.processes.core.steps;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.tcf.protocol.IChannel;
import org.eclipse.tcf.protocol.IToken;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.services.IProcesses;
import org.eclipse.tcf.te.runtime.callback.Callback;
import org.eclipse.tcf.te.runtime.interfaces.callback.ICallback;
import org.eclipse.tcf.te.runtime.interfaces.properties.IPropertiesContainer;
import org.eclipse.tcf.te.runtime.model.interfaces.IModelNode;
import org.eclipse.tcf.te.runtime.stepper.StepperAttributeUtil;
import org.eclipse.tcf.te.runtime.stepper.interfaces.IFullQualifiedId;
import org.eclipse.tcf.te.runtime.stepper.interfaces.IStepContext;
import org.eclipse.tcf.te.tcf.core.model.interfaces.IModel;
import org.eclipse.tcf.te.tcf.core.model.interfaces.services.IModelRefreshService;
import org.eclipse.tcf.te.tcf.locator.steps.AbstractPeerNodeStep;
import org.eclipse.tcf.te.tcf.processes.core.activator.CoreBundleActivator;
import org.eclipse.tcf.te.tcf.processes.core.model.interfaces.IProcessContextNode;

public class AttachContextStep
extends AbstractPeerNodeStep {
    public void validateExecute(IStepContext context, IPropertiesContainer data, IFullQualifiedId fullQualifiedId, IProgressMonitor monitor) throws CoreException {
        IChannel channel = (IChannel)StepperAttributeUtil.getProperty((String)"org.eclipse.tcf.te.tcf.locator.channel", (IFullQualifiedId)fullQualifiedId, (IPropertiesContainer)data);
        if (channel == null || channel.getState() != 1) {
            throw new CoreException((IStatus)new Status(4, CoreBundleActivator.getUniqueIdentifier(), "missing or closed channel"));
        }
        IProcesses.ProcessContext processContext = (IProcesses.ProcessContext)StepperAttributeUtil.getProperty((String)"org.eclipse.tcf.te.tcf.processes.core.process_context", (IFullQualifiedId)fullQualifiedId, (IPropertiesContainer)data);
        if (processContext == null) {
            throw new CoreException((IStatus)new Status(4, CoreBundleActivator.getUniqueIdentifier(), "missing process context"));
        }
    }

    public void execute(final IStepContext context, final IPropertiesContainer data, final IFullQualifiedId fullQualifiedId, final IProgressMonitor monitor, final ICallback callback) {
        if (Protocol.isDispatchThread()) {
            this.internalExecute(context, data, fullQualifiedId, monitor, callback);
        } else {
            Protocol.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    AttachContextStep.this.internalExecute(context, data, fullQualifiedId, monitor, callback);
                }
            });
        }
    }

    protected void internalExecute(IStepContext context, final IPropertiesContainer data, final IFullQualifiedId fullQualifiedId, IProgressMonitor monitor, final ICallback callback) {
        IChannel channel = (IChannel)StepperAttributeUtil.getProperty((String)"org.eclipse.tcf.te.tcf.locator.channel", (IFullQualifiedId)fullQualifiedId, (IPropertiesContainer)data);
        IProcesses.ProcessContext processContext = (IProcesses.ProcessContext)StepperAttributeUtil.getProperty((String)"org.eclipse.tcf.te.tcf.processes.core.process_context", (IFullQualifiedId)fullQualifiedId, (IPropertiesContainer)data);
        final IProcessContextNode processContextNode = (IProcessContextNode)StepperAttributeUtil.getProperty((String)"org.eclipse.tcf.te.tcf.processes.core.process_context_node", (IFullQualifiedId)fullQualifiedId, (IPropertiesContainer)data);
        IProcesses processes = (IProcesses)channel.getRemoteService(IProcesses.class);
        if (processes != null) {
            processContext.attach(new IProcesses.DoneCommand(){

                public void doneCommand(IToken token, Exception error) {
                    if (processContextNode != null) {
                        IModel model = (IModel)processContextNode.getParent(IModel.class);
                        Assert.isNotNull((Object)model);
                        ((IModelRefreshService)model.getService(IModelRefreshService.class)).refresh((IModelNode)processContextNode, (ICallback)new Callback(){

                            protected void internalDone(Object caller, IStatus status) {
                                AttachContextStep.this.callback(data, fullQualifiedId, callback, Status.OK_STATUS, null);
                            }
                        });
                    } else {
                        AttachContextStep.this.callback(data, fullQualifiedId, callback, Status.OK_STATUS, null);
                    }
                }
            });
        } else {
            callback.done((Object)this, (IStatus)new Status(4, CoreBundleActivator.getUniqueIdentifier(), "missing processes service"));
        }
    }
}

