/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.processes.ui.handler;

import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.Assert;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.te.runtime.callback.AsyncCallbackCollector;
import org.eclipse.tcf.te.runtime.concurrent.util.ExecutorsUtil;
import org.eclipse.tcf.te.runtime.interfaces.IConditionTester;
import org.eclipse.tcf.te.runtime.interfaces.callback.ICallback;
import org.eclipse.tcf.te.runtime.services.ServiceManager;
import org.eclipse.tcf.te.runtime.services.interfaces.IUIService;
import org.eclipse.tcf.te.tcf.core.model.interfaces.services.IModelRefreshService;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerNode;
import org.eclipse.tcf.te.tcf.processes.core.model.ModelManager;
import org.eclipse.tcf.te.tcf.processes.core.model.interfaces.runtime.IRuntimeModel;
import org.eclipse.tcf.te.tcf.processes.ui.interfaces.IProcessMonitorUIDelegate;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.menus.UIElement;

public class RefreshProcessListHandler
extends AbstractHandler
implements IElementUpdater {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IEditorInput editorInput = HandlerUtil.getActiveEditorInputChecked((ExecutionEvent)event);
        final IPeerNode peer = (IPeerNode)editorInput.getAdapter(IPeerNode.class);
        if (peer != null) {
            BusyIndicator.showWhile((Display)PlatformUI.getWorkbench().getDisplay(), (Runnable)new Runnable(){

                @Override
                public void run() {
                    AsyncCallbackCollector collector = new AsyncCallbackCollector();
                    AsyncCallbackCollector.SimpleCollectorCallback callback = new AsyncCallbackCollector.SimpleCollectorCallback(collector);
                    Runnable runnable = new Runnable((ICallback)callback){
                        private final /* synthetic */ ICallback val$callback;
                        {
                            this.val$callback = iCallback;
                        }

                        @Override
                        public void run() {
                            IRuntimeModel model = ModelManager.getRuntimeModel((IPeerNode)peer);
                            Assert.isNotNull((Object)model);
                            ((IModelRefreshService)model.getService(IModelRefreshService.class)).refresh(this.val$callback);
                        }
                    };
                    Protocol.invokeLater((Runnable)runnable);
                    collector.initDone();
                    ExecutorsUtil.waitAndExecute((long)0L, (IConditionTester)collector.getConditionTester());
                }
            });
        }
        return null;
    }

    public void updateElement(UIElement element, Map parameters) {
        IWorkbenchPart part;
        IWorkbenchPartSite site = (IWorkbenchPartSite)parameters.get("org.eclipse.ui.part.IWorkbenchPartSite");
        if (site != null && (part = site.getPart()) instanceof IEditorPart) {
            IProcessMonitorUIDelegate delegate;
            IEditorInput editorInput = ((IEditorPart)part).getEditorInput();
            IPeerNode node = editorInput != null ? (IPeerNode)editorInput.getAdapter(IPeerNode.class) : null;
            IUIService service = (IUIService)ServiceManager.getInstance().getService((Object)node, IUIService.class);
            IProcessMonitorUIDelegate iProcessMonitorUIDelegate = delegate = service != null ? (IProcessMonitorUIDelegate)service.getDelegate((Object)node, IProcessMonitorUIDelegate.class) : null;
            if (delegate != null) {
                String tooltip;
                String text = delegate.getMessage("RefreshProcessListHandler_updateElement_text");
                if (text != null) {
                    element.setText(text);
                }
                if ((tooltip = delegate.getMessage("RefreshProcessListHandler_updateElement_tooltip")) != null) {
                    element.setTooltip(tooltip);
                }
            }
        }
    }
}

