/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.ui.controls;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Control;
import org.eclipse.tcf.te.runtime.services.ServiceManager;
import org.eclipse.tcf.te.runtime.services.interfaces.IService;
import org.eclipse.tcf.te.runtime.services.interfaces.ISimulatorService;
import org.eclipse.tcf.te.runtime.services.interfaces.IUIService;
import org.eclipse.tcf.te.tcf.ui.nls.Messages;
import org.eclipse.tcf.te.tcf.ui.sections.SimulatorTypeSelectionSection;
import org.eclipse.tcf.te.ui.controls.BaseEditBrowseTextControl;
import org.eclipse.tcf.te.ui.interfaces.services.ISimulatorServiceUIDelegate;
import org.eclipse.tcf.te.ui.jface.interfaces.IValidatingContainer;
import org.eclipse.tcf.te.ui.swt.SWTControlUtil;

public class SimulatorTypeSelectionControl
extends BaseEditBrowseTextControl {
    private final Map<String, ISimulatorServiceUIDelegate> id2delegate = new HashMap<String, ISimulatorServiceUIDelegate>();
    private final Map<String, String> name2id = new HashMap<String, String>();
    private final Map<String, String> id2name = new HashMap<String, String>();
    private final Map<String, String> id2config = new HashMap<String, String>();
    private final SimulatorTypeSelectionSection parentSection;

    public SimulatorTypeSelectionControl(SimulatorTypeSelectionSection parentSection) {
        super(null);
        Assert.isNotNull((Object)((Object)parentSection));
        this.parentSection = parentSection;
        this.setIsGroup(false);
        this.setEditFieldLabel(Messages.SimulatorTypeSelectionControl_label);
        this.setButtonLabel(Messages.SimulatorTypeSelectionControl_button_configure);
        this.setHasHistory(true);
        this.setReadOnly(true);
    }

    public void initialize(Object context) {
        SWTControlUtil.removeAll((Control)this.getEditFieldControl());
        this.id2delegate.clear();
        this.name2id.clear();
        this.id2name.clear();
        this.id2config.clear();
        ArrayList<String> entries = new ArrayList<String>();
        if (context != null) {
            IService[] services;
            IService[] iServiceArray = services = ServiceManager.getInstance().getServices(context, ISimulatorService.class, false);
            int n = services.length;
            int n2 = 0;
            while (n2 < n) {
                IService service = iServiceArray[n2];
                Assert.isTrue((boolean)(service instanceof ISimulatorService));
                IUIService uiService = (IUIService)ServiceManager.getInstance().getService((Object)service, IUIService.class);
                if (uiService != null) {
                    ISimulatorServiceUIDelegate uiDelegate = (ISimulatorServiceUIDelegate)uiService.getDelegate((Object)service, ISimulatorServiceUIDelegate.class);
                    String id = service.getId();
                    String name = uiDelegate != null ? uiDelegate.getName() : id;
                    this.id2delegate.put(id, uiDelegate);
                    this.name2id.put(name, id);
                    this.id2name.put(id, name);
                    if (!entries.contains(name)) {
                        entries.add(name);
                    }
                }
                ++n2;
            }
        }
        SWTControlUtil.setItems((Control)this.getEditFieldControl(), (String[])entries.toArray(new String[entries.size()]));
        SWTControlUtil.select((Control)this.getEditFieldControl(), (int)0);
        if (this.getEditFieldControl() != null && this.getEditFieldControl().getLayoutData() instanceof GridData) {
            this.doAdjustEditFieldControlLayoutData((GridData)this.getEditFieldControl().getLayoutData());
        }
    }

    protected void doAdjustEditFieldControlLayoutData(GridData layoutData) {
        super.doAdjustEditFieldControlLayoutData(layoutData);
        int maxWidth = -1;
        String[] stringArray = SWTControlUtil.getItems((Control)this.getEditFieldControl());
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String item = stringArray[n2];
            maxWidth = Math.max(item.length(), maxWidth);
            ++n2;
        }
        if (maxWidth != -1) {
            layoutData.horizontalAlignment = 32;
            layoutData.grabExcessHorizontalSpace = false;
            layoutData.widthHint = SWTControlUtil.convertWidthInCharsToPixels((Control)this.getEditFieldControl(), (int)(maxWidth + 10));
        }
    }

    public IValidatingContainer getValidatingContainer() {
        Object container = this.parentSection.getManagedForm().getContainer();
        return container instanceof IValidatingContainer ? (IValidatingContainer)container : null;
    }

    protected void onButtonControlSelected() {
        ISimulatorServiceUIDelegate uiDelegate = this.id2delegate.get(this.getSelectedSimulatorId());
        if (uiDelegate != null) {
            String oldConfig = this.getSimulatorConfig();
            String newConfig = uiDelegate.configure(this.parentSection.getOriginalData(), oldConfig);
            if (oldConfig != null && !oldConfig.equals(newConfig) || newConfig != null && !newConfig.equals(oldConfig)) {
                this.id2config.put(this.getSelectedSimulatorId(), newConfig);
                this.parentSection.dataChanged(null);
            }
        }
    }

    public void setSelectedSimulatorId(String id) {
        int index;
        String name = this.id2name.get(id);
        if (name != null && name.trim().length() > 0 && (index = ((Combo)this.getEditFieldControl()).indexOf(name)) >= 0) {
            SWTControlUtil.select((Control)this.getEditFieldControl(), (int)index);
        }
    }

    public String getSelectedSimulatorId() {
        return this.name2id.get(this.getEditFieldControlText());
    }

    public void setSimulatorConfig(String config) {
        this.id2config.put(this.getSelectedSimulatorId(), config);
    }

    public String getSimulatorConfig() {
        String config = this.id2config.get(this.getSelectedSimulatorId());
        ISimulatorServiceUIDelegate uiDelegate = this.id2delegate.get(this.getSelectedSimulatorId());
        if (uiDelegate != null && (config == null || config.trim().length() == 0)) {
            config = uiDelegate.getService().getDefaultConfig();
        }
        return config;
    }

    private void setConfigureEnabled(boolean enabled) {
        String id = this.getSelectedSimulatorId();
        ISimulatorServiceUIDelegate uiDelegate = this.id2delegate.get(id);
        if (this.getButtonControl() != null) {
            this.getButtonControl().setEnabled(enabled && uiDelegate != null && uiDelegate.canConfigure());
            if (this.getButtonControl().isEnabled() && uiDelegate != null) {
                String config = this.id2config.get(this.getSelectedSimulatorId());
                String description = uiDelegate.getDescription(config);
                this.getButtonControl().setToolTipText(description);
            } else {
                this.getButtonControl().setToolTipText(null);
            }
        }
    }

    public void widgetSelected(SelectionEvent e) {
        super.widgetSelected(e);
        this.setConfigureEnabled(this.isEnabled());
        this.parentSection.dataChanged((TypedEvent)e);
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.setConfigureEnabled(enabled);
    }

    protected void onLabelControlSelectedChanged() {
        super.onLabelControlSelectedChanged();
        this.setConfigureEnabled(this.isLabelControlSelected());
        this.parentSection.dataChanged(null);
    }

    public boolean isValid() {
        boolean valid = super.isValid();
        if (valid) {
            boolean isDefaultConfig;
            ISimulatorServiceUIDelegate uiDelegate = this.id2delegate.get(this.getSelectedSimulatorId());
            String config = this.getSimulatorConfig();
            String defaultConfig = uiDelegate != null ? uiDelegate.getService().getDefaultConfig() : null;
            valid = uiDelegate != null ? uiDelegate.getService().isValidConfig(this.parentSection.getOriginalData(), config) : true;
            boolean bl = isDefaultConfig = defaultConfig != null && defaultConfig.equals(config) || defaultConfig == null && config == null;
            if (!valid) {
                this.setMessage(Messages.SimulatorTypeSelectionControl_error_invalidConfiguration, isDefaultConfig ? 1 : 3);
            }
        }
        if (this.getControlDecoration() != null) {
            if (this.isEnabled() && (!valid || this.getMessage() != null && this.getMessageType() != 0)) {
                this.updateControlDecoration(this.getMessage(), this.getMessageType());
            } else {
                this.updateControlDecoration(null, 0);
            }
        }
        return valid;
    }
}

